/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.SubDataFieldLocation;
import java.math.BigInteger;

public class SubDataFieldFactory
extends OperandFieldFactory {
    private int[] componentPath;

    public SubDataFieldFactory(String name, int[] path) {
        this.componentPath = path;
        this.name = name;
    }

    private SubDataFieldFactory(String name, int[] componentPath, FieldFormatModel model, ListingHighlightProvider hlProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        super(model, hlProvider, displayOptions, fieldOptions);
        this.name = name;
        this.componentPath = componentPath;
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Data data;
        Data subData;
        Object obj = proxy.getObject();
        if (obj instanceof Data && (subData = this.getComponent(data = (Data)obj, this.componentPath)) != null) {
            return super.getField(subData, proxy, varWidth);
        }
        return null;
    }

    private Data getComponent(Data data, int[] path) {
        for (int element : path) {
            Data d = data.getComponent(element);
            if (d == null) {
                return data;
            }
            data = d;
        }
        return data;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Data) {
            Object value;
            Data data = (Data)obj;
            Data subData = this.getComponent(data, this.componentPath);
            Address refAddr = null;
            if (subData != null && (value = subData.getValue()) instanceof Address) {
                refAddr = (Address)value;
            }
            return new SubDataFieldLocation(data.getProgram(), data.getMinAddress(), null, data.getComponentPath(), refAddr, this.codeUnitFormat.getDataValueRepresentationString(data), col, this.getFieldName());
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof SubDataFieldLocation)) {
            return null;
        }
        SubDataFieldLocation subLoc = (SubDataFieldLocation)loc;
        if (!subLoc.getFieldName().equals(this.getFieldName())) {
            return null;
        }
        if (!this.hasSamePath(bf, loc)) {
            return null;
        }
        return this.getFieldLocation(index, fieldNum, bf, 0, subLoc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return false;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions options, ToolOptions fieldOptions) {
        return new SubDataFieldFactory(this.name, this.componentPath, formatModel, provider, options, fieldOptions);
    }
}

