/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayConverter;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.DataConverter;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ImportByName
implements StructConverter,
ByteArrayConverter {
    public static final String NAME = "IMAGE_IMPORT_BY_NAME";
    private short hint;
    private String name;

    ImportByName(BinaryReader reader, int index) throws IOException {
        this.hint = reader.readShort(index);
        this.name = reader.readAsciiString(index + 2);
    }

    public ImportByName(short hint, String name) {
        this.hint = hint;
        this.name = name;
    }

    public short getHint() {
        return this.hint;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        int len = this.name.length() + 1;
        StructureDataType struct = new StructureDataType("IMAGE_IMPORT_BY_NAME_" + len, 0);
        struct.add(WORD, "Hint", null);
        struct.add(STRING, len, "Name", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    @Override
    public byte[] toBytes(DataConverter dc) {
        byte[] bytes = new byte[this.getSizeOf()];
        dc.getBytes(this.hint, bytes, 0);
        byte[] nameBytes = this.name.getBytes();
        System.arraycopy(nameBytes, 0, bytes, 2, nameBytes.length);
        return bytes;
    }

    public int getSizeOf() {
        return 2 + this.name.length() + 1;
    }
}

