/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TwoLevelHint
implements StructConverter {
    public static final int SIZEOF = 4;
    private int isub_image;
    private int itoc;

    TwoLevelHint(BinaryReader reader) throws IOException {
        int value = reader.readNextInt();
        this.isub_image = value & 0xFF;
        this.itoc = value >> 8;
    }

    public int getSubImageIndex() {
        return this.isub_image;
    }

    public int getTableOfContentsIndex() {
        return this.itoc;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("twolevel_hint", 0);
        struct.add(DWORD, "isub_image_itoc", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

