/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommandTypes;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class LoadCommand
implements StructConverter {
    private long startIndex;
    private int cmd;
    private int cmdsize;

    public LoadCommand(BinaryReader reader) throws IOException {
        this.startIndex = reader.getPointerIndex();
        this.cmd = reader.readNextInt();
        this.cmdsize = reader.readNextInt();
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public int getCommandType() {
        return this.cmd;
    }

    public int getCommandSize() {
        return this.cmdsize;
    }

    public abstract String getCommandName();

    public long getLinkerDataOffset() {
        return 0L;
    }

    public long getLinkerDataSize() {
        return 0L;
    }

    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
    }

    protected void markupPlateComment(Program program, Address address, String source, String additionalDescription) {
        if (address == null) {
            return;
        }
        String comment = this.getContextualName(source, additionalDescription);
        program.getListing().setComment(address, CommentType.PLATE, comment);
    }

    protected String getContextualName(String source, String additionalDescription) {
        Object markupName = LoadCommandTypes.getLoadCommandName(this.getCommandType());
        if (additionalDescription != null && !additionalDescription.isBlank()) {
            markupName = (String)markupName + " (" + additionalDescription + ")";
        }
        if (source != null && !source.isBlank()) {
            markupName = (String)markupName + " - " + source;
        }
        return markupName;
    }

    protected Address fileOffsetToAddress(Program program, MachHeader header, long fileOffset, long size) {
        if (fileOffset != 0L && size != 0L) {
            AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
            SegmentCommand segment = null;
            if (this.getLinkerDataOffset() != 0L) {
                segment = header.getSegment("__LINKEDIT");
            }
            if (segment == null) {
                segment = this.getContainingSegment(header, fileOffset);
            }
            if (segment != null) {
                return space.getAddress(segment.getVMaddress() + (fileOffset - segment.getFileOffset()));
            }
        }
        return null;
    }

    protected long checkCount(long count) throws IOException {
        if (count > Integer.MAX_VALUE) {
            throw new IOException("Count value 0x%x in %s is greater than Integer.MAX_VALUE".formatted(count, this.getClass().getSimpleName()));
        }
        return count;
    }

    private SegmentCommand getContainingSegment(MachHeader header, long fileOffset) {
        for (SegmentCommand segment : header.getAllSegments()) {
            if (fileOffset < segment.getFileOffset() || fileOffset >= segment.getFileOffset() + segment.getFileSize()) continue;
            return segment;
        }
        return null;
    }

    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            this.createFragment(api, baseAddress, parentModule);
            Address addr = baseAddress.getNewAddress(this.getStartIndex());
            api.createData(addr, this.toDataType());
            this.createPlateComment(api, addr);
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }

    protected final ProgramFragment createFragment(FlatProgramAPI api, Address baseAddress, ProgramModule module) throws Exception {
        Address start = baseAddress.getNewAddress(this.getStartIndex());
        return api.createFragment(module, LoadCommandTypes.getLoadCommandName(this.getCommandType()), start, this.getCommandSize());
    }

    protected final void createPlateComment(FlatProgramAPI api, Address addr) {
        api.setPlateComment(addr, LoadCommandTypes.getLoadCommandName(this.getCommandType()));
    }

    protected final void updateMonitor(TaskMonitor monitor) {
        monitor.setMessage("Processing " + this.getCommandName() + "...");
    }
}

