/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperandType;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DWARFExpressionOpCodes {
    public static final int DW_OP_addr = 3;
    public static final int DW_OP_deref = 6;
    public static final int DW_OP_const1u = 8;
    public static final int DW_OP_const1s = 9;
    public static final int DW_OP_const2u = 10;
    public static final int DW_OP_const2s = 11;
    public static final int DW_OP_const4u = 12;
    public static final int DW_OP_const4s = 13;
    public static final int DW_OP_const8u = 14;
    public static final int DW_OP_const8s = 15;
    public static final int DW_OP_constu = 16;
    public static final int DW_OP_consts = 17;
    public static final int DW_OP_dup = 18;
    public static final int DW_OP_drop = 19;
    public static final int DW_OP_over = 20;
    public static final int DW_OP_pick = 21;
    public static final int DW_OP_swap = 22;
    public static final int DW_OP_rot = 23;
    public static final int DW_OP_xderef = 24;
    public static final int DW_OP_abs = 25;
    public static final int DW_OP_and = 26;
    public static final int DW_OP_div = 27;
    public static final int DW_OP_minus = 28;
    public static final int DW_OP_mod = 29;
    public static final int DW_OP_mul = 30;
    public static final int DW_OP_neg = 31;
    public static final int DW_OP_not = 32;
    public static final int DW_OP_or = 33;
    public static final int DW_OP_plus = 34;
    public static final int DW_OP_plus_uconst = 35;
    public static final int DW_OP_shl = 36;
    public static final int DW_OP_shr = 37;
    public static final int DW_OP_shra = 38;
    public static final int DW_OP_xor = 39;
    public static final int DW_OP_bra = 40;
    public static final int DW_OP_eq = 41;
    public static final int DW_OP_ge = 42;
    public static final int DW_OP_gt = 43;
    public static final int DW_OP_le = 44;
    public static final int DW_OP_lt = 45;
    public static final int DW_OP_ne = 46;
    public static final int DW_OP_skip = 47;
    public static final int DW_OP_lit0 = 48;
    public static final int DW_OP_lit1 = 49;
    public static final int DW_OP_lit2 = 50;
    public static final int DW_OP_lit3 = 51;
    public static final int DW_OP_lit4 = 52;
    public static final int DW_OP_lit5 = 53;
    public static final int DW_OP_lit6 = 54;
    public static final int DW_OP_lit7 = 55;
    public static final int DW_OP_lit8 = 56;
    public static final int DW_OP_lit9 = 57;
    public static final int DW_OP_lit10 = 58;
    public static final int DW_OP_lit11 = 59;
    public static final int DW_OP_lit12 = 60;
    public static final int DW_OP_lit13 = 61;
    public static final int DW_OP_lit14 = 62;
    public static final int DW_OP_lit15 = 63;
    public static final int DW_OP_lit16 = 64;
    public static final int DW_OP_lit17 = 65;
    public static final int DW_OP_lit18 = 66;
    public static final int DW_OP_lit19 = 67;
    public static final int DW_OP_lit20 = 68;
    public static final int DW_OP_lit21 = 69;
    public static final int DW_OP_lit22 = 70;
    public static final int DW_OP_lit23 = 71;
    public static final int DW_OP_lit24 = 72;
    public static final int DW_OP_lit25 = 73;
    public static final int DW_OP_lit26 = 74;
    public static final int DW_OP_lit27 = 75;
    public static final int DW_OP_lit28 = 76;
    public static final int DW_OP_lit29 = 77;
    public static final int DW_OP_lit30 = 78;
    public static final int DW_OP_lit31 = 79;
    public static final int DW_OP_reg0 = 80;
    public static final int DW_OP_reg1 = 81;
    public static final int DW_OP_reg2 = 82;
    public static final int DW_OP_reg3 = 83;
    public static final int DW_OP_reg4 = 84;
    public static final int DW_OP_reg5 = 85;
    public static final int DW_OP_reg6 = 86;
    public static final int DW_OP_reg7 = 87;
    public static final int DW_OP_reg8 = 88;
    public static final int DW_OP_reg9 = 89;
    public static final int DW_OP_reg10 = 90;
    public static final int DW_OP_reg11 = 91;
    public static final int DW_OP_reg12 = 92;
    public static final int DW_OP_reg13 = 93;
    public static final int DW_OP_reg14 = 94;
    public static final int DW_OP_reg15 = 95;
    public static final int DW_OP_reg16 = 96;
    public static final int DW_OP_reg17 = 97;
    public static final int DW_OP_reg18 = 98;
    public static final int DW_OP_reg19 = 99;
    public static final int DW_OP_reg20 = 100;
    public static final int DW_OP_reg21 = 101;
    public static final int DW_OP_reg22 = 102;
    public static final int DW_OP_reg23 = 103;
    public static final int DW_OP_reg24 = 104;
    public static final int DW_OP_reg25 = 105;
    public static final int DW_OP_reg26 = 106;
    public static final int DW_OP_reg27 = 107;
    public static final int DW_OP_reg28 = 108;
    public static final int DW_OP_reg29 = 109;
    public static final int DW_OP_reg30 = 110;
    public static final int DW_OP_reg31 = 111;
    public static final int DW_OP_breg0 = 112;
    public static final int DW_OP_breg1 = 113;
    public static final int DW_OP_breg2 = 114;
    public static final int DW_OP_breg3 = 115;
    public static final int DW_OP_breg4 = 116;
    public static final int DW_OP_breg5 = 117;
    public static final int DW_OP_breg6 = 118;
    public static final int DW_OP_breg7 = 119;
    public static final int DW_OP_breg8 = 120;
    public static final int DW_OP_breg9 = 121;
    public static final int DW_OP_breg10 = 122;
    public static final int DW_OP_breg11 = 123;
    public static final int DW_OP_breg12 = 124;
    public static final int DW_OP_breg13 = 125;
    public static final int DW_OP_breg14 = 126;
    public static final int DW_OP_breg15 = 127;
    public static final int DW_OP_breg16 = 128;
    public static final int DW_OP_breg17 = 129;
    public static final int DW_OP_breg18 = 130;
    public static final int DW_OP_breg19 = 131;
    public static final int DW_OP_breg20 = 132;
    public static final int DW_OP_breg21 = 133;
    public static final int DW_OP_breg22 = 134;
    public static final int DW_OP_breg23 = 135;
    public static final int DW_OP_breg24 = 136;
    public static final int DW_OP_breg25 = 137;
    public static final int DW_OP_breg26 = 138;
    public static final int DW_OP_breg27 = 139;
    public static final int DW_OP_breg28 = 140;
    public static final int DW_OP_breg29 = 141;
    public static final int DW_OP_breg30 = 142;
    public static final int DW_OP_breg31 = 143;
    public static final int DW_OP_regx = 144;
    public static final int DW_OP_fbreg = 145;
    public static final int DW_OP_bregx = 146;
    public static final int DW_OP_piece = 147;
    public static final int DW_OP_deref_size = 148;
    public static final int DW_OP_xderef_size = 149;
    public static final int DW_OP_nop = 150;
    public static final int DW_OP_push_object_address = 151;
    public static final int DW_OP_call2 = 152;
    public static final int DW_OP_call4 = 153;
    public static final int DW_OP_call_ref = 154;
    public static final int DW_OP_form_tls_address = 155;
    public static final int DW_OP_call_frame_cfa = 156;
    public static final int DW_OP_bit_piece = 157;
    public static final int DW_OP_implicit_value = 158;
    public static final int DW_OP_stack_value = 159;
    public static final int DW_OP_implicit_pointer = 160;
    public static final int DW_OP_addrx = 161;
    public static final int DW_OP_constx = 162;
    public static final int DW_OP_entry_value = 163;
    public static final int DW_OP_const_type = 164;
    public static final int DW_OP_regval_type = 165;
    public static final int DW_OP_deref_type = 166;
    public static final int DW_OP_xderef_type = 167;
    public static final int DW_OP_convert = 168;
    public static final int DW_OP_reinterpret = 169;
    public static final int DW_OP_lo_user = 224;
    public static final int DW_OP_hi_user = 255;
    public static final int[] UNSUPPORTED_OPCODES_LIST = new int[]{148, 24, 149, 151, 155, 152, 153, 154, 158, 160, 163, 164, 165, 166, 167, 168, 169};
    public static final Set<Integer> UNSUPPORTED_OPCODES = new HashSet<Integer>();
    static final Map<Integer, DWARFExpressionOperandType[]> OPtoOperandTypes;
    public static final DWARFExpressionOperandType[] EMPTY_OPERANDTYPES;
    public static final DWARFExpressionOperandType[] BLOBONLY_OPERANDTYPES;

    public static boolean isValidOpcode(int opcode) {
        Field field = DWARFUtil.getStaticFinalFieldWithValue(DWARFExpressionOpCodes.class, opcode);
        return field != null && field.getName().startsWith("DW_OP_");
    }

    private static void addOperandTypeMapping(int opcode, DWARFExpressionOperandType ... operandTypes) {
        OPtoOperandTypes.put(opcode, operandTypes);
    }

    private static void addOperandTypeMapping(int opcodeLow, int opcodeHigh, DWARFExpressionOperandType ... operandTypes) {
        for (int i = opcodeLow; i <= opcodeHigh; ++i) {
            OPtoOperandTypes.put(i, operandTypes);
        }
    }

    public static DWARFExpressionOperandType[] getOperandTypesFor(int opcode) {
        DWARFExpressionOperandType[] results = OPtoOperandTypes.get(opcode);
        return results != null ? results : EMPTY_OPERANDTYPES;
    }

    public static String toString(int opcode) {
        return DWARFUtil.toString(DWARFExpressionOpCodes.class, opcode);
    }

    static {
        for (int opcode : UNSUPPORTED_OPCODES) {
            UNSUPPORTED_OPCODES.add(opcode);
        }
        OPtoOperandTypes = new HashMap<Integer, DWARFExpressionOperandType[]>();
        DWARFExpressionOpCodes.addOperandTypeMapping(3, DWARFExpressionOperandType.ADDR);
        DWARFExpressionOpCodes.addOperandTypeMapping(8, DWARFExpressionOperandType.U_BYTE);
        DWARFExpressionOpCodes.addOperandTypeMapping(9, DWARFExpressionOperandType.S_BYTE);
        DWARFExpressionOpCodes.addOperandTypeMapping(10, DWARFExpressionOperandType.U_SHORT);
        DWARFExpressionOpCodes.addOperandTypeMapping(11, DWARFExpressionOperandType.S_SHORT);
        DWARFExpressionOpCodes.addOperandTypeMapping(12, DWARFExpressionOperandType.U_INT);
        DWARFExpressionOpCodes.addOperandTypeMapping(13, DWARFExpressionOperandType.S_INT);
        DWARFExpressionOpCodes.addOperandTypeMapping(14, DWARFExpressionOperandType.U_LONG);
        DWARFExpressionOpCodes.addOperandTypeMapping(15, DWARFExpressionOperandType.S_LONG);
        DWARFExpressionOpCodes.addOperandTypeMapping(16, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(17, DWARFExpressionOperandType.S_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(21, DWARFExpressionOperandType.U_BYTE);
        DWARFExpressionOpCodes.addOperandTypeMapping(35, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(47, DWARFExpressionOperandType.S_SHORT);
        DWARFExpressionOpCodes.addOperandTypeMapping(40, DWARFExpressionOperandType.S_SHORT);
        DWARFExpressionOpCodes.addOperandTypeMapping(112, 143, DWARFExpressionOperandType.S_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(144, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(145, DWARFExpressionOperandType.S_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(146, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.S_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(147, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(148, DWARFExpressionOperandType.U_BYTE);
        DWARFExpressionOpCodes.addOperandTypeMapping(149, DWARFExpressionOperandType.U_BYTE);
        DWARFExpressionOpCodes.addOperandTypeMapping(152, DWARFExpressionOperandType.U_SHORT);
        DWARFExpressionOpCodes.addOperandTypeMapping(153, DWARFExpressionOperandType.U_INT);
        DWARFExpressionOpCodes.addOperandTypeMapping(154, DWARFExpressionOperandType.DWARF_INT);
        DWARFExpressionOpCodes.addOperandTypeMapping(157, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(158, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.SIZED_BLOB);
        DWARFExpressionOpCodes.addOperandTypeMapping(160, DWARFExpressionOperandType.DWARF_INT, DWARFExpressionOperandType.S_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(161, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(162, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(163, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.SIZED_BLOB);
        DWARFExpressionOpCodes.addOperandTypeMapping(164, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.SIZED_BLOB);
        DWARFExpressionOpCodes.addOperandTypeMapping(165, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(166, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(167, DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(168, DWARFExpressionOperandType.U_LEB128);
        DWARFExpressionOpCodes.addOperandTypeMapping(169, DWARFExpressionOperandType.U_LEB128);
        EMPTY_OPERANDTYPES = new DWARFExpressionOperandType[0];
        BLOBONLY_OPERANDTYPES = new DWARFExpressionOperandType[]{DWARFExpressionOperandType.SIZED_BLOB};
    }
}

