/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class ExternalDebugFileSymbolImporter {
    private Program program;
    private Program externalDebugProgram;
    private SymbolTable symTable;
    private FunctionManager funcMgr;
    private SymbolTable extSymTable;
    private TaskMonitor monitor;
    private int funcSymbolsCopied;
    private int dataSymbolsCopied;
    private int symbolsSkipped;
    private int totalSymbolCount;

    public ExternalDebugFileSymbolImporter(Program program, Program externalDebugProgram, TaskMonitor monitor) {
        this.program = program;
        this.externalDebugProgram = externalDebugProgram;
        this.monitor = monitor;
        this.symTable = program.getSymbolTable();
        this.funcMgr = program.getFunctionManager();
        this.extSymTable = externalDebugProgram.getSymbolTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importSymbols(MessageLog log) throws CancelledException {
        if (!this.isSameMemmap()) {
            Msg.warn((Object)this, (Object)"Unable to copy external symbols from external debug file, memory map does not match");
            return;
        }
        try {
            this.monitor.setIndeterminate(false);
            this.monitor.initialize((long)this.extSymTable.getNumSymbols(), "External debug file symbols");
            for (Symbol extSym : this.extSymTable.getPrimarySymbolIterator(true)) {
                this.monitor.increment();
                ++this.totalSymbolCount;
                if (!this.shouldCopyExtSymbol(extSym)) continue;
                this.copyExtSymbol(extSym);
            }
        }
        catch (OverlappingFunctionException | CodeUnitInsertionException | InvalidInputException e) {
            try {
                log.appendMsg("Error while copying external debug file symbols");
                log.appendException(e);
            }
            catch (Throwable throwable) {
                Msg.info((Object)this, (Object)"Copied %d/%d of %d func/data/total symbols from external debug file".formatted(this.funcSymbolsCopied, this.dataSymbolsCopied, this.totalSymbolCount));
                throw throwable;
            }
            Msg.info((Object)this, (Object)"Copied %d/%d of %d func/data/total symbols from external debug file".formatted(this.funcSymbolsCopied, this.dataSymbolsCopied, this.totalSymbolCount));
        }
        Msg.info((Object)this, (Object)"Copied %d/%d of %d func/data/total symbols from external debug file".formatted(this.funcSymbolsCopied, this.dataSymbolsCopied, this.totalSymbolCount));
    }

    private void copyExtSymbol(Symbol extSym) throws InvalidInputException, OverlappingFunctionException, CodeUnitInsertionException {
        Object existingFunction;
        Function extFunc;
        Object object;
        SymbolType symType = extSym.getSymbolType();
        String name = extSym.getName();
        Address addr = extSym.getAddress();
        if (symType == SymbolType.FUNCTION && (object = extSym.getObject()) instanceof Function && !(extFunc = (Function)object).isThunk()) {
            existingFunction = this.funcMgr.getFunctionAt(addr);
            if (existingFunction == null) {
                existingFunction = this.funcMgr.createFunction(name, addr, (AddressSetView)new AddressSet(addr), SourceType.IMPORTED);
            } else if (!name.equals(existingFunction.getName())) {
                this.addLabelIfNeeded(name, addr);
            }
            ++this.funcSymbolsCopied;
        } else if (symType == SymbolType.LABEL && (existingFunction = extSym.getObject()) instanceof Data) {
            Data extData = (Data)existingFunction;
            if (Undefined.isUndefined((DataType)extData.getDataType()) && DataUtilities.isUndefinedRange((Program)this.program, (Address)addr, (Address)addr.add((long)extData.getLength()))) {
                DataType undefined = Undefined.getUndefinedDataType((int)extData.getLength());
                DataUtilities.createData((Program)this.program, (Address)addr, (DataType)undefined, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
            this.addLabelIfNeeded(name, addr);
            ++this.dataSymbolsCopied;
        } else {
            ++this.symbolsSkipped;
        }
    }

    private void addLabelIfNeeded(String name, Address addr) throws InvalidInputException {
        for (Symbol sym : this.symTable.getSymbolsAsIterator(addr)) {
            if (!sym.getName().equals(name)) continue;
            return;
        }
        this.symTable.createLabel(addr, name, SourceType.IMPORTED);
    }

    private boolean shouldCopyExtSymbol(Symbol extSym) {
        return !extSym.getParentNamespace().isLibrary();
    }

    private boolean isCommonMemblock(MemoryBlock memBlk) {
        return memBlk.isExecute();
    }

    private boolean isSameMemmap() {
        for (MemoryBlock p1MemBlock : this.program.getMemory().getBlocks()) {
            MemoryBlock p2MemBlock;
            if (!this.isCommonMemblock(p1MemBlock) || (p2MemBlock = this.externalDebugProgram.getMemory().getBlock(p1MemBlock.getStart())) != null && p2MemBlock.getName().equals(p1MemBlock.getName()) && p2MemBlock.getSize() == p1MemBlock.getSize()) continue;
            return false;
        }
        return true;
    }
}

