/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug.propertymanager;

import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;

class PropertyManagerTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    static final int PROPERTY_NAME_COLUMN = 0;
    String[] propertyNames;

    PropertyManagerTableModel() {
    }

    public synchronized void update(Program program, AddressSetView addrSet) {
        boolean restrictedView = addrSet != null && !addrSet.isEmpty();
        ArrayList<String> list = new ArrayList<String>();
        if (program != null) {
            PropertyMapManager propMgr = program.getUsrPropertyManager();
            Iterator iter = propMgr.propertyManagers();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (restrictedView) {
                    PropertyMap map = propMgr.getPropertyMap(name);
                    if (!map.intersects(addrSet)) continue;
                    list.add(name);
                    continue;
                }
                list.add(name);
            }
        }
        this.propertyNames = new String[list.size()];
        list.toArray(this.propertyNames);
        Arrays.sort(this.propertyNames);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.propertyNames != null) {
            return this.propertyNames.length;
        }
        return 0;
    }

    @Override
    public String getColumnName(int column) {
        return "Property Name";
    }

    @Override
    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (this.propertyNames != null && rowIndex < this.propertyNames.length) {
            return this.propertyNames[rowIndex];
        }
        return null;
    }

    protected synchronized void removeRow(int row) {
        if (this.propertyNames == null || row >= this.propertyNames.length) {
            return;
        }
        String[] newList = new String[this.propertyNames.length - 1];
        System.arraycopy(this.propertyNames, 0, newList, 0, row);
        System.arraycopy(this.propertyNames, row + 1, newList, row, newList.length - row);
        this.propertyNames = newList;
        this.fireTableDataChanged();
    }
}

