/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraState;
import ghidra.app.services.ConsoleService;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

class RunScriptTask
extends Task {
    private ConsoleService console;
    private GhidraState currentState;
    private String scriptName;
    private GhidraScript script;

    RunScriptTask(GhidraScript script, GhidraState currentState, ConsoleService console) {
        super(script.getSourceFile().getName(), true, false, false);
        this.script = script;
        this.scriptName = script.getSourceFile().getName();
        this.console = console;
        this.currentState = currentState;
    }

    public void run(TaskMonitor monitor) {
        block3: {
            try {
                Thread.currentThread().setName(this.scriptName);
                this.console.addMessage(this.scriptName, "Running...");
                this.script.execute(this.currentState, monitor, this.console.getStdOut());
                this.console.addMessage(this.scriptName, "Finished!");
            }
            catch (CancelledException e) {
                this.console.addErrorMessage(this.scriptName, "User cancelled script.");
            }
            catch (Exception e) {
                if (monitor.isCancelled()) break block3;
                Msg.showError((Object)((Object)this), null, (String)this.getTaskTitle(), (Object)("Error running script: " + this.scriptName + "\n" + e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                this.console.addErrorMessage("", "Error running script: " + this.scriptName);
                this.console.addException(this.scriptName, e);
            }
        }
    }

    public Program getProgram() {
        return this.script.getCurrentProgram();
    }
}

