/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.widgets.table.constraint.AtLeastColumnConstraint;
import docking.widgets.table.constraint.AtMostColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraintProvider;
import docking.widgets.table.constraint.ColumnTypeMapper;
import docking.widgets.table.constraint.InRangeColumnConstraint;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constraint.NotInRangeColumnConstraint;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constraint.provider.LongEditorProvider;
import docking.widgets.table.constraint.provider.LongRangeEditorProvider;
import ghidra.program.model.scalar.Scalar;
import java.util.ArrayList;
import java.util.Collection;

public class ScalarColumnConstraintProvider
implements ColumnConstraintProvider {
    public Collection<ColumnConstraint<?>> getColumnConstraints() {
        ArrayList list = new ArrayList();
        list.add(ScalarColumnConstraintProvider.makeSignedConstraint((ColumnConstraint<Long>)new AtLeastColumnConstraint("At Least (signed)", (Comparable)Long.valueOf(0L), (EditorProvider)new LongEditorProvider(), "scalar")));
        list.add(ScalarColumnConstraintProvider.makeSignedConstraint((ColumnConstraint<Long>)new AtMostColumnConstraint("At Most (signed)", (Comparable)Long.valueOf(0L), (EditorProvider)new LongEditorProvider(), "scalar")));
        list.add(ScalarColumnConstraintProvider.makeSignedConstraint((ColumnConstraint<Long>)new InRangeColumnConstraint("In Range (signed)", (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L), (EditorProvider)new LongRangeEditorProvider(), "scalar")));
        list.add(ScalarColumnConstraintProvider.makeSignedConstraint((ColumnConstraint<Long>)new NotInRangeColumnConstraint("Not In Range (signed)", (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L), (EditorProvider)new LongRangeEditorProvider(), "scalar")));
        list.add(ScalarColumnConstraintProvider.makeUnsignedConstraint((ColumnConstraint<Long>)new AtLeastColumnConstraint("At Least (unsigned)", (Comparable)Long.valueOf(0L), (EditorProvider)new LongEditorProvider(), "scalar-unsigned")));
        list.add(ScalarColumnConstraintProvider.makeUnsignedConstraint((ColumnConstraint<Long>)new AtMostColumnConstraint("At Most (unsigned)", (Comparable)Long.valueOf(0L), (EditorProvider)new LongEditorProvider(), "scalar-unsigned")));
        list.add(ScalarColumnConstraintProvider.makeUnsignedConstraint((ColumnConstraint<Long>)new InRangeColumnConstraint("In Range (unsigned)", (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L), (EditorProvider)new LongRangeEditorProvider(), "scalar-unsigned")));
        list.add(ScalarColumnConstraintProvider.makeUnsignedConstraint((ColumnConstraint<Long>)new NotInRangeColumnConstraint("Not In Range (unsigned)", (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L), (EditorProvider)new LongRangeEditorProvider(), "scalar-unsigned")));
        return list;
    }

    private static ColumnConstraint<?> makeSignedConstraint(ColumnConstraint<Long> delegate) {
        return new ScalarMappedColumnConstraint(new ScalarToSignedLongColumnTypeMapper(), delegate);
    }

    private static ColumnConstraint<?> makeUnsignedConstraint(ColumnConstraint<Long> delegate) {
        return new ScalarMappedColumnConstraint(new ScalarToUnsignedLongColumnTypeMapper(), delegate);
    }

    static class ScalarMappedColumnConstraint
    extends MappedColumnConstraint<Scalar, Long> {
        public ScalarMappedColumnConstraint(ColumnTypeMapper<Scalar, Long> mapper, ColumnConstraint<Long> delegate) {
            super(mapper, delegate);
        }
    }

    static class ScalarToSignedLongColumnTypeMapper
    extends ColumnTypeMapper<Scalar, Long> {
        ScalarToSignedLongColumnTypeMapper() {
        }

        public Long convert(Scalar value) {
            return value.getSignedValue();
        }
    }

    static class ScalarToUnsignedLongColumnTypeMapper
    extends ColumnTypeMapper<Scalar, Long> {
        ScalarToUnsignedLongColumnTypeMapper() {
        }

        public Long convert(Scalar value) {
            return value.getUnsignedValue();
        }
    }
}

