/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import ghidra.app.plugin.core.marker.MarkerManager;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Range;
import ghidra.util.datastruct.SortedRangeList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import resources.ResourceManager;

class AreaMarkerSet
extends MarkerSetImpl {
    AreaMarkerSet(MarkerManager markerManager, String name, String desc, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color markerColor, boolean isPreferred, Program program) {
        super(markerManager, program, name, desc, priority, showMarkers, showNavigation, colorBackground, markerColor, isPreferred);
    }

    AreaMarkerSet(MarkerManager markerManager, String name, String desc, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color markerColor, Program program) {
        this(markerManager, name, desc, priority, showMarkers, showNavigation, colorBackground, markerColor, false, program);
    }

    @Override
    protected void doPaintMarkers(Graphics g, VerticalPixelAddressMap pixmap, int index, AddressIndexMap map, List<Integer> layouts) {
        if (layouts == null) {
            return;
        }
        Iterator<Integer> it = layouts.iterator();
        g.setColor(this.markerColor);
        while (it.hasNext()) {
            int i = it.next();
            int yStart = pixmap.getBeginPosition(i);
            int yEnd = pixmap.getEndPosition(i);
            g.fillRect(7, yStart, 3, yEnd - yStart + 1);
        }
    }

    @Override
    protected void doPaintNavigation(Graphics g, int height, int width, SortedRangeList rangeList) {
        if (rangeList == null) {
            return;
        }
        g.setColor(this.markerColor);
        for (Range range : rangeList) {
            int endY = range.max;
            int startY = range.min;
            int len = endY - startY;
            if (len < 4) {
                len = 4;
            }
            g.fillRect(7, startY, width - 7, len);
        }
    }

    @Override
    public ImageIcon getNavIcon() {
        BufferedImage image = new BufferedImage(14, 14, 2);
        Graphics2D g = image.createGraphics();
        int height = 4;
        int width = 2 * height;
        int x = (14 - width) / 2;
        int y = (14 - height) / 2;
        g.setColor(this.markerColor);
        g.fillRect(x - 1, y - 1, width + 2, height + 2);
        return ResourceManager.getImageIconFromImage((String)"Area Marker Set Nav Icon", (Image)image);
    }
}

