/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.disassembler.DisassemblerPlugin;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;

public class X86_64DisassembleAction
extends ListingContextAction {
    private final DisassemblerPlugin plugin;
    private final boolean disassemble32Bit;

    public X86_64DisassembleAction(DisassemblerPlugin plugin, String groupName, boolean disassemble32Bit) {
        super("Disassemble " + (disassemble32Bit ? "32" : "64") + "-bit x86", plugin.getName());
        this.plugin = plugin;
        this.disassemble32Bit = disassemble32Bit;
        this.setPopupMenuData(new MenuData(new String[]{this.getName()}, null, groupName));
        int keyEvent = disassemble32Bit ? 123 : 122;
        this.setKeyBindingData(new KeyBindingData(keyEvent, 0));
        HelpLocation location = new HelpLocation("DisassemblerPlugin", "Disassemble");
        this.setHelpLocation(location);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        this.plugin.disassembleX86_64Callback(context, this.disassemble32Bit);
    }

    @Override
    public boolean isEnabledForContext(ListingActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        Address address = context.getAddress();
        if (address == null) {
            return false;
        }
        Program program = context.getProgram();
        Language lang = program.getLanguage();
        Processor proc = lang.getProcessor();
        if (!"x86".equals(proc.toString())) {
            return false;
        }
        if (lang.getLanguageDescription().getSize() != 64) {
            return false;
        }
        return this.plugin.checkDisassemblyEnabled(context, address, true);
    }
}

