/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.colorizer;

import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSetView;

class ClearColorCommand
implements Command<DomainObject> {
    private final AddressSetView set;
    private final ColorizingService colorizingService;

    ClearColorCommand(ColorizingService colorizingService) {
        this.colorizingService = colorizingService;
        this.set = null;
    }

    ClearColorCommand(ColorizingService colorizingService, AddressSetView set) {
        this.colorizingService = colorizingService;
        this.set = set;
    }

    public boolean applyTo(DomainObject obj) {
        if (this.set != null && !this.set.isEmpty()) {
            this.colorizingService.clearBackgroundColor(this.set);
        } else {
            this.colorizingService.clearAllBackgroundColors();
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return "Clear Background Color";
    }
}

