/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.builder.AbstractActionBuilder;
import docking.action.builder.ActionBuilder;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.codebrowser.AddressRangeInfo;
import ghidra.app.plugin.core.codebrowser.AddressRangeTableModel;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.plugin.core.codebrowser.MarkAndSelectionAction;
import ghidra.app.plugin.core.codebrowser.SelectEndpointsAction;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.SearchConstants;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.CustomLoadingAddressTableModel;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.TableModelLoader;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Basic Selection actions", description="This plugin provides actions for Code Browser Listing components")
public class CodeBrowserSelectionPlugin
extends Plugin {
    private static final String SELECT_GROUP = "Select Group";
    private static final String SELECTION_LIMIT_OPTION_NAME = "Table From Selection Limit";
    private static final int SELECTION_LIMIT_DEFAULT = 500;
    static final String RANGES_LIMIT_OPTION_NAME = "Ranges From Selection Limit";
    static final int RANGES_LIMIT_DEFAULT = 500;
    static final String MIN_RANGE_SIZE_OPTION_NAME = "Minimum Length of Address Range in Range Table";
    static final long MIN_RANGE_SIZE_DEFAULT = 1L;
    static final String CREATE_ADDRESS_RANGE_TABLE_ACTION_NAME = "Create Table From Ranges";
    static final String OPTION_CATEGORY_NAME = "Selection Tables";

    public CodeBrowserSelectionPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.initializeOptions();
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select All", this.getName()).menuPath(new String[]{"Se&lect", "&All in View"})).menuGroup(SELECT_GROUP, "a")).keyBinding("ctrl A")).helpLocation(new HelpLocation("Selection", "Select All"))).withContext(ListingActionContext.class, true).enabledWhen(this::hasCodeViewer).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).selectAll()).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Clear Selection", this.getName()).menuPath(new String[]{"Se&lect", "&Clear Selection"})).menuGroup(SELECT_GROUP, "b")).helpLocation(new HelpLocation("Selection", "Clear Selection"))).withContext(ListingActionContext.class, true).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).enabledWhen(c -> this.hasSelection((ListingActionContext)c)).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).setSelection(new ProgramSelection())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Select Complement", this.getName()).menuPath(new String[]{"Se&lect", "&Complement"})).menuGroup(SELECT_GROUP, "c")).helpLocation(new HelpLocation("Selection", "Select Complement"))).withContext(ListingActionContext.class, true).enabledWhen(this::hasCodeViewer).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> ((CodeViewerProvider)c.getComponentProvider()).selectComplement()).buildAndInstall((Tool)this.tool);
        this.tool.addAction((DockingActionIf)new MarkAndSelectionAction(this.getName(), SELECT_GROUP, "d"));
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Create Table From Selection", this.getName()).menuPath(new String[]{"Se&lect", "Create Table From Selection"})).menuGroup("SelectUtils")).helpLocation(new HelpLocation("CodeBrowserPlugin", "Selection_Tables"))).withContext(ListingActionContext.class, true).enabledWhen(this::hasCodeViewer).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> this.createTable((CodeViewerProvider)c.getComponentProvider())).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(CREATE_ADDRESS_RANGE_TABLE_ACTION_NAME, this.getName()).menuPath(new String[]{"Se&lect", CREATE_ADDRESS_RANGE_TABLE_ACTION_NAME})).menuGroup("SelectUtils")).helpLocation(new HelpLocation("CodeBrowserPlugin", "Selection_Tables"))).withContext(ListingActionContext.class, true).enabledWhen(this::hasCodeViewer).inWindow(AbstractActionBuilder.When.CONTEXT_MATCHES).onAction(c -> this.createAddressRangeTable((CodeViewerProvider)c.getComponentProvider())).buildAndInstall((Tool)this.tool);
    }

    private void createAddressRangeTable(CodeViewerProvider componentProvider) {
        TableService tableService = (TableService)this.tool.getService(TableService.class);
        if (tableService == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        Program program = componentProvider.getProgram();
        ProgramSelection selection = componentProvider.getSelection();
        if (selection.isEmpty()) {
            this.tool.setStatusInfo("Unable to create selected ranges table: no addresses in selection");
            return;
        }
        ToolOptions options = this.tool.getOptions(OPTION_CATEGORY_NAME);
        int resultsLimit = options.getInt(RANGES_LIMIT_OPTION_NAME, 500);
        long minLength = options.getLong(MIN_RANGE_SIZE_OPTION_NAME, 1L);
        AddressRangeTableModel model = new AddressRangeTableModel(this.tool, program, selection, resultsLimit, minLength);
        GIcon markerIcon = new GIcon("icon.plugin.codebrowser.cursor.marker");
        String title = "Selected Ranges in " + program.getName();
        TableComponentProvider<AddressRangeInfo> tableProvider = tableService.showTableWithMarkers(title, "Address Ranges", model, (Color)SearchConstants.SEARCH_HIGHLIGHT_COLOR, (Icon)markerIcon, title, componentProvider);
        tableProvider.installRemoveItemsAction();
        SelectEndpointsAction selectMin = new SelectEndpointsAction(this, program, model, SelectEndpointsAction.RangeEndpoint.MIN);
        selectMin.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Range_Table_Actions"));
        tableProvider.addLocalAction((DockingActionIf)selectMin);
        SelectEndpointsAction selectMax = new SelectEndpointsAction(this, program, model, SelectEndpointsAction.RangeEndpoint.MAX);
        selectMax.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Range_Table_Actions"));
        tableProvider.addLocalAction((DockingActionIf)selectMax);
    }

    private void createTable(CodeViewerProvider componentProvider) {
        ProgramSelection selection;
        TableService tableService = (TableService)this.tool.getService(TableService.class);
        if (tableService == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        Program program = componentProvider.getProgram();
        Listing listing = program.getListing();
        CodeUnitIterator codeUnits = listing.getCodeUnits((AddressSetView)(selection = componentProvider.getSelection()), true);
        if (!codeUnits.hasNext()) {
            this.tool.setStatusInfo("Unable to create table from selection: no code units in selection");
            return;
        }
        GhidraProgramTableModel<Address> model = this.createTableModel(program, codeUnits, selection);
        String title = "Selection Table";
        GIcon markerIcon = new GIcon("icon.plugin.codebrowser.cursor.marker");
        TableComponentProvider<Address> tableProvider = tableService.showTableWithMarkers(title + " " + model.getName(), "Selections", model, (Color)SearchConstants.SEARCH_HIGHLIGHT_COLOR, (Icon)markerIcon, title, componentProvider);
        tableProvider.installRemoveItemsAction();
    }

    private boolean hasCodeViewer(ListingActionContext c) {
        ComponentProvider provider = c.getComponentProvider();
        return provider instanceof CodeViewerProvider;
    }

    private boolean hasSelection(ListingActionContext c) {
        if (!this.hasCodeViewer(c)) {
            return false;
        }
        if (c.hasSelection()) {
            return true;
        }
        CodeViewerProvider provider = (CodeViewerProvider)c.getComponentProvider();
        String textSelection = provider.getTextSelection();
        return !StringUtils.isBlank((CharSequence)textSelection);
    }

    private GhidraProgramTableModel<Address> createTableModel(Program program, CodeUnitIterator iterator, ProgramSelection selection) {
        CodeUnitFromSelectionTableModelLoader loader = new CodeUnitFromSelectionTableModelLoader(iterator, selection);
        return new CustomLoadingAddressTableModel(" - from " + String.valueOf(selection.getMinAddress()), (ServiceProvider)this.tool, program, loader, null, true);
    }

    private void initializeOptions() {
        ToolOptions opt = this.tool.getOptions(OPTION_CATEGORY_NAME);
        HelpLocation help = new HelpLocation("CodeBrowserPlugin", "Selection_Tables");
        opt.registerOption(SELECTION_LIMIT_OPTION_NAME, (Object)500, help, "Maximum number of entries in selection table");
        opt.registerOption(RANGES_LIMIT_OPTION_NAME, (Object)500, help, "Maximum number of entries in an address range table");
        opt.registerOption(MIN_RANGE_SIZE_OPTION_NAME, (Object)1L, help, "Minimum length of an address range in address range table");
    }

    private class CodeUnitFromSelectionTableModelLoader
    implements TableModelLoader<Address> {
        private CodeUnitIterator iterator;
        private ProgramSelection selection;

        CodeUnitFromSelectionTableModelLoader(CodeUnitIterator iterator, ProgramSelection selection) {
            this.iterator = iterator;
            this.selection = selection;
        }

        @Override
        public void load(Accumulator<Address> accumulator, TaskMonitor monitor) throws CancelledException {
            ToolOptions options = CodeBrowserSelectionPlugin.this.tool.getOptions(CodeBrowserSelectionPlugin.OPTION_CATEGORY_NAME);
            int resultsLimit = options.getInt(CodeBrowserSelectionPlugin.SELECTION_LIMIT_OPTION_NAME, 500);
            long size = this.selection.getNumAddresses();
            monitor.initialize(size);
            while (this.iterator.hasNext()) {
                if (accumulator.size() >= resultsLimit) {
                    Msg.showWarn((Object)this, null, (String)"Results Truncated", (Object)("Results are limited to " + resultsLimit + " code units.\nThis limit can be changed by the tool option \"Selection Tables -> Table From Selection Limit\"."));
                    break;
                }
                monitor.checkCancelled();
                CodeUnit cu = this.iterator.next();
                accumulator.add((Object)cu.getMinAddress());
                monitor.incrementProgress((long)cu.getLength());
            }
        }
    }
}

