/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class ObjectiveC2_MessageAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Objective-C 2 Message";
    private static final String DESCRIPTION = "An analyzer for extracting Objective-C 2.0 message information.";

    public ObjectiveC2_MessageAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPrototype();
        this.setPriority(AnalysisPriority.FORMAT_ANALYSIS.after());
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        AddressIterator iterator = set.getAddresses(true);
        while (iterator.hasNext()) {
            Address address = iterator.next();
            Function function = program.getListing().getFunctionAt(address);
            try {
                this.inspectFunction(program, function, monitor);
            }
            catch (Exception exception) {}
        }
        return true;
    }

    @Override
    public boolean canAnalyze(Program program) {
        return ObjectiveC2_Constants.isObjectiveC2(program);
    }

    private void inspectFunction(Program program, Function function, TaskMonitor monitor) {
        if (function == null) {
            return;
        }
        InstructionIterator instructionIterator = program.getListing().getInstructions(function.getBody(), true);
        while (instructionIterator.hasNext()) {
            String eolComment;
            Instruction instruction = instructionIterator.next();
            if (!this.isCallingObjcMsgSend(instruction) || (eolComment = instruction.getComment(CommentType.EOL)) != null) continue;
            this.markupInstruction(program, instruction, monitor);
        }
    }

    private boolean isCallingObjcMsgSend(Instruction instruction) {
        if (instruction.getNumOperands() != 1) {
            return false;
        }
        Reference reference = instruction.getPrimaryReference(0);
        if (reference == null) {
            return false;
        }
        if (!reference.getReferenceType().isCall() && !reference.getReferenceType().isJump()) {
            return false;
        }
        SymbolTable symbolTable = instruction.getProgram().getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(reference.getToAddress());
        return this.isObjcNameMatch(symbol);
    }

    private boolean isObjcNameMatch(Symbol symbol) {
        String name = symbol.getName();
        return name.startsWith("_objc_msgSend") || name.equals("_read$UNIX2003");
    }

    private void markupInstruction(Program program, Instruction instruction, TaskMonitor monitor) {
        Address fromAddress = instruction.getMinAddress();
        Function function = program.getListing().getFunctionContaining(fromAddress);
        if (function == null) {
            return;
        }
        String currentClass = null;
        String currentMethod = null;
        InstructionIterator iter = program.getListing().getInstructions(fromAddress, false);
        while (iter.hasNext() && !monitor.isCancelled()) {
            Object[] secondOperandObjects;
            Register register;
            Instruction instructionBefore = iter.next();
            if (!function.getBody().contains(instructionBefore.getMinAddress())) break;
            String CLASS_REGISTER = "r0";
            String METHOD_REGISTER = "r1";
            boolean isRegisterModified = false;
            if (this.isRegisterModified(instructionBefore, "r0")) {
                currentClass = null;
                isRegisterModified = true;
            }
            if (this.isRegisterModified(instructionBefore, "r1")) {
                currentClass = null;
                isRegisterModified = true;
            }
            if (!this.isValidInstruction(instructionBefore)) {
                if (!isRegisterModified) continue;
                break;
            }
            Object[] firstOperandObjects = instructionBefore.getOpObjects(0);
            if (firstOperandObjects.length != 1 || !(firstOperandObjects[0] instanceof Register) || !(register = (Register)firstOperandObjects[0]).getName().equals("r0") && !register.getName().equals("r1") || (secondOperandObjects = instructionBefore.getOpObjects(1)).length != 1 || !(secondOperandObjects[0] instanceof Address)) continue;
            Address toAddress = (Address)secondOperandObjects[0];
            MemoryBlock block = program.getMemory().getBlock(toAddress);
            if (block == null) continue;
            if (register.getName().equals("r0")) {
                currentClass = this.getClassName(program, toAddress);
            } else if (register.getName().equals("r1")) {
                currentMethod = this.getMethodName(program, toAddress);
            }
            if (currentClass == null || currentMethod == null) continue;
            instruction.setComment(CommentType.EOL, "[" + currentClass + " " + currentMethod + "]");
            break;
        }
    }

    private boolean isRegisterModified(Instruction instruction, String registerName) {
        Object[] destinationOperandObjects = instruction.getOpObjects(0);
        if (destinationOperandObjects.length != 1) {
            return false;
        }
        if (!(destinationOperandObjects[0] instanceof Register)) {
            return false;
        }
        Register register = (Register)destinationOperandObjects[0];
        return register.getName().equals(registerName);
    }

    private String getClassName(Program program, Address toAddress) {
        try {
            int classPointerValue = program.getMemory().getInt(toAddress);
            Address classPointerAddress = toAddress.getNewAddress((long)classPointerValue);
            if (!this.isObjcClassRefBlock(program, classPointerAddress)) {
                return null;
            }
            Data classPointerData = program.getListing().getDefinedDataAt(classPointerAddress);
            Address classAddress = (Address)classPointerData.getValue();
            if (!this.isObjcDataBlock(program, classAddress)) {
                return null;
            }
            Data classData = program.getListing().getDefinedDataAt(classAddress);
            Data classRwPointerData = classData.getComponent(4);
            Address classRwPointerAddress = (Address)classRwPointerData.getValue();
            if (!this.isObjcConstBlock(program, classRwPointerAddress)) {
                return null;
            }
            Data classRwData = program.getListing().getDefinedDataAt(classRwPointerAddress);
            Data classNamePointerData = classRwData.getComponent(4);
            Address classNameAddress = (Address)classNamePointerData.getValue();
            if (!this.isCStringBlock(program, classNameAddress)) {
                return null;
            }
            Data classNameData = program.getListing().getDefinedDataAt(classNameAddress);
            String className = (String)classNameData.getValue();
            return className;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getMethodName(Program program, Address toAddress) {
        try {
            int methodNamePointerValue = program.getMemory().getInt(toAddress);
            Address methodNamePointerAddress = toAddress.getNewAddress((long)methodNamePointerValue);
            if (!this.isObjcSelectorRefBlock(program, methodNamePointerAddress)) {
                return null;
            }
            Data methodNamePointerData = program.getListing().getDefinedDataAt(methodNamePointerAddress);
            Address methodNameAddress = (Address)methodNamePointerData.getValue();
            if (!this.isCStringBlock(program, methodNameAddress)) {
                return null;
            }
            Data methodNameData = program.getListing().getDefinedDataAt(methodNameAddress);
            String methodName = (String)methodNameData.getValue();
            return methodName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isValidInstruction(Instruction instruction) {
        if (instruction.getNumOperands() != 2) {
            return false;
        }
        boolean isMOV = instruction.getMnemonicString().equals("MOV");
        boolean isLWZ = instruction.getMnemonicString().equals("lwz");
        boolean isLDR = instruction.getMnemonicString().equals("ldr");
        return isMOV || isLWZ || isLDR;
    }

    private boolean isCStringBlock(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.getName().equals("__cstring");
    }

    private boolean isObjcSelectorRefBlock(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.getName().equals("__objc_selrefs");
    }

    private boolean isObjcClassRefBlock(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.getName().equals("__objc_classrefs");
    }

    private boolean isObjcConstBlock(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.getName().equals("__objc_const");
    }

    private boolean isObjcDataBlock(Program program, Address address) {
        MemoryBlock block = program.getMemory().getBlock(address);
        return block != null && block.getName().equals("__objc_data");
    }
}

