/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.util.ProgramSelection;

public abstract class PreviousRangeAction
extends NavigatableContextAction {
    private PluginTool tool;
    private NavigationOptions navOptions;

    public PreviousRangeAction(PluginTool tool, String name, String owner, NavigationOptions navOptions) {
        super(name, owner);
        this.tool = tool;
        this.navOptions = navOptions;
        this.setEnabled(false);
        this.addToWindowWhen(NavigatableActionContext.class);
    }

    @Override
    public void actionPerformed(NavigatableActionContext context) {
        Address goToAddress = this.getGoToAddress(context);
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            service.goTo(context.getNavigatable(), goToAddress);
        }
    }

    private Address getGoToAddress(NavigatableActionContext context) {
        Address currentAddress;
        ProgramSelection selection = this.getSelection(context);
        AddressRangeIterator it = selection.getAddressRanges(currentAddress = context.getAddress(), false);
        if (!it.hasNext()) {
            return currentAddress;
        }
        AddressRange range = (AddressRange)it.next();
        if (range.contains(currentAddress)) {
            Address startOfRangeAddress = range.getMinAddress();
            if (!startOfRangeAddress.equals((Object)currentAddress)) {
                return startOfRangeAddress;
            }
            if (!it.hasNext()) {
                return currentAddress;
            }
            range = (AddressRange)it.next();
        }
        if (this.navOptions.isGotoTopAndBottomOfRangeEnabled()) {
            return range.getMaxAddress();
        }
        return range.getMinAddress();
    }

    @Override
    public boolean isEnabledForContext(NavigatableActionContext context) {
        Address currentAddress = context.getAddress();
        ProgramSelection selection = this.getSelection(context);
        if (selection == null || selection.isEmpty() || currentAddress == null) {
            return false;
        }
        return currentAddress.compareTo((Object)selection.getMinAddress()) > 0;
    }

    protected abstract ProgramSelection getSelection(ProgramLocationActionContext var1);
}

