/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import docking.ComponentProvider;
import docking.DockingWindowManager;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramSelection;
import ghidra.util.SystemUtilities;

public class NavigationUtils {
    public static Navigatable getActiveNavigatable() {
        DockingWindowManager activeInstance = DockingWindowManager.getActiveInstance();
        if (activeInstance == null) {
            return null;
        }
        ComponentProvider focusedComponentProvider = activeInstance.getActiveComponentProvider();
        if (focusedComponentProvider instanceof Navigatable) {
            return (Navigatable)focusedComponentProvider;
        }
        return null;
    }

    public static void setSelection(PluginTool tool, Navigatable navigatable, ProgramSelection selection) {
        GoToService service;
        if (navigatable == null && (service = (GoToService)tool.getService(GoToService.class)) == null) {
            return;
        }
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            navigatable.setSelection(selection);
            tool.contextChanged(null);
        });
    }

    public static Address[] getExternalLinkageAddresses(Program program, Address externalAddr) {
        if (!externalAddr.isExternalAddress()) {
            return new Address[0];
        }
        AddressSet set = new AddressSet();
        Listing listing = program.getListing();
        ReferenceIterator iter = program.getReferenceManager().getReferencesTo(externalAddr);
        while (iter.hasNext()) {
            Data data;
            Reference ref = iter.next();
            RefType refType = ref.getReferenceType();
            if (refType != RefType.DATA && refType != RefType.EXTERNAL_REF || (data = listing.getDefinedDataAt(ref.getFromAddress())) == null || !(data.getDataType() instanceof Pointer)) continue;
            set.add(ref.getFromAddress());
        }
        NavigationUtils.findExternalThunkLinkages(program, externalAddr, set);
        Address[] linkAddresses = new Address[(int)set.getNumAddresses()];
        int index = 0;
        for (Address addr : set.getAddresses(true)) {
            linkAddresses[index++] = addr;
        }
        return linkAddresses;
    }

    private static void findExternalThunkLinkages(Program program, Address externalAddr, AddressSet linkageSet) {
        Symbol s = program.getSymbolTable().getPrimarySymbol(externalAddr);
        if (s == null || s.getSymbolType() != SymbolType.FUNCTION) {
            return;
        }
        Function extFunc = (Function)s.getObject();
        Address[] thunkAddrs = extFunc.getFunctionThunkAddresses();
        if (thunkAddrs == null) {
            return;
        }
        for (Address thunkAddr : thunkAddrs) {
            Function f = program.getListing().getFunctionAt(thunkAddr);
            if (f == null || NavigationUtils.hasLinkageReference(program, f, (AddressSetView)linkageSet)) continue;
            linkageSet.add(thunkAddr);
        }
    }

    private static boolean hasLinkageReference(Program program, Function thunkFunction, AddressSetView linkageSet) {
        ReferenceManager referenceManager = program.getReferenceManager();
        for (Address addr : referenceManager.getReferenceSourceIterator(thunkFunction.getBody(), true)) {
            for (Reference ref : referenceManager.getReferencesFrom(addr)) {
                if (!linkageSet.contains(ref.getToAddress())) continue;
                return true;
            }
        }
        return false;
    }
}

