/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.WeakSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;

class CopyOnReadWeakSet<T>
extends WeakSet<T> {
    protected CopyOnReadWeakSet() {
    }

    private synchronized Collection<T> createCopy() {
        Set ks = this.weakHashStorage.keySet();
        return new ArrayList(ks);
    }

    @Override
    public synchronized boolean add(T t) {
        this.maybeWarnAboutAnonymousValue(t);
        boolean contains = this.weakHashStorage.containsKey(t);
        this.weakHashStorage.put(t, null);
        return !contains;
    }

    @Override
    public synchronized boolean remove(Object t) {
        boolean contains = this.weakHashStorage.containsKey(t);
        this.weakHashStorage.remove(t);
        return contains;
    }

    @Override
    public synchronized void clear() {
        this.weakHashStorage.clear();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.weakHashStorage.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.weakHashStorage.size();
    }

    @Override
    public synchronized boolean contains(Object t) {
        return this.weakHashStorage.containsKey(t);
    }

    public synchronized String toString() {
        return this.weakHashStorage.keySet().toString();
    }

    @Override
    public synchronized Iterator<T> iterator() {
        return this.createCopy().iterator();
    }

    @Override
    public synchronized Collection<T> values() {
        return this.createCopy();
    }

    @Override
    public synchronized Stream<T> stream() {
        return this.createCopy().stream();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> c) {
        boolean changed = false;
        for (T t : c) {
            changed |= this.add(t);
        }
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            T t = it.next();
            if (c.contains(t)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.weakHashStorage.keySet().removeAll(c);
    }
}

