/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSUnicodeRangeValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.UnicodeValue;
import io.sf.carte.doc.style.css.property.UnicodeWildcardValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnicodeRangeValue
extends TypedValue
implements CSSUnicodeRangeValue {
    private static final long serialVersionUID = 1L;
    private TypedValue value = null;
    private TypedValue endValue = null;

    UnicodeRangeValue() {
        super(CSSValue.Type.UNICODE_RANGE);
    }

    protected UnicodeRangeValue(UnicodeRangeValue copied) {
        super(copied);
        this.value = copied.value;
        this.endValue = copied.endValue;
    }

    @Override
    public String getCssText() {
        if (this.endValue == null) {
            return this.value.getCssText();
        }
        String s1 = this.value.getCssText();
        StringBuilder buf = new StringBuilder(s1.length() * 2 + 16);
        buf.append(s1).append('-');
        if (this.endValue.getPrimitiveType() == CSSValue.Type.UNICODE_CHARACTER) {
            buf.append(Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
        } else {
            buf.append(this.endValue.getStringValue());
        }
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        this.value.writeCssText(wri);
        if (this.endValue != null) {
            wri.write('-');
            if (this.endValue.getPrimitiveType() == CSSValue.Type.UNICODE_CHARACTER) {
                wri.write((CharSequence)Integer.toHexString(((CSSUnicodeRangeValue.CSSUnicodeValue)((Object)this.endValue)).getCodePoint()));
            } else {
                wri.write((CharSequence)this.endValue.getStringValue());
            }
        }
    }

    @Override
    public TypedValue getValue() {
        return this.value;
    }

    @Override
    public TypedValue getEndValue() {
        return this.endValue;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        return syntax.getCategory() == CSSValueSyntax.Category.unicodeRange ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.endValue == null ? 0 : this.endValue.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnicodeRangeValue other = (UnicodeRangeValue)obj;
        if (this.endValue == null ? other.endValue != null : !this.endValue.equals(other.endValue)) {
            return false;
        }
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnicodeRangeValue clone() {
        return new UnicodeRangeValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getSubValues();
            if (lu == null) {
                throw new DOMException(11, "Invalid (empty) range value");
            }
            UnicodeRangeValue.this.value = this.readValue(lu);
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                UnicodeRangeValue.this.endValue = this.readValue(lu);
            } else {
                UnicodeRangeValue.this.endValue = null;
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private TypedValue readValue(LexicalUnit lu) {
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type == LexicalUnit.LexicalType.INTEGER) {
                UnicodeValue val = new UnicodeValue();
                val.setCodePoint(lu.getIntegerValue());
                return val;
            }
            if (type == LexicalUnit.LexicalType.UNICODE_WILDCARD) {
                UnicodeWildcardValue val = new UnicodeWildcardValue();
                val.setWildcard(lu.getStringValue());
                return val;
            }
            throw new DOMException(17, "Wrong type for unicode range");
        }
    }
}

