/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.ValueFactory;

class ColumnsShorthandSetter
extends ShorthandSetter {
    ColumnsShorthandSetter(BaseCSSStyleDeclaration style) {
        super(style, "columns");
    }

    @Override
    public short assignSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return 0;
        }
        if (kwscan == 2) {
            return 2;
        }
        CSSValueSyntax syntaxInteger = SyntaxParser.createSimpleSyntax("integer");
        this.setPropertyToDefault("column-width");
        this.setPropertyToDefault("column-count");
        boolean columnWidthUnset = true;
        boolean columnCountUnset = true;
        int count = 0;
        while (this.currentValue != null) {
            if (count == 2) {
                return 2;
            }
            if (columnWidthUnset && ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
                this.setSubpropertyValue("column-width", this.createCSSValue("column-width", this.currentValue));
                count = (byte)(count + 1);
                columnWidthUnset = false;
            } else if (columnCountUnset && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                int intValue = this.currentValue.getIntegerValue();
                if (intValue < 1) {
                    return 2;
                }
                NumberValue number = new NumberValue();
                number.setIntegerValue(intValue);
                number.setSubproperty(true);
                this.setSubpropertyValue("column-count", number);
                count = (byte)(count + 1);
                columnCountUnset = false;
            } else {
                LexicalUnit.LexicalType lut = this.currentValue.getLexicalUnitType();
                if (lut == LexicalUnit.LexicalType.IDENT) {
                    String ident = this.currentValue.getStringValue();
                    if (!"auto".equalsIgnoreCase(ident)) {
                        if (this.isPrefixedIdentValue()) {
                            this.setPrefixedValue(this.currentValue);
                            this.flush();
                            return 1;
                        }
                        return 2;
                    }
                    count = (byte)(count + 1);
                } else if (columnCountUnset && this.currentValue.shallowMatch(syntaxInteger) == CSSValueSyntax.Match.TRUE) {
                    this.setSubpropertyValue("column-count", this.createCSSValue("column-count", this.currentValue));
                    count = (byte)(count + 1);
                    columnCountUnset = false;
                } else {
                    if (lut == LexicalUnit.LexicalType.PREFIXED_FUNCTION) {
                        this.setPrefixedValue(this.currentValue);
                        this.flush();
                        return 1;
                    }
                    return 2;
                }
            }
            this.nextCurrentValue();
        }
        this.flush();
        return 0;
    }
}

