/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.freeplane.api.NodeChangeListener;
import org.freeplane.api.NodeChanged;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.icon.Tags;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.text.DetailModel;
import org.freeplane.plugin.script.FormulaCache;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.NodeChangeListenerForScript;

class NodeChangeListeners
implements IExtension {
    private static Map<Object, NodeChanged.ChangedElement> elements = new HashMap<Object, NodeChanged.ChangedElement>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("node_text", NodeChanged.ChangedElement.TEXT);
            this.put(DetailModel.class, NodeChanged.ChangedElement.DETAILS);
            this.put("note_text", NodeChanged.ChangedElement.NOTE);
            this.put(NodeAttributeTableModel.class, NodeChanged.ChangedElement.ATTRIBUTE);
            this.put("icon", NodeChanged.ChangedElement.ICON);
            this.put(Tags.class, NodeChanged.ChangedElement.TAGS);
            this.put(FormulaCache.class, NodeChanged.ChangedElement.FORMULA_RESULT);
        }
    };
    private final ArrayList<NodeChangeListenerForScript> listeners = new ArrayList();
    private final MapModel mindmap;

    static NodeChangeListeners of(ModeController controller, MapModel map) {
        NodeChangeListenersListener.installInto(controller);
        return NodeChangeListeners.of(map);
    }

    NodeChangeListeners(MapModel mindmap) {
        this.mindmap = mindmap;
    }

    private static NodeChangeListeners of(MapModel map) {
        NodeChangeListeners listeners = (NodeChangeListeners)map.getExtension(NodeChangeListeners.class);
        if (listeners == null) {
            listeners = new NodeChangeListeners(map);
            map.addExtension(NodeChangeListeners.class, (IExtension)listeners);
        }
        return listeners;
    }

    void add(ScriptContext context, NodeChangeListener listener) {
        if (this.mindmap.getExtension(NodeChangeListeners.class) != this) {
            this.mindmap.addExtension(NodeChangeListeners.class, (IExtension)this);
        }
        this.listeners.add(new NodeChangeListenerForScript(listener, context));
    }

    void remove(NodeChangeListener listener) {
        this.listeners.removeIf(NodeChangeListenerForScript.contains(listener));
        if (this.listeners.isEmpty()) {
            this.mindmap.removeExtension((IExtension)this);
        }
    }

    void fire(NodeChangeEvent event) {
        if (this.listeners.isEmpty()) {
            return;
        }
        NodeChanged.ChangedElement element = elements.getOrDefault(event.getProperty(), NodeChanged.ChangedElement.UNKNOWN);
        this.listeners.forEach(l -> l.fire(event.getNode(), element));
    }

    List<NodeChangeListener> getListeners() {
        return this.listeners.stream().map(NodeChangeListenerForScript::getListener).collect(Collectors.toList());
    }

    private static class NodeChangeListenersListener
    implements IExtension,
    INodeChangeListener {
        private NodeChangeListenersListener() {
        }

        static void installInto(ModeController controller) {
            NodeChangeListenersListener listeners = (NodeChangeListenersListener)controller.getExtension(NodeChangeListenersListener.class);
            if (listeners == null) {
                listeners = new NodeChangeListenersListener();
                controller.addExtension(NodeChangeListenersListener.class, (IExtension)listeners);
                controller.getMapController().addNodeChangeListener((INodeChangeListener)listeners);
            }
        }

        public void nodeChanged(NodeChangeEvent event) {
            NodeChangeListeners listeners = (NodeChangeListeners)event.getNode().getMap().getExtension(NodeChangeListeners.class);
            if (listeners != null) {
                listeners.fire(event);
            }
        }
    }
}

