/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import java.lang.ref.SoftReference;

public class StructuredTextStringRecord {
    public static final int POOLSIZE = 100;
    private static final int MAXINDEX = 99;
    private static int last = -1;
    private static boolean wrapAround;
    private static SoftReference<StructuredTextStringRecord>[] recordRefs;
    private static int[] hashArray;
    private int totalSegmentCount;
    private int usedSegmentCount;
    private String string;
    private String[] handlers;
    private short[] boundaries;

    static {
        recordRefs = new SoftReference[100];
        hashArray = new int[100];
    }

    private StructuredTextStringRecord() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructuredTextStringRecord addRecord(String string, int segmentCount, String handlerID, int start, int limit) {
        if (string == null) {
            throw new IllegalArgumentException("The string argument must not be null!");
        }
        if (segmentCount < 1) {
            throw new IllegalArgumentException("The segment count must be at least 1!");
        }
        SoftReference<StructuredTextStringRecord>[] softReferenceArray = recordRefs;
        synchronized (recordRefs) {
            if (last < 99) {
                ++last;
            } else {
                wrapAround = true;
                last = 0;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            StructuredTextStringRecord record = null;
            if (recordRefs[last] != null) {
                record = recordRefs[last].get();
            }
            if (record == null) {
                record = new StructuredTextStringRecord();
                StructuredTextStringRecord.recordRefs[StructuredTextStringRecord.last] = new SoftReference<StructuredTextStringRecord>(record);
            }
            StructuredTextStringRecord.hashArray[StructuredTextStringRecord.last] = string.hashCode();
            int i = 0;
            while (i < record.usedSegmentCount) {
                record.handlers[i] = null;
                ++i;
            }
            if (segmentCount > record.totalSegmentCount) {
                record.handlers = new String[segmentCount];
                record.boundaries = new short[segmentCount * 2];
                record.totalSegmentCount = segmentCount;
            }
            record.usedSegmentCount = 0;
            record.string = string;
            record.addSegment(handlerID, start, limit);
            return record;
        }
    }

    public void addSegment(String handlerID, int start, int limit) {
        if (handlerID == null) {
            throw new IllegalArgumentException("The handlerID argument must not be null!");
        }
        if (start < 0 || start >= this.string.length()) {
            throw new IllegalArgumentException("The start position must be at least 0 and less than the length of the string!");
        }
        if (limit <= start || limit > this.string.length()) {
            throw new IllegalArgumentException("The limit position must be greater than the start position but no greater than the length of the string!");
        }
        if (this.usedSegmentCount >= this.totalSegmentCount) {
            throw new IllegalStateException("All segments of the record are already used!");
        }
        this.handlers[this.usedSegmentCount] = handlerID;
        this.boundaries[this.usedSegmentCount * 2] = (short)start;
        this.boundaries[this.usedSegmentCount * 2 + 1] = (short)limit;
        ++this.usedSegmentCount;
    }

    public static StructuredTextStringRecord getRecord(String string) {
        StructuredTextStringRecord record;
        if (last < 0) {
            return null;
        }
        if (string == null || string.length() < 1) {
            return null;
        }
        int myLast = last;
        int hash = string.hashCode();
        int i = myLast;
        while (i >= 0) {
            if (hash == hashArray[i] && (record = recordRefs[i].get()) != null && string.equals(record.string)) {
                return record;
            }
            --i;
        }
        if (!wrapAround) {
            return null;
        }
        i = 99;
        while (i > myLast) {
            if (hash == hashArray[i] && (record = recordRefs[i].get()) != null && string.equals(record.string)) {
                return record;
            }
            --i;
        }
        return null;
    }

    public int getSegmentCount() {
        return this.usedSegmentCount;
    }

    private void checkSegmentNumber(int segmentNumber) {
        if (segmentNumber >= this.usedSegmentCount) {
            throw new IllegalArgumentException("The segment number " + segmentNumber + " is greater than the total number of segments = " + this.usedSegmentCount + "!");
        }
    }

    public String getHandler(int segmentNumber) {
        this.checkSegmentNumber(segmentNumber);
        return this.handlers[segmentNumber];
    }

    public int getStart(int segmentNumber) {
        this.checkSegmentNumber(segmentNumber);
        return this.boundaries[segmentNumber * 2];
    }

    public int getLimit(int segmentNumber) {
        this.checkSegmentNumber(segmentNumber);
        return this.boundaries[segmentNumber * 2 + 1];
    }

    public static synchronized void clear() {
        int i = 0;
        while (i <= 99) {
            StructuredTextStringRecord record;
            StructuredTextStringRecord.hashArray[i] = 0;
            SoftReference<StructuredTextStringRecord> softRef = recordRefs[i];
            if (softRef != null && (record = softRef.get()) != null) {
                record.boundaries = null;
                record.handlers = null;
                record.totalSegmentCount = 0;
                record.usedSegmentCount = 0;
                recordRefs[i].clear();
            }
            ++i;
        }
        last = -1;
        wrapAround = false;
    }
}

