/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.data;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.data.OracleTimestampConverter;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCDateTimeValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.time.ExtendedDateFormat;

public class OracleTimestampValueHandler
extends JDBCDateTimeValueHandler {
    private static final SimpleDateFormat DEFAULT_DATETIME_FORMAT = new ExtendedDateFormat("'TIMESTAMP '''yyyy-MM-dd HH:mm:ss.ffffff''");
    private static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("'DATE '''yyyy-MM-dd''");
    private static final SimpleDateFormat DEFAULT_TIME_FORMAT = new SimpleDateFormat("'TIME '''HH:mm:ss.SSS''");
    @NotNull
    private DBPDataSource dataSource;

    OracleTimestampValueHandler(DBDFormatSettings formatSettings, @NotNull DBPDataSource dataSource) {
        super(formatSettings);
        this.dataSource = dataSource;
    }

    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        boolean showDateAsDate = CommonUtils.getBoolean((String)session.getDataSource().getContainer().getConnectionConfiguration().getProviderProperty("oracle.show-date-as-date"), (boolean)false);
        if (resultSet instanceof JDBCResultSet && showDateAsDate && "DATE".equals(type.getTypeName()) && !this.formatSettings.isUseNativeDateTimeFormat()) {
            try {
                return ((JDBCResultSet)resultSet).getDate(index + 1);
            }
            catch (SQLException e) {
                log.debug((Object)"Exception caught when fetching date value", (Throwable)e);
            }
        }
        return super.fetchValueObject(session, resultSet, type, index);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object != null && object.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
            try {
                return OracleTimestampConverter.toTimestamp(object, ((JDBCSession)session).getOriginal());
            }
            catch (Exception e) {
                throw new DBCException("Error extracting Oracle TIMESTAMP value", (Throwable)e);
            }
        }
        return super.getValueFromObject(session, type, object, copy, validateValue);
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (format == DBDDisplayFormat.NATIVE && value instanceof String) {
            if (!((String)value).startsWith("TIMESTAMP")) {
                return "TIMESTAMP'" + String.valueOf(value) + "'";
            }
            return (String)value;
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Nullable
    public Format getNativeValueFormat(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 93: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 101: 
            case 102: 
            case 2014: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 92: {
                return DEFAULT_TIME_FORMAT;
            }
            case 2013: {
                return DEFAULT_TIME_FORMAT;
            }
            case 91: {
                return DEFAULT_DATE_FORMAT;
            }
        }
        return super.getNativeValueFormat(type);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        try {
            JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
            if (value == null) {
                dbStat.setNull(index + 1, type.getTypeID());
            }
            if (value instanceof String) {
                int typeID = type.getTypeID();
                if (typeID == 91) {
                    try {
                        dbStat.setDate(index + 1, Date.valueOf(value.toString()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dbStat.setString(index + 1, (String)value);
                    }
                } else if (typeID == 93) {
                    try {
                        dbStat.setTimestamp(index + 1, Timestamp.valueOf(value.toString()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        dbStat.setString(index + 1, (String)value);
                    }
                } else {
                    dbStat.setString(index + 1, (String)value);
                }
            } else {
                super.bindValueObject(session, statement, type, index, value);
            }
        }
        catch (SQLException e) {
            throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, (Throwable)e);
        }
    }

    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        boolean showDateAsDate = CommonUtils.getBoolean((String)this.dataSource.getContainer().getConnectionConfiguration().getProviderProperty("oracle.show-date-as-date"), (boolean)false);
        if (showDateAsDate && "DATE".equals(column.getTypeName())) {
            return "date";
        }
        return super.getFormatterId(column);
    }
}

