/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory;

public final class TruffleStringIterator {
    final AbstractTruffleString a;
    final byte[] arrayA;
    final long offsetA;
    final byte strideA;
    final byte codeRangeA;
    final TruffleString.Encoding encoding;
    final TruffleString.ErrorHandling errorHandling;
    private int rawIndex;

    TruffleStringIterator(AbstractTruffleString a, byte[] arrayA, long offsetA, int codeRangeA, TruffleString.Encoding encoding, TruffleString.ErrorHandling errorHandling, int rawIndex) {
        assert (TSCodeRange.isCodeRange(codeRangeA));
        this.a = a;
        this.arrayA = arrayA;
        this.offsetA = offsetA;
        this.strideA = (byte)a.stride();
        this.codeRangeA = (byte)codeRangeA;
        this.encoding = encoding;
        this.errorHandling = errorHandling;
        this.rawIndex = rawIndex;
    }

    public boolean hasNext() {
        return this.rawIndex < this.a.length();
    }

    public boolean hasPrevious() {
        return this.rawIndex > 0;
    }

    public int getByteIndex() {
        return this.rawIndex << this.encoding.naturalStride;
    }

    private int applyErrorHandler(DecodingErrorHandler errorHandler, int startIndex) {
        return this.applyErrorHandler(errorHandler, startIndex, true);
    }

    private int applyErrorHandlerReverse(DecodingErrorHandler errorHandler, int startIndex) {
        return this.applyErrorHandler(errorHandler, startIndex, false);
    }

    @HostCompilerDirectives.InliningCutoff
    private int applyErrorHandler(DecodingErrorHandler errorHandler, int startIndex, boolean forward) {
        CompilerAsserts.partialEvaluationConstant(forward);
        if (TStringGuards.isReturnNegative(errorHandler)) {
            return -1;
        }
        if (TStringGuards.isBuiltin(errorHandler)) {
            return Encodings.invalidCodepoint();
        }
        int byteEnd = this.getByteIndex();
        this.rawIndex = startIndex;
        int byteStart = this.getByteIndex();
        int estimatedByteLength = forward ? byteEnd - byteStart : byteStart - byteEnd;
        DecodingErrorHandler.Result result = errorHandler.apply(this.a, byteStart, estimatedByteLength);
        this.errorHandlerSkipBytes(result.byteLength(), forward);
        return result.codepoint();
    }

    void errorHandlerSkipBytes(int byteLength, boolean forward) {
        int rawLength = byteLength >> this.encoding.naturalStride;
        if (rawLength == 0) {
            throw InternalErrors.illegalState("custom error handler consumed less than one char / int value");
        }
        if (forward) {
            this.rawIndex += rawLength;
            if (Integer.compareUnsigned(this.rawIndex, this.a.length()) > 0) {
                throw InternalErrors.illegalState("custom error handler consumed more bytes than string length");
            }
        } else {
            this.rawIndex -= rawLength;
            if (this.rawIndex < 0) {
                throw InternalErrors.illegalState("custom error handler consumed more bytes than string length");
            }
        }
    }

    @Deprecated(since="25.0")
    @CompilerDirectives.TruffleBoundary
    public int nextUncached() {
        return NextNode.getUncached().execute(this);
    }

    @CompilerDirectives.TruffleBoundary
    public int nextUncached(TruffleString.Encoding expectedEncoding) {
        return NextNode.getUncached().execute(this, expectedEncoding);
    }

    @Deprecated(since="25.0")
    @CompilerDirectives.TruffleBoundary
    public int previousUncached() {
        return PreviousNode.getUncached().execute(this);
    }

    @CompilerDirectives.TruffleBoundary
    public int previousUncached(TruffleString.Encoding expectedEncoding) {
        return PreviousNode.getUncached().execute(this, expectedEncoding);
    }

    int getRawIndex() {
        return this.rawIndex;
    }

    void setRawIndex(int i) {
        this.rawIndex = i;
    }

    private int readFwdS0() {
        assert (this.a.stride() == 0);
        assert (this.hasNext());
        return TStringOps.readS0(this.a, this.arrayA, this.offsetA, this.rawIndex);
    }

    private int readFwdS1(boolean foreignEndian) {
        CompilerAsserts.partialEvaluationConstant(foreignEndian);
        assert (this.hasNext());
        if (foreignEndian) {
            assert (this.a.stride() == 0);
            char c = TStringOps.readS1(this.arrayA, this.offsetA, this.a.length() >> 1, this.rawIndex >> 1);
            return Character.reverseBytes(c);
        }
        assert (this.a.stride() == 1);
        return TStringOps.readS1(this.a, this.arrayA, this.offsetA, this.rawIndex);
    }

    private int readBckS1(boolean foreignEndian) {
        CompilerAsserts.partialEvaluationConstant(foreignEndian);
        assert (this.hasPrevious());
        if (foreignEndian) {
            assert (this.a.stride() == 0);
            return Character.reverseBytes(TStringOps.readS1(this.arrayA, this.offsetA, this.a.length() >> 1, this.rawIndex - 2 >> 1));
        }
        assert (this.a.stride() == 1);
        return TStringOps.readS1(this.a, this.arrayA, this.offsetA, this.rawIndex - 1);
    }

    private int readAndIncS0() {
        assert (this.a.stride() == 0);
        assert (this.hasNext());
        return TStringOps.readS0(this.a, this.arrayA, this.offsetA, this.rawIndex++);
    }

    private int readAndIncS1(boolean foreignEndian) {
        CompilerAsserts.partialEvaluationConstant(foreignEndian);
        assert (this.hasNext());
        if (foreignEndian) {
            assert (this.a.stride() == 0);
            char c = TStringOps.readS1(this.arrayA, this.offsetA, this.a.length() >> 1, this.rawIndex >> 1);
            this.rawIndex += 2;
            return Character.reverseBytes(c);
        }
        assert (this.a.stride() == 1);
        return TStringOps.readS1(this.a, this.arrayA, this.offsetA, this.rawIndex++);
    }

    private int readAndIncS2() {
        assert (this.a.stride() == 2);
        assert (this.hasNext());
        return TStringOps.readS2(this.a, this.arrayA, this.offsetA, this.rawIndex++);
    }

    private int readAndDecS1(boolean foreignEndian) {
        CompilerAsserts.partialEvaluationConstant(foreignEndian);
        assert (this.hasPrevious());
        if (foreignEndian) {
            assert (this.a.stride() == 0);
            this.rawIndex -= 2;
            return Character.reverseBytes(TStringOps.readS1(this.arrayA, this.offsetA, this.a.length() >> 1, this.rawIndex >> 1));
        }
        assert (this.a.stride() == 1);
        return TStringOps.readS1(this.a, this.arrayA, this.offsetA, --this.rawIndex);
    }

    private int readAndIncS2UTF32FE() {
        assert (this.a.stride() == 0);
        assert (this.hasNext());
        int value = Integer.reverseBytes(TStringOps.readS2(this.arrayA, this.offsetA, this.a.length() >> 2, this.rawIndex >> 2));
        this.rawIndex += 4;
        return value;
    }

    private int readAndDecS2UTF32FE() {
        assert (this.a.stride() == 0);
        assert (this.hasPrevious());
        this.rawIndex -= 4;
        return Integer.reverseBytes(TStringOps.readS2(this.arrayA, this.offsetA, this.a.length() >> 2, this.rawIndex >> 2));
    }

    private int readAndDecS0() {
        assert (this.a.stride() == 0);
        assert (this.hasPrevious());
        return TStringOps.readS0(this.a, this.arrayA, this.offsetA, --this.rawIndex);
    }

    private int readAndDecS2() {
        assert (this.a.stride() == 2);
        assert (this.hasPrevious());
        return TStringOps.readS2(this.a, this.arrayA, this.offsetA, --this.rawIndex);
    }

    private boolean curIsUtf8ContinuationByte() {
        return Encodings.isUTF8ContinuationByte(this.readFwdS0());
    }

    static int indexOf(Node location, TruffleStringIterator it, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, InternalNextNode nextNode) {
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && it.hasNext()) {
            nextNode.execute(location, it, encoding);
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex) {
            return -1;
        }
        while (it.hasNext() && aCodepointIndex < toIndex) {
            if (nextNode.execute(location, it, encoding) == codepoint) {
                return aCodepointIndex;
            }
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        return -1;
    }

    static int lastIndexOf(Node location, TruffleStringIterator it, TruffleString.Encoding encoding, int codepoint, int fromIndex, int toIndex, InternalNextNode nextNode) {
        int aCodepointIndex = 0;
        int result = -1;
        while (aCodepointIndex < fromIndex && it.hasNext()) {
            if (nextNode.execute(location, it, encoding) == codepoint) {
                result = aCodepointIndex;
            }
            TStringConstants.truffleSafePointPoll(location, ++aCodepointIndex);
        }
        if (aCodepointIndex < toIndex) {
            return -1;
        }
        return result;
    }

    static int indexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, TruffleString.Encoding encoding, int fromIndex, int toIndex, InternalNextNode nextNodeA, InternalNextNode nextNodeB) {
        if (!bIt.hasNext()) {
            return fromIndex;
        }
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && aIt.hasNext()) {
            nextNodeA.execute(node, aIt, encoding);
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex) {
            return -1;
        }
        int bFirst = nextNodeB.execute(node, bIt, encoding);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasNext() && aCodepointIndex < toIndex) {
            if (nextNodeA.execute(node, aIt, encoding) == bFirst) {
                if (!bIt.hasNext()) {
                    return aCodepointIndex;
                }
                int aCurIndex = aIt.getRawIndex();
                int innerLoopCount = 0;
                while (bIt.hasNext()) {
                    if (!aIt.hasNext()) {
                        return -1;
                    }
                    if (nextNodeA.execute(node, aIt, encoding) != nextNodeB.execute(node, bIt, encoding)) break;
                    if (!bIt.hasNext()) {
                        return aCodepointIndex;
                    }
                    TStringConstants.truffleSafePointPoll(node, ++innerLoopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        return -1;
    }

    static int byteIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, TruffleString.Encoding encoding, int fromByteIndex, int toByteIndex, InternalNextNode nextNodeA, InternalNextNode nextNodeB) {
        if (!bIt.hasNext()) {
            return fromByteIndex;
        }
        aIt.setRawIndex(fromByteIndex);
        int bFirst = nextNodeB.execute(node, bIt, encoding);
        int bSecondIndex = bIt.getRawIndex();
        int loopCount = 0;
        while (aIt.hasNext() && aIt.getRawIndex() < toByteIndex) {
            int ret = aIt.getRawIndex();
            if (nextNodeA.execute(node, aIt, encoding) == bFirst) {
                if (!bIt.hasNext()) {
                    return ret;
                }
                int aCurIndex = aIt.getRawIndex();
                while (bIt.hasNext()) {
                    if (!aIt.hasNext()) {
                        return -1;
                    }
                    if (nextNodeA.execute(node, aIt, encoding) != nextNodeB.execute(node, bIt, encoding)) break;
                    if (!bIt.hasNext()) {
                        return ret;
                    }
                    TStringConstants.truffleSafePointPoll(node, ++loopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        return -1;
    }

    static int lastIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, TruffleString.Encoding encoding, int fromIndex, int toIndex, InternalNextNode nextNodeA, InternalPreviousNode prevNodeA, InternalPreviousNode prevNodeB) {
        if (!bIt.hasPrevious()) {
            return fromIndex;
        }
        int bFirstCodePoint = prevNodeB.execute(node, bIt, encoding, DecodingErrorHandler.DEFAULT);
        int lastMatchIndex = -1;
        int lastMatchByteIndex = -1;
        int aCodepointIndex = 0;
        while (aCodepointIndex < fromIndex && aIt.hasNext()) {
            if (nextNodeA.execute(node, aIt, encoding) == bFirstCodePoint) {
                lastMatchIndex = aCodepointIndex;
                lastMatchByteIndex = aIt.getRawIndex();
            }
            TStringConstants.truffleSafePointPoll(node, ++aCodepointIndex);
        }
        if (aCodepointIndex < fromIndex || lastMatchIndex < 0) {
            return -1;
        }
        aCodepointIndex = lastMatchIndex;
        aIt.setRawIndex(lastMatchByteIndex);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasPrevious() && aCodepointIndex >= toIndex) {
            if (prevNodeA.execute(node, aIt, encoding, DecodingErrorHandler.DEFAULT) == bFirstCodePoint) {
                if (!bIt.hasPrevious()) {
                    return aCodepointIndex;
                }
                int aCurIndex = aIt.getRawIndex();
                int aCurCodePointIndex = aCodepointIndex;
                while (bIt.hasPrevious()) {
                    if (!aIt.hasPrevious()) {
                        return -1;
                    }
                    if (prevNodeA.execute(node, aIt, encoding, DecodingErrorHandler.DEFAULT) != prevNodeB.execute(node, bIt, encoding, DecodingErrorHandler.DEFAULT)) break;
                    if (!bIt.hasPrevious() && --aCurCodePointIndex >= toIndex) {
                        return aCurCodePointIndex;
                    }
                    TStringConstants.truffleSafePointPoll(node, aCurCodePointIndex);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, --aCodepointIndex);
        }
        return -1;
    }

    static int lastByteIndexOfString(Node node, TruffleStringIterator aIt, TruffleStringIterator bIt, TruffleString.Encoding encoding, int fromByteIndex, int toByteIndex, InternalNextNode nextNodeA, InternalPreviousNode prevNodeA, InternalPreviousNode prevNodeB) {
        if (!bIt.hasPrevious()) {
            return fromByteIndex;
        }
        int bFirstCodePoint = prevNodeB.execute(node, bIt, encoding, DecodingErrorHandler.DEFAULT);
        int lastMatchByteIndex = -1;
        int loopCount = 0;
        while (aIt.getRawIndex() < fromByteIndex && aIt.hasNext()) {
            if (nextNodeA.execute(node, aIt, encoding) == bFirstCodePoint) {
                lastMatchByteIndex = aIt.getRawIndex();
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        if (aIt.getRawIndex() < fromByteIndex || lastMatchByteIndex < 0) {
            return -1;
        }
        aIt.setRawIndex(lastMatchByteIndex);
        int bSecondIndex = bIt.getRawIndex();
        while (aIt.hasPrevious() && aIt.getRawIndex() > toByteIndex) {
            if (prevNodeA.execute(node, aIt, encoding, DecodingErrorHandler.DEFAULT) == bFirstCodePoint) {
                if (!bIt.hasPrevious()) {
                    return aIt.getRawIndex();
                }
                int aCurIndex = aIt.getRawIndex();
                while (bIt.hasPrevious()) {
                    if (!aIt.hasPrevious()) {
                        return -1;
                    }
                    if (prevNodeA.execute(node, aIt, encoding, DecodingErrorHandler.DEFAULT) != prevNodeB.execute(node, bIt, encoding, DecodingErrorHandler.DEFAULT)) break;
                    if (!bIt.hasPrevious() && aIt.getRawIndex() >= toByteIndex) {
                        return aIt.getRawIndex();
                    }
                    TStringConstants.truffleSafePointPoll(node, ++loopCount);
                }
                aIt.setRawIndex(aCurIndex);
                bIt.setRawIndex(bSecondIndex);
            }
            TStringConstants.truffleSafePointPoll(node, ++loopCount);
        }
        return -1;
    }

    public static abstract class NextNode
    extends AbstractPublicNode {
        NextNode() {
        }

        @Deprecated(since="25.0")
        public final int execute(TruffleStringIterator it) {
            return this.execute(it, it.encoding);
        }

        public abstract int execute(TruffleStringIterator var1, TruffleString.Encoding var2);

        @Specialization
        final int doDefault(TruffleStringIterator it, TruffleString.Encoding encoding, @Cached InternalNextNode nextNode) {
            return nextNode.execute(this, it, encoding, it.errorHandling.errorHandler);
        }

        @NeverDefault
        public static NextNode create() {
            return TruffleStringIteratorFactory.NextNodeGen.create();
        }

        public static NextNode getUncached() {
            return TruffleStringIteratorFactory.NextNodeGen.getUncached();
        }
    }

    public static abstract class PreviousNode
    extends AbstractPublicNode {
        PreviousNode() {
        }

        @Deprecated(since="25.0")
        public final int execute(TruffleStringIterator it) {
            return this.execute(it, it.encoding);
        }

        public abstract int execute(TruffleStringIterator var1, TruffleString.Encoding var2);

        @Specialization
        final int doDefault(TruffleStringIterator it, TruffleString.Encoding encoding, @Cached InternalPreviousNode previousNode) {
            return previousNode.execute(this, it, encoding, it.errorHandling.errorHandler);
        }

        @NeverDefault
        public static PreviousNode create() {
            return TruffleStringIteratorFactory.PreviousNodeGen.create();
        }

        public static PreviousNode getUncached() {
            return TruffleStringIteratorFactory.PreviousNodeGen.getUncached();
        }
    }

    static abstract class InternalNextNode
    extends AbstractInternalNode {
        InternalNextNode() {
        }

        final int execute(Node node, TruffleStringIterator it, TruffleString.Encoding encoding) {
            return this.execute(node, it, encoding, DecodingErrorHandler.DEFAULT);
        }

        final int execute(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler) {
            if (!it.hasNext()) {
                throw InternalErrors.illegalState("end of string has been reached already");
            }
            return this.executeInternal(node, it, encoding, errorHandler);
        }

        abstract int executeInternal(Node var1, TruffleStringIterator var2, TruffleString.Encoding var3, DecodingErrorHandler var4);

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile asciiProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            int b = it.readAndIncS0();
            if (asciiProfile.profile(node, TStringGuards.is7Bit(codeRange))) {
                return b;
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRange))) {
                if (b < 128) {
                    return b;
                }
                int nBytes = Integer.numberOfLeadingZeros(~(b << 24));
                int codepoint = b & 255 >>> nBytes;
                assert (1 < nBytes && nBytes < 5) : nBytes;
                assert (it.rawIndex + nBytes - 1 <= it.a.length());
                switch (nBytes) {
                    case 4: {
                        assert (it.curIsUtf8ContinuationByte());
                        codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
                    }
                    case 3: {
                        assert (it.curIsUtf8ContinuationByte());
                        codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
                    }
                }
                assert (it.curIsUtf8ContinuationByte());
                codepoint = codepoint << 6 | it.readAndIncS0() & 0x3F;
                return codepoint;
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalNextNode.utf8Broken(it, b, errorHandler);
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile compressedProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            if (fixedProfile.profile(node, TStringGuards.isFixedWidth(codeRange))) {
                if (compressedProfile.profile(node, it.strideA == 0)) {
                    return it.readAndIncS0();
                }
                return it.readAndIncS1(false);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRange))) {
                return InternalNextNode.utf16ValidIntl(it, false);
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalNextNode.utf16BrokenIntl(it, false, errorHandler);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile oneByteProfile, @Cached @Cached.Exclusive InlinedConditionProfile twoByteProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            if (oneByteProfile.profile(node, it.strideA == 0)) {
                assert (TStringGuards.is7Or8Bit(codeRange));
                return it.readAndIncS0();
            }
            if (twoByteProfile.profile(node, it.strideA == 1)) {
                assert (TStringGuards.isUpTo16Bit(codeRange));
                return it.readAndIncS1(false);
            }
            assert (it.strideA == 2);
            int codepoint = it.readAndIncS2();
            if (validProfile.profile(node, TStringGuards.isDefaultVariant(errorHandler) || TStringGuards.isUpToValid(codeRange))) {
                return codepoint;
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalNextNode.utf32BrokenIntl(it, errorHandler, codepoint, 1);
        }

        @Fallback
        static int unlikelyCases(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedIntValueProfile encodingProfile) {
            int enc = encodingProfile.profile(node, encoding.id);
            byte codeRange = it.codeRangeA;
            if (TStringGuards.isUpToValidFixedWidth(codeRange)) {
                return it.readAndIncS0();
            }
            if (TStringGuards.isAscii(enc)) {
                assert (TStringGuards.isBroken(codeRange));
                int codepoint = it.readAndIncS0();
                if (TStringGuards.isDefaultVariant(errorHandler) || codepoint < 128) {
                    return codepoint;
                }
                return it.applyErrorHandler(errorHandler, it.rawIndex - 1);
            }
            if (TStringGuards.isUTF32FE(enc)) {
                if (TStringGuards.isDefaultVariant(errorHandler) || TStringGuards.isValid(codeRange)) {
                    return it.readAndIncS2UTF32FE();
                }
                assert (TStringGuards.isBroken(codeRange));
                return InternalNextNode.utf32BrokenIntl(it, errorHandler, it.readAndIncS2UTF32FE(), 4);
            }
            if (TStringGuards.isUTF16FE(enc)) {
                if (TStringGuards.isValid(codeRange)) {
                    return InternalNextNode.utf16ValidIntl(it, true);
                }
                assert (TStringGuards.isBroken(codeRange));
                return InternalNextNode.utf16BrokenIntl(it, true, errorHandler);
            }
            assert (TStringGuards.isUnsupportedEncoding(enc));
            return InternalNextNode.unsupported(it, encoding, errorHandler);
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf8Broken(TruffleStringIterator it, int firstByte, DecodingErrorHandler errorHandler) {
            byte type;
            int startIndex = it.rawIndex - 1;
            int b = firstByte;
            if (b < 128) {
                return b;
            }
            int nBytes = Encodings.utf8CodePointLength(b);
            int codepoint = b & 255 >>> nBytes;
            byte[] stateMachine = Encodings.getUTF8DecodingStateMachine(errorHandler);
            byte state = stateMachine[256 + (type = stateMachine[b])];
            if (state != 12) {
                int maxIndex = Math.min(it.a.length(), it.rawIndex - 1 + nBytes);
                while (it.rawIndex < maxIndex && (state = stateMachine[256 + state + (type = stateMachine[b = it.readFwdS0()])]) != 12) {
                    codepoint = b & 0x3F | codepoint << 6;
                    ++it.rawIndex;
                }
            }
            if (state == 0) {
                return codepoint;
            }
            if (TStringGuards.isDefaultVariant(errorHandler)) {
                if (errorHandler == DecodingErrorHandler.DEFAULT) {
                    it.rawIndex = startIndex + 1;
                }
                return Encodings.invalidCodepoint();
            }
            if (errorHandler == DecodingErrorHandler.RETURN_NEGATIVE) {
                it.rawIndex = startIndex + 1;
            }
            return it.applyErrorHandler(errorHandler, startIndex);
        }

        private static int utf16ValidIntl(TruffleStringIterator it, boolean foreignEndian) {
            char c = (char)it.readAndIncS1(foreignEndian);
            if (Encodings.isUTF16HighSurrogate(c)) {
                assert (it.hasNext());
                assert (Encodings.isUTF16LowSurrogate(it.readFwdS1(foreignEndian)));
                return Character.toCodePoint(c, (char)it.readAndIncS1(foreignEndian));
            }
            return c;
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf16BrokenIntl(TruffleStringIterator it, boolean foreignEndian, DecodingErrorHandler errorHandler) {
            char c = (char)it.readAndIncS1(foreignEndian);
            if (TStringGuards.isReturnNegative(errorHandler) || !TStringGuards.isBuiltin(errorHandler)) {
                if (Encodings.isUTF16Surrogate(c)) {
                    char c2;
                    if (Encodings.isUTF16HighSurrogate(c) && it.hasNext() && Encodings.isUTF16LowSurrogate(c2 = (char)it.readFwdS1(foreignEndian))) {
                        ++it.rawIndex;
                        return Character.toCodePoint(c, c2);
                    }
                    return it.applyErrorHandler(errorHandler, it.rawIndex - 1);
                }
            } else {
                char c2;
                assert (TStringGuards.isDefaultVariant(errorHandler));
                if (Encodings.isUTF16HighSurrogate(c) && it.hasNext() && Encodings.isUTF16LowSurrogate(c2 = (char)it.readFwdS1(foreignEndian))) {
                    ++it.rawIndex;
                    return Character.toCodePoint(c, c2);
                }
            }
            return c;
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf32BrokenIntl(TruffleStringIterator it, DecodingErrorHandler errorHandler, int codepoint, int errOffset) {
            if (Encodings.isValidUnicodeCodepoint(codepoint)) {
                return codepoint;
            }
            return it.applyErrorHandler(errorHandler, it.rawIndex - errOffset);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler) {
            assert (it.hasNext());
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(it.a, it.arrayA);
            int startIndex = it.rawIndex;
            int p = it.a.byteArrayOffset() + it.rawIndex;
            int end = it.a.byteArrayOffset() + it.a.length();
            int length = jcodings.getCodePointLength(encoding, bytes, p, end);
            int codepoint = 0;
            if (length < 1) {
                it.rawIndex = length < -1 ? it.a.length() : ++it.rawIndex;
            } else {
                it.rawIndex += length;
                codepoint = jcodings.readCodePoint(encoding, bytes, p, end, errorHandler);
            }
            if (length < 1 || !jcodings.isValidCodePoint(encoding, codepoint)) {
                return it.applyErrorHandler(errorHandler, startIndex);
            }
            return codepoint;
        }

        static InternalNextNode getUncached() {
            return TruffleStringIteratorFactory.InternalNextNodeGen.getUncached();
        }
    }

    static abstract class InternalPreviousNode
    extends AbstractInternalNode {
        InternalPreviousNode() {
        }

        public final int execute(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler) {
            if (!it.hasPrevious()) {
                throw InternalErrors.illegalState("beginning of string has been reached already");
            }
            return this.executeInternal(node, it, encoding, errorHandler);
        }

        abstract int executeInternal(Node var1, TruffleStringIterator var2, TruffleString.Encoding var3, DecodingErrorHandler var4);

        @Specialization(guards={"isUTF8(encoding)"})
        static int utf8(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile asciiProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            int b = it.readAndDecS0();
            if (asciiProfile.profile(node, TStringGuards.is7Bit(codeRange))) {
                return b;
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRange))) {
                if (b < 128) {
                    return b;
                }
                assert (Encodings.isUTF8ContinuationByte(b));
                int codepoint = b & 0x3F;
                for (int j = 1; j < 4; ++j) {
                    b = it.readAndDecS0();
                    if (j >= 3 || !Encodings.isUTF8ContinuationByte(b)) break;
                    codepoint |= (b & 0x3F) << 6 * j;
                }
                int nBytes = Integer.numberOfLeadingZeros(~(b << 24));
                assert (1 < nBytes && nBytes < 5) : nBytes;
                return codepoint | (b & 255 >>> nBytes) << 6 * (nBytes - 1);
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalPreviousNode.utf8Broken(it, b, errorHandler);
        }

        @Specialization(guards={"isUTF16(encoding)"})
        static int utf16(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile fixedProfile, @Cached @Cached.Exclusive InlinedConditionProfile compressedProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            if (fixedProfile.profile(node, TStringGuards.isFixedWidth(codeRange))) {
                if (compressedProfile.profile(node, it.strideA == 0)) {
                    return it.readAndDecS0();
                }
                return it.readAndDecS1(false);
            }
            if (validProfile.profile(node, TStringGuards.isValid(codeRange))) {
                return InternalPreviousNode.utf16ValidIntl(it, false);
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalPreviousNode.utf16BrokenIntl(it, false, errorHandler);
        }

        @Specialization(guards={"isUTF32(encoding)"})
        static int utf32(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedConditionProfile oneByteProfile, @Cached @Cached.Exclusive InlinedConditionProfile twoByteProfile, @Cached @Cached.Exclusive InlinedConditionProfile validProfile) {
            byte codeRange = it.codeRangeA;
            if (oneByteProfile.profile(node, it.strideA == 0)) {
                assert (TStringGuards.is7Or8Bit(codeRange));
                return it.readAndDecS0();
            }
            if (twoByteProfile.profile(node, it.strideA == 1)) {
                assert (TStringGuards.isUpTo16Bit(codeRange));
                return it.readAndDecS1(false);
            }
            assert (it.strideA == 2);
            int codepoint = it.readAndDecS2();
            if (validProfile.profile(node, TStringGuards.isDefaultVariant(errorHandler) || TStringGuards.isUpToValid(codeRange))) {
                return codepoint;
            }
            assert (TStringGuards.isBroken(codeRange));
            return InternalPreviousNode.utf32BrokenIntl(it, errorHandler, codepoint, 1);
        }

        @Fallback
        static int unlikelyCases(Node node, TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler, @Cached @Cached.Exclusive InlinedIntValueProfile encodingProfile) {
            int enc = encodingProfile.profile(node, encoding.id);
            byte codeRange = it.codeRangeA;
            if (TStringGuards.isUpToValidFixedWidth(codeRange)) {
                return it.readAndDecS0();
            }
            if (TStringGuards.isAscii(enc)) {
                assert (TStringGuards.isBroken(codeRange));
                int codepoint = it.readAndDecS0();
                if (TStringGuards.isDefaultVariant(errorHandler) || codepoint < 128) {
                    return codepoint;
                }
                return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + 1);
            }
            if (TStringGuards.isUTF32FE(enc)) {
                if (TStringGuards.isDefaultVariant(errorHandler) || TStringGuards.isValid(codeRange)) {
                    return it.readAndDecS2UTF32FE();
                }
                assert (TStringGuards.isBroken(codeRange));
                return InternalPreviousNode.utf32BrokenIntl(it, errorHandler, it.readAndDecS2UTF32FE(), 4);
            }
            if (TStringGuards.isUTF16FE(enc)) {
                if (TStringGuards.isValid(codeRange)) {
                    return InternalPreviousNode.utf16ValidIntl(it, true);
                }
                assert (TStringGuards.isBroken(codeRange));
                return InternalPreviousNode.utf16BrokenIntl(it, true, errorHandler);
            }
            assert (TStringGuards.isUnsupportedEncoding(enc));
            return InternalPreviousNode.unsupported(it, encoding, errorHandler);
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf8Broken(TruffleStringIterator it, int firstByte, DecodingErrorHandler errorHandler) {
            int startIndex = it.rawIndex + 1;
            int b = firstByte;
            if (b < 128) {
                return b;
            }
            int codepoint = b & 0x3F;
            byte[] stateMachine = Encodings.getUTF8DecodingStateMachineReverse(errorHandler);
            byte type = stateMachine[b];
            byte state = stateMachine[256 + type];
            int shift = 6;
            assert (state != 0);
            if (state > 24) {
                while (it.rawIndex > 0 && (state = stateMachine[256 + state + (type = stateMachine[b = it.readAndDecS0()])]) > 24) {
                    codepoint |= (b & 0x3F) << shift;
                    shift += 6;
                }
            }
            if (state == 0) {
                return (255 >> type & b) << shift | codepoint;
            }
            if (TStringGuards.isDefaultVariant(errorHandler)) {
                if (errorHandler == DecodingErrorHandler.DEFAULT || state != 24) {
                    it.rawIndex = startIndex - 1;
                }
                return Encodings.invalidCodepoint();
            }
            if (errorHandler == DecodingErrorHandler.RETURN_NEGATIVE) {
                it.rawIndex = startIndex - 1;
            }
            return it.applyErrorHandler(errorHandler, startIndex);
        }

        private static int utf16ValidIntl(TruffleStringIterator it, boolean foreignEndian) {
            char c = (char)it.readAndDecS1(foreignEndian);
            if (Encodings.isUTF16LowSurrogate(c)) {
                assert (Encodings.isUTF16HighSurrogate((char)it.readBckS1(foreignEndian)));
                return Character.toCodePoint((char)it.readAndDecS1(foreignEndian), c);
            }
            return c;
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf16BrokenIntl(TruffleStringIterator it, boolean foreignEndian, DecodingErrorHandler errorHandler) {
            char c2;
            char c = (char)it.readAndDecS1(foreignEndian);
            if (TStringGuards.isReturnNegative(errorHandler) || !TStringGuards.isBuiltin(errorHandler)) {
                if (Encodings.isUTF16Surrogate(c)) {
                    char c22;
                    if (Encodings.isUTF16LowSurrogate(c) && it.hasPrevious() && Encodings.isUTF16HighSurrogate(c22 = (char)it.readBckS1(foreignEndian))) {
                        --it.rawIndex;
                        return Character.toCodePoint(c22, c);
                    }
                    return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + 1);
                }
            } else if (Encodings.isUTF16LowSurrogate(c) && it.hasPrevious() && Encodings.isUTF16HighSurrogate(c2 = (char)it.readBckS1(foreignEndian))) {
                --it.rawIndex;
                return Character.toCodePoint(c2, c);
            }
            return c;
        }

        @HostCompilerDirectives.InliningCutoff
        private static int utf32BrokenIntl(TruffleStringIterator it, DecodingErrorHandler errorHandler, int codepoint, int errOffset) {
            if (Encodings.isValidUnicodeCodepoint(codepoint)) {
                return codepoint;
            }
            return it.applyErrorHandlerReverse(errorHandler, it.rawIndex + errOffset);
        }

        @CompilerDirectives.TruffleBoundary
        private static int unsupported(TruffleStringIterator it, TruffleString.Encoding encoding, DecodingErrorHandler errorHandler) {
            assert (it.hasPrevious());
            JCodings jcodings = JCodings.getInstance();
            byte[] bytes = JCodings.asByteArray(it.a, it.arrayA);
            int start = it.a.byteArrayOffset();
            int index = it.a.byteArrayOffset() + it.rawIndex;
            int end = it.a.byteArrayOffset() + it.a.length();
            int prevIndex = jcodings.getPreviousCodePointIndex(encoding, bytes, start, index, end);
            int codepoint = 0;
            if (prevIndex < 0) {
                --it.rawIndex;
            } else {
                assert (prevIndex >= it.a.byteArrayOffset());
                assert (prevIndex < index);
                it.rawIndex = prevIndex - it.a.byteArrayOffset();
                codepoint = jcodings.readCodePoint(encoding, bytes, prevIndex, end, errorHandler);
            }
            if (prevIndex < 0 || !jcodings.isValidCodePoint(encoding, codepoint)) {
                return it.applyErrorHandlerReverse(errorHandler, index);
            }
            return codepoint;
        }

        static InternalPreviousNode getUncached() {
            return TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached();
        }
    }
}

