/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.gds.ng.listeners.TransactionListenerDispatcher;

public abstract class AbstractFbTransaction
implements FbTransaction {
    private static final Set<TransactionState> ALLOWED_INITIAL_STATES = Collections.unmodifiableSet(EnumSet.of(TransactionState.ACTIVE, TransactionState.PREPARED));
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final FbDatabase database;
    protected final TransactionListenerDispatcher transactionListenerDispatcher = new TransactionListenerDispatcher();
    private volatile TransactionState state;

    protected AbstractFbTransaction(TransactionState initialState, FbDatabase database) {
        if (!ALLOWED_INITIAL_STATES.contains((Object)initialState)) {
            throw new IllegalArgumentException(String.format("Illegal initial transaction state: %s, allowed states are: %s", new Object[]{initialState, ALLOWED_INITIAL_STATES}));
        }
        this.state = initialState;
        this.database = Objects.requireNonNull(database, "database");
    }

    @Override
    public final TransactionState getState() {
        return this.state;
    }

    protected final void switchState(TransactionState newState) throws SQLException {
        block9: {
            try (LockCloseable ignored = this.withLock();){
                TransactionState currentState = this.state;
                if (currentState == newState) {
                    return;
                }
                if (currentState.isValidTransition(newState)) {
                    this.state = newState;
                    this.transactionListenerDispatcher.transactionStateChanged(this, newState, currentState);
                    break block9;
                }
                throw FbExceptionBuilder.forException(337248305).messageParameter((Object)newState, (Object)currentState).toSQLException();
            }
        }
    }

    @Override
    public final void addTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void addWeakTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.addWeakListener(listener);
    }

    @Override
    public final void removeTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.removeListener(listener);
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    @Override
    public <T> T getTransactionInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getTransactionInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public long getTransactionId() throws SQLException {
        return this.getTransactionInfo(new byte[]{4}, 16, infoResponse -> {
            if (infoResponse[0] != 4) {
                throw FbExceptionBuilder.forException(337248306).messageParameter("transaction", "isc_info_tra_id", 4, infoResponse[0]).toSQLException();
            }
            int length = VaxEncoding.iscVaxInteger2(infoResponse, 1);
            return VaxEncoding.iscVaxLong(infoResponse, 3, length);
        });
    }

    protected final LockCloseable withLock() {
        return this.database.withLock();
    }

    protected FbDatabase getDatabase() {
        return this.database;
    }

    protected final void logUnexpectedState(TransactionState expectedState, System.Logger log) {
        TransactionState transactionState = this.getState();
        if (transactionState != expectedState && log.isLoggable(System.Logger.Level.WARNING)) {
            String message = "Expected state: " + String.valueOf((Object)expectedState) + ", but state was: " + String.valueOf((Object)transactionState);
            log.log(System.Logger.Level.WARNING, message + "; see debug level for stacktrace");
            if (log.isLoggable(System.Logger.Level.DEBUG)) {
                log.log(System.Logger.Level.DEBUG, message, (Throwable)new RuntimeException("State " + String.valueOf((Object)expectedState) + " unexpectedly not reached"));
            }
        }
    }
}

