/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.JobCallback;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.FinalizationRecord;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import java.lang.ref.ReferenceQueue;
import java.util.List;

public final class JSFinalizationRegistryObject
extends JSNonProxyObject {
    JobCallback cleanupCallback;
    List<FinalizationRecord> cells;
    ReferenceQueue<Object> referenceQueue;

    protected JSFinalizationRegistryObject(Shape shape, JSDynamicObject proto, JobCallback cleanupCallback, List<FinalizationRecord> cells, ReferenceQueue<Object> referenceQueue) {
        super(shape, proto);
        this.cleanupCallback = cleanupCallback;
        this.cells = cells;
        this.referenceQueue = referenceQueue;
    }

    public JobCallback getCleanupCallback() {
        return this.cleanupCallback;
    }

    public List<FinalizationRecord> getCells() {
        return this.cells;
    }

    public ReferenceQueue<Object> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public TruffleString getClassName() {
        return JSFinalizationRegistry.CLASS_NAME;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        return Strings.addBrackets(this.getClassName());
    }
}

