/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import schemacrawler.ermodel.model.Entity;
import schemacrawler.ermodel.model.RelationshipCardinality;
import schemacrawler.ermodel.model.TableReferenceRelationship;
import schemacrawler.schema.NamedObject;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;

final class MutableTableReferenceRelationship
implements TableReferenceRelationship {
    private static final long serialVersionUID = 3561028568798848133L;
    private final TableReference tableReference;
    private RelationshipCardinality cardinality;
    private Entity leftEntity;
    private Entity rightEntity;

    public MutableTableReferenceRelationship(TableReference tableReference) {
        this.tableReference = Objects.requireNonNull(tableReference, "No table reference provided");
        this.cardinality = RelationshipCardinality.unknown;
    }

    @Override
    public int compareTo(NamedObject namedObj) {
        if (namedObj == null) {
            return 1;
        }
        return this.key().compareTo(namedObj.key());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamedObject) {
            NamedObject namedObj = (NamedObject)obj;
            return this.key().equals(namedObj.key());
        }
        return false;
    }

    @Override
    public <T> T getAttribute(String name) {
        return this.tableReference.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) throws ClassCastException {
        return this.tableReference.getAttribute(name, defaultValue);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.tableReference.getAttributes();
    }

    public String getDefinition() {
        return this.tableReference.getDefinition();
    }

    @Override
    public String getFullName() {
        return this.tableReference.getFullName();
    }

    @Override
    public Entity getLeftEntity() {
        return this.leftEntity;
    }

    @Override
    public String getName() {
        return this.tableReference.getName();
    }

    @Override
    public String getRemarks() {
        return this.tableReference.getRemarks();
    }

    @Override
    public Entity getRightEntity() {
        return this.rightEntity;
    }

    @Override
    public TableReference getTableReference() {
        return this.tableReference;
    }

    @Override
    public RelationshipCardinality getType() {
        return this.cardinality;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.tableReference.hasAttribute(name);
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    @Override
    public boolean hasRemarks() {
        return this.tableReference.hasRemarks();
    }

    public boolean isOptional() {
        return this.tableReference.isOptional();
    }

    public boolean isSelfReferencing() {
        return this.tableReference.isSelfReferencing();
    }

    @Override
    public NamedObjectKey key() {
        return this.tableReference.key();
    }

    @Override
    public <T> Optional<T> lookupAttribute(String name) {
        return this.tableReference.lookupAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.tableReference.removeAttribute(name);
    }

    @Override
    public <T> void setAttribute(String name, T value) {
        this.tableReference.setAttribute(name, value);
    }

    @Override
    public void setRemarks(String remarks) {
        this.tableReference.setRemarks(remarks);
    }

    public String toString() {
        return this.tableReference.toString();
    }

    void setCardinality(RelationshipCardinality cardinality) {
        if (cardinality != null) {
            this.cardinality = cardinality;
        }
    }

    void setLeftEntity(Entity leftEntity) {
        this.leftEntity = Objects.requireNonNull(leftEntity, "No left entity provided");
        if (!leftEntity.key().equals(this.tableReference.getForeignKeyTable().key())) {
            throw new ExecutionRuntimeException("Table reference left key does not match");
        }
    }

    void setRightEntity(Entity rightEntity) {
        this.rightEntity = Objects.requireNonNull(rightEntity, "No right entity provided");
        if (!rightEntity.key().equals(this.tableReference.getPrimaryKeyTable().key())) {
            throw new ExecutionRuntimeException("Table reference right key does not match");
        }
    }
}

