/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstArgumentList;
import com.jetbrains.python.ast.PyAstCallSiteExpression;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.ast.PyAstKeywordArgument;
import com.jetbrains.python.ast.PyAstParenthesizedExpression;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.PyAstReferenceExpression;
import com.jetbrains.python.ast.impl.PyUtilCore;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstCallExpression
extends PyAstCallSiteExpression {
    @Override
    @Nullable
    default public PyAstExpression getReceiver(@Nullable PyAstCallable resolvedCallee) {
        PyAstFunction function;
        if (resolvedCallee instanceof PyAstFunction && !"__new__".equals((function = (PyAstFunction)resolvedCallee).getName()) && function.getModifier() == PyAstFunction.Modifier.STATICMETHOD) {
            return null;
        }
        PyAstExpression callee = this.getCallee();
        if (callee != null && PyAstCallExpression.isImplicitlyInvokedMethod(resolvedCallee) && !Objects.equals(resolvedCallee.getName(), callee.getName())) {
            return callee;
        }
        if (callee instanceof PyAstQualifiedExpression) {
            return ((PyAstQualifiedExpression)callee).getQualifier();
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isImplicitlyInvokedMethod(@Nullable PyAstCallable resolvedCallee) {
        if (PyUtilCore.isConstructorLikeMethod((PsiElement)resolvedCallee)) {
            return true;
        }
        if (resolvedCallee instanceof PyAstFunction) {
            PyAstFunction function = (PyAstFunction)resolvedCallee;
            return "__call__".equals(function.getName()) && function.getContainingClass() != null;
        }
        return false;
    }

    @NotNull
    default public List<PyAstExpression> getArguments(@Nullable PyAstCallable resolvedCallee) {
        List<PyAstExpression> list = Arrays.asList(this.getArguments());
        if (list == null) {
            PyAstCallExpression.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    default public PyAstExpression getCallee() {
        Object seeker = this.getFirstChild();
        while (seeker instanceof PyAstParenthesizedExpression) {
            seeker = ((PyAstParenthesizedExpression)seeker).getContainedExpression();
        }
        return seeker instanceof PyAstExpression ? (PyAstExpression)seeker : null;
    }

    @Nullable
    default public PyAstArgumentList getArgumentList() {
        return (PyAstArgumentList)PsiTreeUtil.getChildOfType((PsiElement)this, PyAstArgumentList.class);
    }

    default public PyAstExpression @NotNull [] getArguments() {
        PyAstArgumentList argList = this.getArgumentList();
        PyAstExpression[] pyAstExpressionArray = argList != null ? argList.getArguments() : PyAstExpression.EMPTY_ARRAY;
        if (pyAstExpressionArray == null) {
            PyAstCallExpression.$$$reportNull$$$0(1);
        }
        return pyAstExpressionArray;
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NotNull Class<T> argClass) {
        PyAstExpression[] args;
        if (argClass == null) {
            PyAstCallExpression.$$$reportNull$$$0(2);
        }
        return (T)((args = this.getArguments()).length > index ? (PsiElement)ObjectUtils.tryCast((Object)args[index], argClass) : null);
    }

    @Nullable
    default public <T extends PsiElement> T getArgument(int index, @NonNls @NotNull String keyword, @NotNull Class<T> argClass) {
        PyAstExpression arg;
        if (keyword == null) {
            PyAstCallExpression.$$$reportNull$$$0(3);
        }
        if (argClass == null) {
            PyAstCallExpression.$$$reportNull$$$0(4);
        }
        if ((arg = this.getKeywordArgument(keyword)) != null) {
            return (T)((PsiElement)ObjectUtils.tryCast((Object)arg, argClass));
        }
        return this.getArgument(index, argClass);
    }

    @Nullable
    default public PyAstExpression getKeywordArgument(@NotNull String keyword) {
        if (keyword == null) {
            PyAstCallExpression.$$$reportNull$$$0(5);
        }
        for (PyAstExpression arg : this.getArguments()) {
            PyAstKeywordArgument keywordArg;
            if (!(arg instanceof PyAstKeywordArgument) || !keyword.equals((keywordArg = (PyAstKeywordArgument)arg).getKeyword())) continue;
            return keywordArg.getValueExpression();
        }
        return null;
    }

    default public boolean isCalleeText(String ... nameCandidates) {
        PyAstExpression callee;
        if (nameCandidates == null) {
            PyAstCallExpression.$$$reportNull$$$0(6);
        }
        return (callee = this.getCallee()) instanceof PyAstReferenceExpression && ContainerUtil.exists((Object[])nameCandidates, name2 -> name2.equals(((PyAstReferenceExpression)callee).getReferencedName()));
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyCallExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/ast/PyAstCallExpression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/ast/PyAstCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgument";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordArgument";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCalleeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

