/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.text.RichText;
import net.sourceforge.plantuml.text.StyledString;

public abstract class StringBounderRaw
implements StringBounder {
    private final FontRenderContext frc;

    protected StringBounderRaw(FontRenderContext frc) {
        this.frc = frc;
    }

    @Override
    public final XDimension2D calculateDimension(UFont font, String text) {
        if (font == null) {
            return this.calculateDimensionInternal(null, text);
        }
        if (RichText.isRich(text)) {
            double width = 0.0;
            double height = 0.0;
            for (StyledString s : StyledString.build(text)) {
                UFont newFont = s.getStyle().mutateFont(font);
                XDimension2D rect = this.calculateDimensionInternal(newFont, s.getText());
                width += rect.getWidth();
                height = Math.max(height, rect.getHeight());
            }
            return new XDimension2D(width, height);
        }
        return this.calculateDimensionInternal(font, text);
    }

    protected abstract XDimension2D calculateDimensionInternal(UFont var1, String var2);

    @Override
    public double getDescent(UFont font, String text) {
        LineMetrics lineMetrics = font.getUnderlayingFont(text).getLineMetrics(text, this.frc);
        double descent = lineMetrics.getDescent();
        return descent;
    }
}

