/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.creole.Parser;
import net.sourceforge.plantuml.klimt.creole.command.Command;
import net.sourceforge.plantuml.klimt.creole.legacy.StripeSimple;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.Pattern2;

public class CommandCreoleImg
implements Command {
    private static final Pattern2 pattern = Pattern2.cmpile("^(\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");

    @Override
    public String startingChars() {
        return "<";
    }

    private CommandCreoleImg() {
    }

    public static Command create() {
        return new CommandCreoleImg();
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = Parser.getScale(m.group(3), 1.0);
        if (src.toLowerCase().startsWith("src=")) {
            src = src.substring(4);
        }
        src = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(src, "\"");
        stripe.addImage(src, scale);
        return line.substring(m.group(1).length());
    }
}

