/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;

public class HTTPClientCertAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    public static final String OPENDISTRO_SECURITY_SSL_SKIP_USERS = "skip_users";
    protected final Settings settings;
    private final WildcardMatcher skipUsersMatcher;
    private final ParsedAttribute parsedUsernameAttr;
    private final ParsedAttribute parsedRolesAttr;
    private static final int MAX_SAN_MATCHES = 16;
    private static final int MAX_SAN_VALUE_LEN = 8192;

    private ParsedAttribute parseAttributeSetting(String raw) {
        if (Strings.isNullOrEmpty((String)raw)) {
            return null;
        }
        String s = raw.trim();
        if (s.regionMatches(true, 0, "san:", 0, 4)) {
            SANType sanType;
            String rest = s.substring(4);
            int firstColon = rest.indexOf(58);
            String sanField = firstColon >= 0 ? rest.substring(0, firstColon) : rest;
            String glob = firstColon >= 0 ? rest.substring(firstColon + 1) : null;
            try {
                sanType = HTTPClientCertAuthenticator.parseSanTypeToken(sanField);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Unsupported SAN type '{}' in attribute '{}'", (Object)sanField, (Object)raw);
                return null;
            }
            WildcardMatcher matcher = WildcardMatcher.ANY;
            if (!Strings.isNullOrEmpty((String)glob)) {
                if (glob.indexOf(63) >= 0 || glob.startsWith("/") && glob.endsWith("/")) {
                    this.log.warn("Unsupported SAN glob (only literals and '*' are allowed, case-insensitive). attribute='{}'", (Object)raw);
                    return null;
                }
                matcher = "*".equals(glob.trim()) ? WildcardMatcher.ANY : WildcardMatcher.from(glob).ignoreCase();
            }
            return ParsedAttribute.san(new ParsedSAN(sanType.getValue(), matcher));
        }
        String dnAttr = s.regionMatches(true, 0, "dn:", 0, 3) ? s.substring(3) : s;
        return ParsedAttribute.dn(dnAttr);
    }

    public HTTPClientCertAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
        this.skipUsersMatcher = WildcardMatcher.from(settings.getAsList(OPENDISTRO_SECURITY_SSL_SKIP_USERS));
        this.parsedUsernameAttr = this.parseAttributeSetting(settings.get("username_attribute"));
        this.parsedRolesAttr = this.parseAttributeSetting(settings.get("roles_attribute"));
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext threadContext) {
        String principal = (String)threadContext.getTransient("_opendistro_security_ssl_principal");
        if (Strings.isNullOrEmpty((String)principal)) {
            this.log.trace("No CLIENT CERT, send 401");
            return null;
        }
        if (this.skipUsersMatcher.test(principal)) {
            this.log.debug("Skipped user client cert authentication of user {} as its in skip_users list ", (Object)principal);
            return null;
        }
        try {
            String username = this.extractUsername(threadContext, principal);
            String[] roles = this.extractRoles(threadContext, principal);
            return new AuthCredentials(username, roles).markComplete();
        }
        catch (InvalidNameException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Invalid client certificate DN; principal='{}'", (Object)principal, (Object)e);
            } else {
                this.log.warn("Client cert had no properly formed DN.  {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private String extractUsername(ThreadContext ctx, String principal) throws InvalidNameException {
        if (this.parsedUsernameAttr == null || this.parsedUsernameAttr.type == AttributeType.DN && this.parsedUsernameAttr.dnAttr == null) {
            return principal;
        }
        List<String> usernames = this.parsedUsernameAttr.type == AttributeType.DN ? this.getDnAttribute(new LdapName(principal), this.parsedUsernameAttr.dnAttr) : this.extractFromSAN(ctx, this.parsedUsernameAttr.san);
        return usernames == null || usernames.isEmpty() ? principal : usernames.get(0);
    }

    private String[] extractRoles(ThreadContext ctx, String principal) throws InvalidNameException {
        if (this.parsedRolesAttr == null || this.parsedRolesAttr.type == AttributeType.DN && this.parsedRolesAttr.dnAttr == null) {
            return null;
        }
        List<String> roles = this.parsedRolesAttr.type == AttributeType.DN ? this.getDnAttribute(new LdapName(principal), this.parsedRolesAttr.dnAttr) : this.extractFromSAN(ctx, this.parsedRolesAttr.san);
        return roles == null || roles.isEmpty() ? null : roles.toArray(new String[0]);
    }

    private List<String> getDnAttribute(LdapName rfc2253dn, String attribute) {
        ArrayList<String> attrValues = new ArrayList<String>(rfc2253dn.size());
        ArrayList<Rdn> reverseRdn = new ArrayList<Rdn>(rfc2253dn.getRdns());
        Collections.reverse(reverseRdn);
        for (Rdn rdn : reverseRdn) {
            if (!rdn.getType().equalsIgnoreCase(attribute)) continue;
            attrValues.add(rdn.getValue().toString());
        }
        return Collections.unmodifiableList(attrValues);
    }

    private List<String> extractFromSAN(ThreadContext ctx, ParsedSAN psan) {
        if (psan == null) {
            return Collections.emptyList();
        }
        X509Certificate[] peerCertificates = (X509Certificate[])ctx.getTransient("_opendistro_security_ssl_peer_certificates");
        if (peerCertificates == null || peerCertificates.length == 0) {
            return Collections.emptyList();
        }
        try {
            Collection<List<?>> altNames = peerCertificates[0].getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
            int sanType = psan.type();
            WildcardMatcher matcher = psan.matcher();
            return altNames.stream().filter(entry -> entry != null && entry.size() >= 2).filter(entry -> {
                Integer i;
                Object patt0$temp = entry.get(0);
                return patt0$temp instanceof Integer && (i = (Integer)patt0$temp) == sanType;
            }).map(entry -> HTTPClientCertAuthenticator.sanValueToString(sanType, entry.get(1))).map(v -> {
                if (Strings.isNullOrEmpty((String)v)) {
                    return null;
                }
                String s = v.length() > 8192 ? v.substring(0, 8192) : v;
                return matcher.test(s) ? s : null;
            }).filter(Objects::nonNull).limit(16L).collect(Collectors.toList());
        }
        catch (CertificateParsingException e) {
            this.log.error("Error parsing X509 certificate", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static String sanValueToString(int type, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (type == SANType.IP_ADDRESS.value && value instanceof byte[]) {
            byte[] addr = (byte[])value;
            try {
                return InetAddress.getByAddress(addr).getHostAddress();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest response, AuthCredentials creds) {
        return Optional.empty();
    }

    @Override
    public String getType() {
        return "clientcert";
    }

    private static SANType parseSanTypeToken(String token) {
        String t;
        return switch (t = token.toLowerCase(Locale.ROOT)) {
            case "othername" -> SANType.OTHER_NAME;
            case "rfc822name" -> SANType.EMAIL;
            case "dnsname" -> SANType.DNS;
            case "x400address" -> SANType.X400_ADDRESS;
            case "directoryname" -> SANType.DIRECTORY_NAME;
            case "edipartyname" -> SANType.EDI_PARTY_NAME;
            case "uniformresourceidentifier" -> SANType.URI;
            case "ipaddress" -> SANType.IP_ADDRESS;
            case "registeredid" -> SANType.REGISTERED_ID;
            default -> throw new IllegalArgumentException("Unsupported SAN type token: " + token);
        };
    }

    private static enum SANType {
        OTHER_NAME(0),
        EMAIL(1),
        DNS(2),
        X400_ADDRESS(3),
        DIRECTORY_NAME(4),
        EDI_PARTY_NAME(5),
        URI(6),
        IP_ADDRESS(7),
        REGISTERED_ID(8);

        private static final Map<Integer, SANType> lookup;
        private final int value;

        private SANType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SANType fromValue(int value) {
            return lookup.get(value);
        }

        static {
            lookup = EnumSet.allOf(SANType.class).stream().collect(Collectors.toMap(SANType::getValue, sanType -> sanType));
        }
    }

    private record ParsedSAN(int type, WildcardMatcher matcher) {
    }

    private record ParsedAttribute(AttributeType type, String dnAttr, ParsedSAN san) {
        static ParsedAttribute dn(String dnAttr) {
            return new ParsedAttribute(AttributeType.DN, dnAttr, null);
        }

        static ParsedAttribute san(ParsedSAN san) {
            return new ParsedAttribute(AttributeType.SAN, null, san);
        }
    }

    private static enum AttributeType {
        DN,
        SAN;

    }
}

