/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2PingFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import reactor.netty.ReactorNetty;
import reactor.netty.http.HttpConnectionLiveness;

public final class Http2ConnectionLiveness
implements HttpConnectionLiveness {
    private final Http2FrameWriter http2FrameWriter;
    private final int pingAckDropThreshold;
    private final long pingAckTimeoutNanos;
    private boolean isPingAckPending;
    private long lastSentPingData;
    private @Nullable ScheduledFuture<?> pingScheduler;
    private int pingAttempts;

    public Http2ConnectionLiveness(Http2FrameCodec http2FrameCodec, int pingAckDropThreshold, long pingAckTimeoutNanos) {
        this.http2FrameWriter = http2FrameCodec.encoder().frameWriter();
        this.pingAckDropThreshold = pingAckDropThreshold;
        this.pingAckTimeoutNanos = pingAckTimeoutNanos;
    }

    @Override
    public void cancel() {
        this.isPingAckPending = false;
        this.pingAttempts = 0;
        if (this.pingScheduler != null) {
            this.pingScheduler.cancel(false);
            this.pingScheduler = null;
        }
    }

    @Override
    public void check(ChannelHandlerContext ctx) {
        if (!this.isPingAckPending) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ctx.channel(), (String)"Connection was idle. Starting probing with PING frame: timeout={} ns."), new Object[]{this.pingAckTimeoutNanos});
            }
            PingTimeoutTask pingTimeoutTask = new PingTimeoutTask(ctx);
            pingTimeoutTask.writePing();
        }
    }

    @Override
    public void receive(Object msg) {
        if (this.isPingAckPending) {
            if (msg instanceof Http2PingFrame) {
                Http2PingFrame frame = (Http2PingFrame)msg;
                if (frame.ack() && frame.content() == this.lastSentPingData) {
                    this.cancel();
                }
            } else if (msg instanceof Http2HeadersFrame || msg instanceof Http2DataFrame) {
                this.cancel();
            }
        }
    }

    class PingTimeoutTask
    implements ChannelFutureListener,
    Runnable {
        private final ChannelHandlerContext ctx;

        PingTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void operationComplete(ChannelFuture future) {
            if (!future.channel().isActive()) {
                return;
            }
            if (future.isSuccess()) {
                if (HttpConnectionLiveness.log.isDebugEnabled()) {
                    HttpConnectionLiveness.log.debug(ReactorNetty.format((Channel)future.channel(), (String)"PING frame was sent: ping data={}, ping attempts={}."), new Object[]{Http2ConnectionLiveness.this.lastSentPingData, Http2ConnectionLiveness.this.pingAttempts});
                }
            } else if (HttpConnectionLiveness.log.isDebugEnabled()) {
                HttpConnectionLiveness.log.debug(ReactorNetty.format((Channel)future.channel(), (String)"Failed to send PING frame: ping data={}, ping attempts={}. Will wait timeout and retry based on threshold."), new Object[]{Http2ConnectionLiveness.this.lastSentPingData, Http2ConnectionLiveness.this.pingAttempts});
            }
            Http2ConnectionLiveness.this.pingScheduler = this.invokeNextSchedule();
        }

        @Override
        public void run() {
            Channel channel = this.ctx.channel();
            if (channel == null || !channel.isActive() || !Http2ConnectionLiveness.this.isPingAckPending) {
                return;
            }
            if (this.isExceedAckDropThreshold()) {
                if (HttpConnectionLiveness.log.isDebugEnabled()) {
                    HttpConnectionLiveness.log.debug(ReactorNetty.format((Channel)channel, (String)"Closing connection due to delayed PING ACK response: timeout={} ns, attempts={}, threshold={}."), new Object[]{Http2ConnectionLiveness.this.pingAckTimeoutNanos, Http2ConnectionLiveness.this.pingAttempts, Http2ConnectionLiveness.this.pingAckDropThreshold});
                }
                this.ctx.close();
            } else {
                if (HttpConnectionLiveness.log.isDebugEnabled()) {
                    HttpConnectionLiveness.log.debug(ReactorNetty.format((Channel)channel, (String)"PING ACK response delayed: timeout={} ns, attempts={}, threshold={}. Retrying PING frame."), new Object[]{Http2ConnectionLiveness.this.pingAckTimeoutNanos, Http2ConnectionLiveness.this.pingAttempts, Http2ConnectionLiveness.this.pingAckDropThreshold});
                }
                this.writePing();
            }
        }

        private ScheduledFuture<?> invokeNextSchedule() {
            return this.ctx.executor().schedule((Runnable)this, Http2ConnectionLiveness.this.pingAckTimeoutNanos, TimeUnit.NANOSECONDS);
        }

        private boolean isExceedAckDropThreshold() {
            return Http2ConnectionLiveness.this.pingAttempts >= Http2ConnectionLiveness.this.pingAckDropThreshold;
        }

        private void writePing() {
            Http2ConnectionLiveness.this.isPingAckPending = true;
            Http2ConnectionLiveness.this.pingAttempts++;
            Http2ConnectionLiveness.this.lastSentPingData = ThreadLocalRandom.current().nextLong();
            Http2ConnectionLiveness.this.http2FrameWriter.writePing(this.ctx, false, Http2ConnectionLiveness.this.lastSentPingData, this.ctx.newPromise()).addListener((GenericFutureListener)this);
            this.ctx.flush();
        }
    }
}

