/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.AcknowledgedResponseBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CloneIndexResponse
extends AcknowledgedResponseBase
implements ToCopyableBuilder<Builder, CloneIndexResponse> {
    @Nonnull
    private final String index;
    private final boolean shardsAcknowledged;
    public static final JsonpDeserializer<CloneIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloneIndexResponse::setupCloneIndexResponseDeserializer);

    private CloneIndexResponse(Builder builder) {
        super(builder);
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, this, "shardsAcknowledged");
    }

    public static CloneIndexResponse of(Function<Builder, ObjectBuilder<CloneIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String index() {
        return this.index;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCloneIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        CloneIndexResponse.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + Boolean.hashCode(this.shardsAcknowledged);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloneIndexResponse other = (CloneIndexResponse)o;
        return this.index.equals(other.index) && this.shardsAcknowledged == other.shardsAcknowledged;
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CloneIndexResponse> {
        private String index;
        private Boolean shardsAcknowledged;

        public Builder() {
        }

        private Builder(CloneIndexResponse o) {
            super(o);
            this.index = o.index;
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        private Builder(Builder o) {
            super(o);
            this.index = o.index;
            this.shardsAcknowledged = o.shardsAcknowledged;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        @Override
        @Nonnull
        public CloneIndexResponse build() {
            this._checkSingleUse();
            return new CloneIndexResponse(this);
        }
    }
}

