/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.DocRequest;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Config;

public class SuggestConfigParamRequest
extends ActionRequest
implements DocRequest {
    private final AnalysisType context;
    private final Config config;
    private final String param;
    private final TimeValue requestTimeout;

    public SuggestConfigParamRequest(StreamInput in) throws IOException {
        super(in);
        this.context = (AnalysisType)in.readEnum(AnalysisType.class);
        if (this.getContext().isAD()) {
            this.config = new AnomalyDetector(in);
        } else if (this.getContext().isForecast()) {
            this.config = new Forecaster(in);
        } else {
            throw new UnsupportedOperationException("This method is not supported");
        }
        this.param = in.readString();
        this.requestTimeout = in.readTimeValue();
    }

    public SuggestConfigParamRequest(AnalysisType context, Config config, String param, TimeValue requestTimeout) {
        this.context = context;
        this.config = config;
        this.param = param;
        this.requestTimeout = requestTimeout;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.getContext());
        this.config.writeTo(out);
        out.writeString(this.param);
        out.writeTimeValue(this.requestTimeout);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getParam() {
        return this.param;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }

    public AnalysisType getContext() {
        return this.context;
    }

    public String type() {
        return this.context.isAD() ? "anomaly-detector" : "forecaster";
    }

    public String index() {
        if (this.context.isAD()) {
            return ADIndex.CONFIG.getIndexName();
        }
        return ForecastIndex.CONFIG.getIndexName();
    }

    public String id() {
        return this.config.getId();
    }

    /*
     * Exception decompiling
     */
    public static SuggestConfigParamRequest fromActionRequest(ActionRequest actionRequest, NamedWriteableRegistry namedWriteableRegistry) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

