# -*- coding: binary -*-

module Msf
module Exploit::Remote::AutoCheck

  def self.included(_base)
    raise NotImplementedError, "#{name} should not be included, it should be prepended"
  end

  def initialize(info = {})
    super

    register_advanced_options([
      OptBool.new('AutoCheck', [false, 'Run check before exploit', true]),
      OptBool.new('ForceExploit', [false, 'Override check result', false])
    ])
  end

  def run
    with_prepended_auto_check do
      super
    end
  end

  def exploit
    with_prepended_auto_check do
      super
    end
  end

  private

  def with_prepended_auto_check
    unless datastore['AutoCheck']
      print_warning('AutoCheck is disabled, proceeding with exploitation')
      return yield
    end

    print_status('Running automatic check ("set AutoCheck false" to disable)')

    warning_msg = 'ForceExploit is enabled, proceeding with exploitation.'
    error_msg = '"set ForceExploit true" to override check result.'
    check_code = check

    case check_code
    when Exploit::CheckCode::Vulnerable, Exploit::CheckCode::Appears
      print_good(check_code.message)

      if respond_to?(:report_vuln)
        report_vuln_opts = {
          name: fullname,
          username: respond_to?(:owner) ? owner : nil,
          refs: references,
          info: description.strip
        }

        if respond_to?(:session) && session.respond_to?(:session_host)
          report_vuln(
            **report_vuln_opts,
            host: session.session_host
          )
        elsif respond_to?(:rhost)
          report_vuln(
            **report_vuln_opts,
            host: rhost,
            port: respond_to?(:rport) ? rport : nil,
            proto: Msf::DBManager::DEFAULT_SERVICE_PROTO
          )
        end
      end

      return yield
    when Exploit::CheckCode::Detected
      print_warning(check_code.message)
      return yield
    when Exploit::CheckCode::Safe
      failure_type = Module::Failure::NotVulnerable
    when Exploit::CheckCode::Unsupported
      failure_type = Module::Failure::BadConfig
    else
      failure_type = Module::Failure::Unknown
    end

    if datastore['ForceExploit']
      print_warning("#{check_code.message} #{warning_msg}")
      return yield
    end
    fail_with(failure_type, "#{check_code.message} #{error_msg}")
  end

end
end
