/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.http.HttpMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\b\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u0017\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001a\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a1\u0010\u001c\u001a\u00020\u0004\"\b\b\u0000\u0010\u001d*\u00020\u001e*\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\b\u0010!\u001a\u0004\u0018\u0001H\u001d\u00a2\u0006\u0002\u0010\"\u001a\n\u0010#\u001a\u00020\u0001*\u00020\t\u00a8\u0006$"}, d2={"canonicalUrl", "", "url", "commonAddHeader", "Lokhttp3/Request$Builder;", "name", "value", "commonCacheControl", "Lokhttp3/CacheControl;", "Lokhttp3/Request;", "cacheControl", "commonDelete", "body", "Lokhttp3/RequestBody;", "commonGet", "commonHead", "commonHeader", "commonHeaders", "", "headers", "Lokhttp3/Headers;", "commonMethod", "method", "commonNewBuilder", "commonPatch", "commonPost", "commonPut", "commonRemoveHeader", "commonTag", "T", "", "type", "Lkotlin/reflect/KClass;", "tag", "(Lokhttp3/Request$Builder;Lkotlin/reflect/KClass;Ljava/lang/Object;)Lokhttp3/Request$Builder;", "commonToString", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-RequestCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -RequestCommon.kt\nokhttp3/internal/_RequestCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1#2:163\n1864#3,3:164\n*S KotlinDebug\n*F\n+ 1 -RequestCommon.kt\nokhttp3/internal/_RequestCommonKt\n*L\n146#1:164,3\n*E\n"})
public final class _RequestCommonKt {
    @Nullable
    public static final String commonHeader(@NotNull Request $this$commonHeader, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$commonHeader.headers().get(name);
    }

    @NotNull
    public static final List<String> commonHeaders(@NotNull Request $this$commonHeaders, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$commonHeaders.headers().values(name);
    }

    @NotNull
    public static final Request.Builder commonNewBuilder(@NotNull Request $this$commonNewBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$commonNewBuilder, (String)"<this>");
        return new Request.Builder($this$commonNewBuilder);
    }

    @NotNull
    public static final CacheControl commonCacheControl(@NotNull Request $this$commonCacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$commonCacheControl, (String)"<this>");
        CacheControl result = $this$commonCacheControl.getLazyCacheControl$okhttp();
        if (result == null) {
            result = CacheControl.Companion.parse($this$commonCacheControl.headers());
            $this$commonCacheControl.setLazyCacheControl$okhttp(result);
        }
        return result;
    }

    @NotNull
    public static final String canonicalUrl(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith((String)url, (String)"ws:", (boolean)true)) {
            StringBuilder stringBuilder = new StringBuilder().append("http:");
            String string2 = url.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            string = stringBuilder.append(string2).toString();
        } else if (StringsKt.startsWith((String)url, (String)"wss:", (boolean)true)) {
            StringBuilder stringBuilder = new StringBuilder().append("https:");
            String string3 = url.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            string = stringBuilder.append(string3).toString();
        } else {
            string = url;
        }
        return string;
    }

    @NotNull
    public static final Request.Builder commonHeader(@NotNull Request.Builder $this$commonHeader, @NotNull String name, @NotNull String value) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Request.Builder $this$commonHeader_u24lambda_u240 = builder = $this$commonHeader;
        boolean bl = false;
        $this$commonHeader_u24lambda_u240.getHeaders$okhttp().set(name, value);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonAddHeader(@NotNull Request.Builder $this$commonAddHeader, @NotNull String name, @NotNull String value) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Request.Builder $this$commonAddHeader_u24lambda_u241 = builder = $this$commonAddHeader;
        boolean bl = false;
        $this$commonAddHeader_u24lambda_u241.getHeaders$okhttp().add(name, value);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonRemoveHeader(@NotNull Request.Builder $this$commonRemoveHeader, @NotNull String name) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemoveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Request.Builder $this$commonRemoveHeader_u24lambda_u242 = builder = $this$commonRemoveHeader;
        boolean bl = false;
        $this$commonRemoveHeader_u24lambda_u242.getHeaders$okhttp().removeAll(name);
        return builder;
    }

    @NotNull
    public static final Request.Builder commonHeaders(@NotNull Request.Builder $this$commonHeaders, @NotNull Headers headers2) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Request.Builder $this$commonHeaders_u24lambda_u243 = builder = $this$commonHeaders;
        boolean bl = false;
        $this$commonHeaders_u24lambda_u243.setHeaders$okhttp(headers2.newBuilder());
        return builder;
    }

    @NotNull
    public static final Request.Builder commonCacheControl(@NotNull Request.Builder $this$commonCacheControl, @NotNull CacheControl cacheControl) {
        Intrinsics.checkNotNullParameter((Object)$this$commonCacheControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cacheControl, (String)"cacheControl");
        String value = cacheControl.toString();
        return ((CharSequence)value).length() == 0 ? $this$commonCacheControl.removeHeader("Cache-Control") : $this$commonCacheControl.header("Cache-Control", value);
    }

    @NotNull
    public static final Request.Builder commonGet(@NotNull Request.Builder $this$commonGet) {
        Intrinsics.checkNotNullParameter((Object)$this$commonGet, (String)"<this>");
        return $this$commonGet.method("GET", null);
    }

    @NotNull
    public static final Request.Builder commonHead(@NotNull Request.Builder $this$commonHead) {
        Intrinsics.checkNotNullParameter((Object)$this$commonHead, (String)"<this>");
        return $this$commonHead.method("HEAD", null);
    }

    @NotNull
    public static final Request.Builder commonPost(@NotNull Request.Builder $this$commonPost, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter((Object)$this$commonPost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return $this$commonPost.method("POST", body);
    }

    @NotNull
    public static final Request.Builder commonDelete(@NotNull Request.Builder $this$commonDelete, @Nullable RequestBody body) {
        Intrinsics.checkNotNullParameter((Object)$this$commonDelete, (String)"<this>");
        return $this$commonDelete.method("DELETE", body);
    }

    @NotNull
    public static final Request.Builder commonPut(@NotNull Request.Builder $this$commonPut, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter((Object)$this$commonPut, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return $this$commonPut.method("PUT", body);
    }

    @NotNull
    public static final Request.Builder commonPatch(@NotNull Request.Builder $this$commonPatch, @NotNull RequestBody body) {
        Intrinsics.checkNotNullParameter((Object)$this$commonPatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return $this$commonPatch.method("PATCH", body);
    }

    @NotNull
    public static final Request.Builder commonMethod(@NotNull Request.Builder $this$commonMethod, @NotNull String method, @Nullable RequestBody body) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Request.Builder $this$commonMethod_u24lambda_u247 = builder = $this$commonMethod;
        boolean bl = false;
        if (!(((CharSequence)method).length() > 0)) {
            boolean $i$a$-require-_RequestCommonKt$commonMethod$1$42 = false;
            String $i$a$-require-_RequestCommonKt$commonMethod$1$42 = "method.isEmpty() == true";
            throw new IllegalArgumentException($i$a$-require-_RequestCommonKt$commonMethod$1$42.toString());
        }
        if (body == null) {
            if (!(!HttpMethod.requiresRequestBody(method))) {
                boolean $i$a$-require-_RequestCommonKt$commonMethod$1$52 = false;
                String $i$a$-require-_RequestCommonKt$commonMethod$1$52 = "method " + method + " must have a request body.";
                throw new IllegalArgumentException($i$a$-require-_RequestCommonKt$commonMethod$1$52.toString());
            }
        } else if (!HttpMethod.permitsRequestBody(method)) {
            boolean bl2 = false;
            String string = "method " + method + " must not have a request body.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$commonMethod_u24lambda_u247.setMethod$okhttp(method);
        $this$commonMethod_u24lambda_u247.setBody$okhttp(body);
        return builder;
    }

    @NotNull
    public static final <T> Request.Builder commonTag(@NotNull Request.Builder $this$commonTag, @NotNull KClass<T> type, @Nullable T tag) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonTag, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Request.Builder $this$commonTag_u24lambda_u249 = builder = $this$commonTag;
        boolean bl = false;
        if (tag == null) {
            if (!$this$commonTag_u24lambda_u249.getTags$okhttp().isEmpty()) {
                Map<KClass<?>, Object> map = $this$commonTag_u24lambda_u249.getTags$okhttp();
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.reflect.KClass<*>, kotlin.Any>");
                TypeIntrinsics.asMutableMap(map).remove(type);
            }
        } else {
            Map map;
            if ($this$commonTag_u24lambda_u249.getTags$okhttp().isEmpty()) {
                Map map2;
                Map it = map2 = (Map)new LinkedHashMap();
                boolean bl2 = false;
                $this$commonTag_u24lambda_u249.setTags$okhttp(it);
                map = map2;
            } else {
                Map<KClass<?>, Object> map3 = $this$commonTag_u24lambda_u249.getTags$okhttp();
                Intrinsics.checkNotNull(map3, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.reflect.KClass<*>, kotlin.Any>");
                map = TypeIntrinsics.asMutableMap(map3);
            }
            Map mutableTags = map;
            mutableTags.put(type, tag);
        }
        return builder;
    }

    @NotNull
    public static final String commonToString(@NotNull Request $this$commonToString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        StringBuilder $this$commonToString_u24lambda_u2411 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$commonToString_u24lambda_u2411.append("Request{method=");
        $this$commonToString_u24lambda_u2411.append($this$commonToString.method());
        $this$commonToString_u24lambda_u2411.append(", url=");
        $this$commonToString_u24lambda_u2411.append($this$commonToString.url());
        if ($this$commonToString.headers().size() != 0) {
            $this$commonToString_u24lambda_u2411.append(", headers=[");
            Iterable $this$forEachIndexed$iv = $this$commonToString.headers();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl2 = false;
                String name = (String)pair.component1();
                String value = (String)pair.component2();
                if (index > 0) {
                    $this$commonToString_u24lambda_u2411.append(", ");
                }
                $this$commonToString_u24lambda_u2411.append(name);
                $this$commonToString_u24lambda_u2411.append(':');
                $this$commonToString_u24lambda_u2411.append(_UtilCommonKt.isSensitiveHeader(name) ? "\u2588\u2588" : value);
            }
            $this$commonToString_u24lambda_u2411.append(']');
        }
        if (!$this$commonToString.getTags$okhttp().isEmpty()) {
            $this$commonToString_u24lambda_u2411.append(", tags=");
            $this$commonToString_u24lambda_u2411.append($this$commonToString.getTags$okhttp());
        }
        $this$commonToString_u24lambda_u2411.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

