/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.JavaThreadPool;
import com.sun.star.lib.uno.environments.remote.JobQueue;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import java.util.Collection;
import java.util.HashMap;
import java.util.WeakHashMap;

final class JavaThreadPoolFactory {
    private static final WeakHashMap<Thread, ThreadId> threadIdMap = new WeakHashMap();
    private final HashMap<ThreadId, JobQueue> jobQueues = new HashMap();

    JavaThreadPoolFactory() {
    }

    public IThreadPool createThreadPool() {
        return new JavaThreadPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobQueue(JobQueue jobQueue) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.put(jobQueue.getThreadId(), jobQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobQueue(JobQueue jobQueue) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            this.jobQueues.remove(jobQueue.getThreadId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobQueue getJobQueue(ThreadId threadId) {
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            return this.jobQueues.get(threadId);
        }
    }

    public JobQueue getAsyncJobQueue(ThreadId threadId) {
        JobQueue jobQueue = this.getJobQueue(threadId);
        return jobQueue == null ? null : jobQueue._async_jobQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAboutSomeDisposedPool() {
        JobQueue[] jobQueueArray;
        HashMap<ThreadId, JobQueue> hashMap = this.jobQueues;
        synchronized (hashMap) {
            Collection<JobQueue> collection = this.jobQueues.values();
            jobQueueArray = collection.toArray(new JobQueue[collection.size()]);
        }
        for (int i = 0; i < jobQueueArray.length; ++i) {
            jobQueueArray[i].notifyAboutSomeDisposedPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadId getThreadId() {
        ThreadId threadId;
        Thread thread = Thread.currentThread();
        if (thread instanceof JobQueue.JobDispatcher) {
            return ((JobQueue.JobDispatcher)thread).getThreadId();
        }
        WeakHashMap<Thread, ThreadId> weakHashMap = threadIdMap;
        synchronized (weakHashMap) {
            threadId = threadIdMap.get(thread);
            if (threadId == null) {
                threadId = ThreadId.createFresh();
                threadIdMap.put(thread, threadId);
            }
        }
        return threadId;
    }
}

