/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.jose.jws.DefaultTokenManager;
import org.keycloak.keys.DefaultKeyManager;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientScopeProvider;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.IdentityProviderStorageProvider;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransactionManager;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.models.ThemeManager;
import org.keycloak.models.TokenManager;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.InvalidationHandler;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.services.DefaultKeycloakContext;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.DefaultKeycloakTransactionManager;
import org.keycloak.services.clientpolicy.ClientPolicyManager;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.vault.DefaultVaultTranscriber;
import org.keycloak.vault.VaultProvider;
import org.keycloak.vault.VaultTranscriber;

public abstract class DefaultKeycloakSession
implements KeycloakSession {
    private final DefaultKeycloakSessionFactory factory;
    private final Map<List<String>, Provider> providers = new HashMap<List<String>, Provider>();
    private final List<Provider> closable = new LinkedList<Provider>();
    private final DefaultKeycloakTransactionManager transactionManager;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<InvalidationHandler.InvalidableObjectType, Set<Object>> invalidationMap = new HashMap<InvalidationHandler.InvalidableObjectType, Set<Object>>();
    private DatastoreProvider datastoreProvider;
    private final KeycloakContext context;
    private KeyManager keyManager;
    private TokenManager tokenManager;
    private VaultTranscriber vaultTranscriber;
    private ClientPolicyManager clientPolicyManager;
    private boolean closed = false;
    private static final Logger LOG = Logger.getLogger(DefaultKeycloakSession.class);

    public DefaultKeycloakSession(DefaultKeycloakSessionFactory factory) {
        this.factory = factory;
        this.transactionManager = new DefaultKeycloakTransactionManager(this);
        this.context = this.createKeycloakContext(this);
        LOG.tracef("Created %s%s", (Object)this, StackUtil.getShortStackTrace());
    }

    public KeycloakContext getContext() {
        return this.context;
    }

    private DatastoreProvider getDatastoreProvider() {
        if (this.datastoreProvider == null) {
            this.datastoreProvider = this.getProvider(DatastoreProvider.class);
        }
        return this.datastoreProvider;
    }

    public void invalidate(InvalidationHandler.InvalidableObjectType type, Object ... ids) {
        this.factory.invalidate(this, type, ids);
        if (type == InvalidationHandler.ObjectType.PROVIDER_FACTORY) {
            this.invalidationMap.computeIfAbsent(type, o -> new HashSet()).addAll(Arrays.asList(ids));
        }
    }

    public void enlistForClose(Provider provider) {
        for (Provider p : this.closable) {
            if (p != provider) continue;
            return;
        }
        this.closable.add(provider);
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public <T> T getAttribute(String attribute, Class<T> clazz) {
        Object value = this.getAttribute(attribute);
        return (T)(clazz.isInstance(value) ? value : null);
    }

    public Object removeAttribute(String attribute) {
        return this.attributes.remove(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public KeycloakTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public KeycloakSessionFactory getKeycloakSessionFactory() {
        return this.factory;
    }

    public UserProvider users() {
        return this.getDatastoreProvider().users();
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        List<String> key = List.of(clazz.getName());
        return this.getOrCreateProvider(key, () -> this.factory.getProviderFactory(clazz));
    }

    private <T extends Provider> T getOrCreateProvider(List<String> key, Supplier<ProviderFactory<T>> supplier) {
        ProviderFactory<T> providerFactory;
        Provider provider = this.providers.get(key);
        if (provider == null && (providerFactory = supplier.get()) != null) {
            provider = providerFactory.create((KeycloakSession)this);
            this.providers.put(key, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        List<String> key = List.of(clazz.getName(), id);
        return this.getOrCreateProvider(key, () -> this.factory.getProviderFactory(clazz, id));
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId) {
        RealmModel realm = this.getContext().getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("Realm not set in the context.");
        }
        return this.getComponentProvider(clazz, componentId, KeycloakModelUtils.componentModelGetter((String)realm.getId(), (String)componentId));
    }

    public <T extends Provider> T getComponentProvider(Class<T> clazz, String componentId, Function<KeycloakSessionFactory, ComponentModel> modelGetter) {
        List<String> key = List.of("component", clazz.getName(), componentId);
        RealmModel realm = this.getContext().getRealm();
        return this.getOrCreateProvider(key, () -> this.factory.getProviderFactory(clazz, Optional.ofNullable(realm.getId()).orElse(null), componentId, modelGetter));
    }

    public <T extends Provider> T getProvider(Class<T> clazz, ComponentModel componentModel) {
        String modelId = componentModel.getId();
        Object found = this.getAttribute(modelId);
        if (found != null) {
            return (T)((Provider)clazz.cast(found));
        }
        ProviderFactory<T> providerFactory = this.factory.getProviderFactory(clazz, componentModel.getProviderId());
        if (providerFactory == null) {
            return null;
        }
        ComponentFactory componentFactory = (ComponentFactory)providerFactory;
        Provider provider = (Provider)componentFactory.create((KeycloakSession)this, componentModel);
        this.enlistForClose(provider);
        this.setAttribute(modelId, provider);
        return (T)provider;
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        return this.factory.getAllProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        return this.listProviderIds(clazz).stream().map(id -> this.getProvider(clazz, (String)id)).collect(Collectors.toSet());
    }

    public Class<? extends Provider> getProviderClass(String providerClassName) {
        return this.factory.getProviderClass(providerClassName);
    }

    public RealmProvider realms() {
        return this.getDatastoreProvider().realms();
    }

    public ClientProvider clients() {
        return this.getDatastoreProvider().clients();
    }

    public ClientScopeProvider clientScopes() {
        return this.getDatastoreProvider().clientScopes();
    }

    public GroupProvider groups() {
        return this.getDatastoreProvider().groups();
    }

    public RoleProvider roles() {
        return this.getDatastoreProvider().roles();
    }

    public UserSessionProvider sessions() {
        return this.getDatastoreProvider().userSessions();
    }

    public UserLoginFailureProvider loginFailures() {
        return this.getDatastoreProvider().loginFailures();
    }

    public AuthenticationSessionProvider authenticationSessions() {
        return this.getDatastoreProvider().authSessions();
    }

    public SingleUseObjectProvider singleUseObjects() {
        return this.getDatastoreProvider().singleUseObjects();
    }

    public IdentityProviderStorageProvider identityProviders() {
        return this.getDatastoreProvider().identityProviders();
    }

    public KeyManager keys() {
        if (this.keyManager == null) {
            this.keyManager = new DefaultKeyManager(this);
        }
        return this.keyManager;
    }

    public ThemeManager theme() {
        return this.getProvider(ThemeManager.class);
    }

    public TokenManager tokens() {
        if (this.tokenManager == null) {
            this.tokenManager = new DefaultTokenManager(this);
        }
        return this.tokenManager;
    }

    public VaultTranscriber vault() {
        if (this.vaultTranscriber == null) {
            this.vaultTranscriber = new DefaultVaultTranscriber(this.getProvider(VaultProvider.class));
        }
        return this.vaultTranscriber;
    }

    public ClientPolicyManager clientPolicy() {
        if (this.clientPolicyManager == null) {
            this.clientPolicyManager = this.getProvider(ClientPolicyManager.class);
        }
        return this.clientPolicyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Closing %s%s%s", (Object)this, this.getTransactionManager().isActive() ? " (transaction active" + (this.getTransactionManager().getRollbackOnly() ? ", ROLLBACK-ONLY" : "") + ")" : "", StackUtil.getShortStackTrace());
        }
        if (this.closed) {
            throw new IllegalStateException("Illegal call to #close() on already closed " + String.valueOf(this));
        }
        RuntimeException re = this.closeTransactionManager();
        try {
            Consumer<Provider> safeClose = p -> {
                try {
                    if (p != null) {
                        p.close();
                    }
                }
                catch (Exception e) {
                    LOG.warnf((Throwable)e, "Unable to close provider %s", (Object)p.getClass().getName());
                }
            };
            this.providers.values().forEach(safeClose);
            this.closable.forEach(safeClose);
            for (Map.Entry<InvalidationHandler.InvalidableObjectType, Set<Object>> me : this.invalidationMap.entrySet()) {
                this.factory.invalidate(this, me.getKey(), me.getValue().toArray());
            }
        }
        finally {
            this.closed = true;
        }
        if (re != null) {
            throw re;
        }
    }

    protected RuntimeException closeTransactionManager() {
        if (!this.transactionManager.isActive()) {
            return null;
        }
        try {
            if (this.transactionManager.getRollbackOnly()) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.commit();
            }
        }
        catch (RuntimeException re) {
            return re;
        }
        return null;
    }

    public String toString() {
        return String.format("session @ %08x", System.identityHashCode(this));
    }

    protected abstract DefaultKeycloakContext createKeycloakContext(KeycloakSession var1);

    public boolean isClosed() {
        return this.closed;
    }
}

