/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import org.hibernate.models.internal.PrimitiveKind;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.PrimitiveTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;

public record PrimitiveTypeDetailsImpl(ClassDetails classDetails) implements PrimitiveTypeDetails
{
    @Override
    public TypeDetails.Kind getTypeKind() {
        return TypeDetails.Kind.PRIMITIVE;
    }

    @Override
    public PrimitiveKind getPrimitiveKind() {
        return PrimitiveKind.resolveFromClassDetails(this.classDetails());
    }

    @Override
    public PrimitiveTypeDetails asPrimitiveType() {
        return this;
    }

    @Override
    public TypeDetails resolveTypeVariable(TypeVariableDetails typeVariable) {
        return this;
    }

    @Override
    public ClassDetails getClassDetails() {
        return this.classDetails();
    }

    @Override
    public char toCode() {
        Class javaClass = this.classDetails.toJavaClass();
        if (javaClass == Byte.TYPE) {
            return 'B';
        }
        if (javaClass == Character.TYPE) {
            return 'C';
        }
        if (javaClass == Double.TYPE) {
            return 'D';
        }
        if (javaClass == Float.TYPE) {
            return 'F';
        }
        if (javaClass == Integer.TYPE) {
            return 'I';
        }
        if (javaClass == Long.TYPE) {
            return 'J';
        }
        if (javaClass == Short.TYPE) {
            return 'S';
        }
        assert (javaClass == Boolean.TYPE);
        return 'Z';
    }
}

