/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.JWTClaimEnforcerExecutor;

public class JWTClaimEnforcerExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "jwt-claim-enforcer";
    public static final String CLAIM_NAME = "claim-name";
    public static final String ALLOWED_VALUE = "allowed-value";
    private static final ProviderConfigProperty CLAIM_NAME_PROPERTY = new ProviderConfigProperty("claim-name", "Claim Name", "The name of the JWT claim to enforce. This claim must be present in the token for validation.", "String", null);
    private static final ProviderConfigProperty ALLOWED_VALUE_PROPERTY = new ProviderConfigProperty("allowed-value", "Allowed Value", "Value that the JWT claim must match. Regular expressions are supported. If left empty, only the presence of the claim is enforced.", "String", null);

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new JWTClaimEnforcerExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The executor enforces the presence and specific values of a claim in a JWT.\nIt is applied in client requests where an existing JWT token is passed, such as a JWT Authorization Grant request (RFC 7523) or Standard Token Exchange request.\nThe configured claim must be present in the received JWT.\nIf allowed value is empty, only the presence of the claim is enforced.\nIf allowed value is set, the claim's value must match the configured regular expression.\nOnly claims of type string or number are allowed; multi-valued, arrays, maps, or other JSON objects are not supported.\n";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return List.of(CLAIM_NAME_PROPERTY, ALLOWED_VALUE_PROPERTY);
    }
}

