/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow.conditions;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserRoleMappingEntity;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.models.workflow.WorkflowConditionProvider;
import org.keycloak.models.workflow.WorkflowExecutionContext;
import org.keycloak.models.workflow.WorkflowInvalidStateException;
import org.keycloak.utils.StringUtil;

public class RoleWorkflowConditionProvider
implements WorkflowConditionProvider {
    private final String expectedRole;
    private final KeycloakSession session;

    public RoleWorkflowConditionProvider(KeycloakSession session, String expectedRole) {
        this.session = session;
        this.expectedRole = expectedRole;
    }

    public boolean evaluate(WorkflowExecutionContext context) {
        this.validate();
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = this.session.users().getUserById(realm, context.getResourceId());
        if (user == null) {
            return false;
        }
        Set roles = user.getRoleMappingsStream().collect(Collectors.toSet());
        RoleModel role = this.getRole(this.expectedRole, realm);
        return role != null && RoleUtils.hasRole(roles, (RoleModel)role);
    }

    public Predicate toPredicate(CriteriaBuilder cb, CriteriaQuery<String> query, Root<?> path) {
        this.validate();
        RoleModel role = this.getRole(this.expectedRole, this.session.getContext().getRealm());
        if (role == null) {
            return cb.disjunction();
        }
        Subquery subquery = query.subquery(Integer.class);
        Root from = subquery.from(UserRoleMappingEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)from.get("user").get("id"), (Expression)path.get("id")), (Expression)cb.equal((Expression)from.get("roleId"), (Object)role.getId())));
        return cb.exists(subquery);
    }

    public void validate() throws WorkflowInvalidStateException {
        if (StringUtil.isBlank((String)this.expectedRole)) {
            throw new WorkflowInvalidStateException("Expected role name not set.");
        }
        if (this.getRole(this.expectedRole, this.session.getContext().getRealm()) == null) {
            throw new WorkflowInvalidStateException(String.format("Role with name %s does not exist.", this.expectedRole));
        }
    }

    private RoleModel getRole(String expectedRole, RealmModel realm) {
        boolean isClientRole;
        boolean bl = isClientRole = expectedRole.indexOf(47) != -1;
        if (isClientRole) {
            String[] parts = expectedRole.split("/");
            if (parts.length != 2) {
                return null;
            }
            String clientId = parts[0];
            String roleName = parts[1];
            ClientModel client = this.session.clients().getClientByClientId(realm, clientId);
            if (client == null) {
                return null;
            }
            return client.getRole(roleName);
        }
        return realm.getRole(expectedRole);
    }

    public void close() {
    }
}

