/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.sstore;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ServiceHelper;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.sstore.impl.ClusteredSessionStoreImpl;
import io.vertx.ext.web.sstore.impl.LocalSessionStoreImpl;

@VertxGen
public interface SessionStore {
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public static SessionStore create(Vertx vertx) {
        return SessionStore.create(vertx, new JsonObject());
    }

    public static SessionStore create(Vertx vertx, JsonObject options) {
        SessionStore defaultStore;
        try {
            defaultStore = (SessionStore)ServiceHelper.loadFactoryOrNull(SessionStore.class);
            if (defaultStore != null) {
                return defaultStore.init(vertx, options);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        defaultStore = vertx.isClustered() ? new ClusteredSessionStoreImpl() : new LocalSessionStoreImpl();
        return defaultStore.init(vertx, options);
    }

    @Fluent
    public SessionStore init(Vertx var1, JsonObject var2);

    public long retryTimeout();

    public Session createSession(long var1);

    public Session createSession(long var1, int var3);

    @Fluent
    default public SessionStore get(String cookieValue, Handler<AsyncResult<@Nullable Session>> resultHandler) {
        this.get(cookieValue).onComplete(resultHandler);
        return this;
    }

    public Future<@Nullable Session> get(String var1);

    @Fluent
    default public SessionStore delete(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delete(id).onComplete(resultHandler);
        return this;
    }

    public Future<Void> delete(String var1);

    @Fluent
    default public SessionStore put(Session session, Handler<AsyncResult<Void>> resultHandler) {
        this.put(session).onComplete(resultHandler);
        return this;
    }

    public Future<Void> put(Session var1);

    @Fluent
    default public SessionStore clear(Handler<AsyncResult<Void>> resultHandler) {
        this.clear().onComplete(resultHandler);
        return this;
    }

    public Future<Void> clear();

    @Fluent
    default public SessionStore size(Handler<AsyncResult<Integer>> resultHandler) {
        this.size().onComplete(resultHandler);
        return this;
    }

    public Future<Integer> size();

    public void close();
}

