/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.execannotations;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsConfig;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.common.annotation.RunOnVirtualThread;
import io.smallrye.common.annotation.SuppressForbidden;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ExecutionModelAnnotationsProcessor {
    private static final Logger log = Logger.getLogger(ExecutionModelAnnotationsProcessor.class);
    private static final DotName BLOCKING = DotName.createSimple(Blocking.class);
    private static final DotName NON_BLOCKING = DotName.createSimple(NonBlocking.class);
    private static final DotName RUN_ON_VIRTUAL_THREAD = DotName.createSimple(RunOnVirtualThread.class);

    @BuildStep
    @Produce(value=GeneratedClassBuildItem.class)
    void check(ExecutionModelAnnotationsConfig config, CombinedIndexBuildItem index, List<ExecutionModelAnnotationsAllowedBuildItem> predicates) {
        if (config.detectionMode() == ExecutionModelAnnotationsConfig.Mode.DISABLED) {
            return;
        }
        StringBuilder message = new StringBuilder("\n");
        this.doCheck(message, index.getIndex(), predicates, BLOCKING);
        this.doCheck(message, index.getIndex(), predicates, NON_BLOCKING);
        this.doCheck(message, index.getIndex(), predicates, RUN_ON_VIRTUAL_THREAD);
        if (message.length() > 1) {
            message.append("The @Blocking, @NonBlocking and @RunOnVirtualThread annotations may only be used on \"entrypoint\" methods (methods invoked by various frameworks in Quarkus)\n");
            message.append("Using the @Blocking, @NonBlocking and @RunOnVirtualThread annotations on methods that can only be invoked by application code is invalid");
            if (config.detectionMode() == ExecutionModelAnnotationsConfig.Mode.WARN) {
                log.warn((Object)message);
            } else {
                throw new IllegalStateException(message.toString());
            }
        }
    }

    private void doCheck(StringBuilder message, IndexView index, List<ExecutionModelAnnotationsAllowedBuildItem> predicates, DotName annotationName) {
        ArrayList<String> badMethods = new ArrayList<String>();
        for (AnnotationInstance annotation : index.getAnnotations(annotationName)) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            MethodInfo method = annotation.target().asMethod();
            boolean allowed = false;
            for (ExecutionModelAnnotationsAllowedBuildItem predicate : predicates) {
                if (!predicate.matches(method)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            badMethods.add(this.methodToString(method));
        }
        if (!badMethods.isEmpty()) {
            message.append("Wrong usage(s) of @").append(annotationName.withoutPackagePrefix()).append(" found:\n");
            for (String method : badMethods) {
                message.append("\t- ").append(method).append("\n");
            }
        }
    }

    @Deprecated(since="3.22", forRemoval=true)
    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem devuiJsonRpcServices() {
        return new ExecutionModelAnnotationsAllowedBuildItem(new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                String clazz = method.declaringClass().name().toString().toLowerCase(Locale.ROOT);
                return clazz.startsWith("io.quarkus.") || clazz.startsWith("io.quarkiverse.") || clazz.endsWith("jsonrpcservice");
            }
        });
    }

    @SuppressForbidden(reason="Using Type.toString() to build an informative message")
    private String methodToString(MethodInfo method) {
        StringBuilder result = new StringBuilder();
        result.append(method.declaringClass().name()).append('.').append(method.name());
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Type parameter : method.parameterTypes()) {
            joiner.add(parameter.toString());
        }
        result.append(joiner);
        return result.toString();
    }
}

