/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.light.JavaIdentifier;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.ext.newify.NewifyMemberContributor;
import org.jetbrains.plugins.groovy.extensions.GroovyApplicabilityProvider;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.EmptyGroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.signatures.GrSignature;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTuple;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrPropertySelection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.signatures.GrClosureSignatureUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.CompileStaticUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyCommonClassNames;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyConstantExpressionEvaluator;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.util.SealedUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Applicability;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyConstructorResult;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCandidate;
import org.jetbrains.plugins.groovy.lang.resolve.ast.ConstructorAnnotationsProcessor;
import org.jetbrains.plugins.groovy.lang.resolve.impl.AccessibilityKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.NullArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.processors.MethodResolverProcessor;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;
import org.jetbrains.plugins.groovy.util.dynamicMembers.DynamicMemberUtils;

public final class PsiUtil {
    private static final Logger LOG = Logger.getInstance(PsiUtil.class);
    public static final Key<JavaIdentifier> NAME_IDENTIFIER = new Key("Java Identifier");
    @NonNls
    public static final Set<String> OPERATOR_METHOD_NAMES = Set.of("plus", "minus", "multiply", "power", "div", "mod", "or", "and", "xor", "next", "previous", "getAt", "putAt", "leftShift", "rightShift", "isCase", "bitwiseNegate", "negative", "positive", "call");
    private static final String[] visibilityModifiers = new String[]{"private", "protected", "public"};

    private PsiUtil() {
    }

    @Nullable
    public static String getMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    @Nullable
    public static String getUnqualifiedMethodName(GrMethodCall methodCall) {
        GrExpression invokedExpression = methodCall.getInvokedExpression();
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return null;
        }
        if (((GrReferenceExpression)invokedExpression).isQualified()) {
            return null;
        }
        return ((GrReferenceExpression)invokedExpression).getReferenceName();
    }

    public static boolean isLValue(GroovyPsiElement element) {
        if (element instanceof GrExpression) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{GrParenthesizedExpression.class});
            if (parent instanceof GrTuple) {
                return true;
            }
            return parent instanceof GrAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)((GrAssignmentExpression)parent).getLValue(), (PsiElement)element, (boolean)false);
        }
        return false;
    }

    public static boolean isApplicable(PsiType @Nullable [] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        return PsiUtil.isApplicableConcrete(argumentTypes, method, substitutor, place, eraseParameterTypes) != Applicability.inapplicable;
    }

    public static Applicability isApplicableConcrete(PsiType @Nullable [] argumentTypes, @NotNull PsiMethod method, PsiSubstitutor substitutor, PsiElement place, boolean eraseParameterTypes) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if (argumentTypes == null) {
            return Applicability.canBeApplicable;
        }
        GrSignature signature = GrClosureSignatureUtil.createSignature(method, substitutor, eraseParameterTypes, place);
        Applicability result2 = GroovyApplicabilityProvider.checkProviders(argumentTypes, method);
        if (result2 != null) {
            return result2;
        }
        result2 = GrClosureSignatureUtil.isSignatureApplicableConcrete(Collections.singletonList(signature), argumentTypes, place);
        if (result2 != Applicability.inapplicable && (eraseParameterTypes || GenericsUtil.isTypeArgumentsApplicable((PsiTypeParameter[])method.getTypeParameters(), (PsiSubstitutor)substitutor, (PsiElement)place))) {
            return result2;
        }
        return Applicability.inapplicable;
    }

    @Nullable
    public static GrArgumentList getArgumentsList(@Nullable PsiElement methodRef) {
        if (methodRef == null) {
            return null;
        }
        if (methodRef instanceof GrEnumConstant) {
            return ((GrEnumConstant)methodRef).getArgumentList();
        }
        PsiElement parent = methodRef.getParent();
        if (parent instanceof GrCall) {
            return ((GrCall)parent).getArgumentList();
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            return ((GrAnonymousClassDefinition)parent).getArgumentListGroovy();
        }
        return null;
    }

    public static PsiType @Nullable [] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom) {
        return PsiUtil.getArgumentTypes(place, nullAsBottom, null);
    }

    public static PsiType @Nullable [] getArgumentTypes(@Nullable PsiElement place, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        PsiElement parent;
        Object object = place instanceof GrEnumConstant ? place : (parent = place != null ? place.getParent() : null);
        if (parent instanceof GrIndexProperty) {
            GrIndexProperty index = (GrIndexProperty)parent;
            GrArgumentList list = index.getArgumentList();
            Object[] argTypes = PsiUtil.getArgumentTypes(list.getNamedArguments(), list.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            if (PsiUtil.isLValue(index) && argTypes != null) {
                PsiType rawInitializer = TypeInferenceHelper.getInitializerTypeFor(index);
                PsiType initializer = PsiUtil.notNullizeType(rawInitializer, nullAsBottom, index);
                return (PsiType[])ArrayUtil.append((Object[])argTypes, (Object)initializer);
            }
            return argTypes;
        }
        if (parent instanceof GrCall) {
            GrCall call = (GrCall)parent;
            GrNamedArgument[] namedArgs = call.getNamedArguments();
            GrExpression[] expressions = call.getExpressionArguments();
            GrClosableBlock[] closures = call.getClosureArguments();
            return PsiUtil.getArgumentTypes(namedArgs, expressions, closures, nullAsBottom, stopAt);
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            GrArgumentList argList = ((GrAnonymousClassDefinition)parent).getArgumentListGroovy();
            if (argList == null) {
                return PsiUtil.getArgumentTypes(GrNamedArgument.EMPTY_ARRAY, GrExpression.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
            }
            return PsiUtil.getArgumentTypes(argList.getNamedArguments(), argList.getExpressionArguments(), GrClosableBlock.EMPTY_ARRAY, nullAsBottom, stopAt);
        }
        if (parent instanceof GrBinaryExpression) {
            GrExpression right = ((GrBinaryExpression)parent).getRightOperand();
            PsiType type = right != null ? right.getType() : null;
            return new PsiType[]{PsiUtil.notNullizeType(type, nullAsBottom, parent)};
        }
        if (parent instanceof GrAssignmentExpression) {
            PsiType type = ((GrAssignmentExpression)parent).getType();
            return new PsiType[]{PsiUtil.notNullizeType(type, nullAsBottom, parent)};
        }
        return null;
    }

    @Contract(value="_, false, _ -> !null; !null, _, _ -> !null; null, true, _ -> null")
    private static PsiType notNullizeType(PsiType type, boolean acceptNull, PsiElement context) {
        return type != null || acceptNull ? type : TypesUtil.getJavaLangObject(context);
    }

    public static PsiType @Nullable [] getArgumentTypes(GrArgumentList argList) {
        return PsiUtil.getArgumentTypes(argList, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PsiType @Nullable [] getArgumentTypes(GrNamedArgument @NotNull [] namedArgs, GrExpression @NotNull [] expressions, GrClosableBlock @NotNull [] closures, boolean nullAsBottom, @Nullable GrExpression stopAt) {
        if (namedArgs == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        if (expressions == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        if (closures == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (namedArgs.length > 0) {
            GrNamedArgument context = namedArgs[0];
            result2.add((Object)GrMapType.createFromNamedArgs(context, namedArgs));
        }
        for (GrExpression grExpression : expressions) {
            PsiType type = grExpression.getType();
            if (grExpression instanceof GrSpreadArgument) {
                if (!(type instanceof GrTupleType)) return null;
                result2.addAll(((GrTupleType)type).getComponentTypes());
            } else if (type == null) {
                result2.add(nullAsBottom ? null : TypesUtil.getJavaLangObject(grExpression));
            } else {
                if (stopAt == grExpression) {
                    type = TypeConversionUtil.erasure((PsiType)type);
                }
                result2.add(type);
            }
            if (stopAt != grExpression) continue;
            return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        for (GrExpression grExpression : closures) {
            PsiType closureType = grExpression.getType();
            if (closureType != null) {
                if (stopAt == grExpression) {
                    closureType = TypeConversionUtil.erasure((PsiType)closureType);
                }
                result2.add(PsiUtil.notNullizeType(closureType, nullAsBottom, grExpression));
            }
            if (stopAt == grExpression) return result2.toArray(PsiType.createArray((int)result2.size()));
        }
        return result2.toArray(PsiType.createArray((int)result2.size()));
    }

    @Nullable
    public static PsiClass getJavaLangClass(PsiElement resolved, GlobalSearchScope scope) {
        return JavaPsiFacade.getInstance((Project)resolved.getProject()).findClass("java.lang.Class", scope);
    }

    public static boolean isValidReferenceName(@NotNull String text) {
        if (text == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start(text);
        return TokenSets.REFERENCE_NAMES_WITHOUT_NUMBERS.contains(lexer.getTokenType()) && lexer.getTokenEnd() == text.length();
    }

    public static boolean isAccessible(@NotNull PsiElement place, @NotNull PsiMember member) {
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(7);
        }
        if (DynamicMemberUtils.isDynamicElement((PsiElement)member)) {
            return true;
        }
        return AccessibilityKt.isAccessible(member, place);
    }

    public static void reformatCode(PsiElement element) {
        TextRange textRange = element.getTextRange();
        PsiFile file = element.getContainingFile();
        FileViewProvider viewProvider = file.getViewProvider();
        if (viewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            MultiplePsiFilesPerDocumentFileViewProvider multiProvider = (MultiplePsiFilesPerDocumentFileViewProvider)viewProvider;
            file = multiProvider.getPsi(multiProvider.getBaseLanguage());
            LOG.assertTrue(file != null, (Object)(String.valueOf(element) + " " + String.valueOf(multiProvider.getBaseLanguage())));
        }
        try {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatText(file, textRange.getStartOffset(), textRange.getEndOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static Iterable<PsiClass> iterateSupers(final @NotNull PsiClass psiClass, final boolean includeSelf) {
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(8);
        }
        return new Iterable<PsiClass>(){

            @Override
            public Iterator<PsiClass> iterator() {
                return new Iterator<PsiClass>(){
                    final IntArrayList indices = new IntArrayList();
                    final Stack<PsiClassType[]> superTypesStack = new Stack();
                    final Set<PsiClass> visited = new HashSet<PsiClass>();
                    PsiClass current;
                    boolean nextObtained;
                    {
                        if (includeSelf) {
                            this.current = psiClass;
                            this.nextObtained = true;
                        } else {
                            this.current = null;
                            this.nextObtained = false;
                        }
                        this.pushSuper(psiClass);
                    }

                    @Override
                    public boolean hasNext() {
                        this.nextElement();
                        return this.current != null;
                    }

                    private void nextElement() {
                        if (this.nextObtained) {
                            return;
                        }
                        this.nextObtained = true;
                        while (!this.superTypesStack.empty()) {
                            assert (!this.indices.isEmpty());
                            PsiClassType[] superTypes = (PsiClassType[])this.superTypesStack.peek();
                            for (int i2 = this.indices.popInt(); i2 < superTypes.length; ++i2) {
                                PsiClass clazz = superTypes[i2].resolve();
                                if (clazz == null || this.visited.contains(clazz)) continue;
                                this.current = clazz;
                                this.visited.add(clazz);
                                this.indices.push(i2 + 1);
                                this.pushSuper(clazz);
                                return;
                            }
                            this.superTypesStack.pop();
                        }
                        this.current = null;
                    }

                    private void pushSuper(PsiClass clazz) {
                        this.superTypesStack.push((Object)clazz.getSuperTypes());
                        this.indices.push(0);
                    }

                    @Override
                    @NotNull
                    public PsiClass next() {
                        this.nextElement();
                        this.nextObtained = false;
                        if (this.current == null) {
                            throw new NoSuchElementException();
                        }
                        PsiClass psiClass = this.current;
                        if (psiClass == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return psiClass;
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("should not be called");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil$1$1", "next"));
                    }
                };
            }
        };
    }

    @Nullable
    public static PsiClass getContextClass(@Nullable PsiElement element) {
        PsiElement context = element;
        while (context != null) {
            if (context instanceof GrAnonymousClassDefinition && PsiTreeUtil.isAncestor((PsiElement)((GrAnonymousClassDefinition)context).getArgumentListGroovy(), (PsiElement)element, (boolean)false)) {
                context = context.getContext();
                continue;
            }
            if (context instanceof PsiClass && !PsiUtil.isInDummyFile(context)) {
                return (PsiClass)context;
            }
            if (context instanceof GroovyFileBase && !PsiUtil.isInDummyFile(context)) {
                return ((GroovyFileBase)context).getScriptClass();
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean isInDummyFile(@NotNull PsiElement context) {
        PsiFile file;
        if (context == null) {
            PsiUtil.$$$reportNull$$$0(9);
        }
        if ((file = context.getContainingFile()) == null) {
            return false;
        }
        String name = file.getName();
        return name.startsWith("DUMMY__1234567890_DUMMYYYYYY___");
    }

    @Nullable
    public static GroovyPsiElement getFileOrClassContext(PsiElement context) {
        while (context != null) {
            if (context instanceof GrTypeDefinition) {
                return (GroovyPsiElement)context;
            }
            if (context instanceof GroovyFileBase && context.isPhysical()) {
                return (GroovyPsiElement)context;
            }
            context = context.getContext();
        }
        return null;
    }

    public static boolean mightBeLValue(@Nullable GrExpression expr) {
        if (expr instanceof GrParenthesizedExpression) {
            return PsiUtil.mightBeLValue(((GrParenthesizedExpression)expr).getOperand());
        }
        if (expr instanceof GrTuple || expr instanceof GrReferenceExpression || expr instanceof GrIndexProperty || expr instanceof GrPropertySelection) {
            return true;
        }
        return PsiUtil.isThisOrSuperRef(expr) && GroovyConfigUtils.getInstance().isVersionAtLeast(expr, "1.8");
    }

    public static boolean isRawMethodCall(GrMethodCallExpression call) {
        PsiType type;
        GrExpression expression;
        GroovyResolveResult result2 = call.advancedResolve();
        PsiElement element = result2.getElement();
        if (element == null) {
            return false;
        }
        if (element instanceof PsiMethod) {
            GroovyMethodCallReference reference;
            expression = call.getInvokedExpression();
            if (expression instanceof GrReferenceExpression && (reference = call.getImplicitCallReference()) != null) {
                PsiType receiverType;
                Argument receiver = reference.getReceiverArgument();
                PsiType psiType = receiverType = receiver == null ? null : receiver.getType();
                if (receiverType instanceof GroovyClosureType) {
                    return PsiUtil.isRawClosureCall(call, result2, (GroovyClosureType)receiverType);
                }
            }
            PsiType returnType = PsiUtil.getSmartReturnType((PsiMethod)element);
            if (expression instanceof GrReferenceExpression && result2.isInvokedOnProperty()) {
                if (returnType instanceof GroovyClosureType) {
                    return PsiUtil.isRawClosureCall(call, result2, (GroovyClosureType)returnType);
                }
            } else {
                return PsiUtil.isRawType(returnType, result2.getSubstitutor());
            }
        }
        if (element instanceof PsiVariable && (type = (expression = call.getInvokedExpression()).getType()) instanceof GroovyClosureType) {
            return PsiUtil.isRawClosureCall(call, result2, (GroovyClosureType)type);
        }
        return false;
    }

    private static boolean isRawClosureCall(GrMethodCallExpression call, GroovyResolveResult result2, GroovyClosureType closureType) {
        List<Argument> arguments2 = ArgumentsKt.getArguments(call);
        PsiType returnType = closureType.returnType(arguments2);
        return PsiUtil.isRawType(returnType, result2.getSubstitutor());
    }

    public static boolean isRawFieldAccess(GrReferenceExpression ref2) {
        PsiElement element = null;
        GroovyResolveResult[] resolveResults = ref2.multiResolve(false);
        if (resolveResults.length == 0) {
            return false;
        }
        GroovyResolveResult resolveResult = resolveResults[0];
        if (resolveResult != null) {
            element = resolveResult.getElement();
        }
        if (element instanceof PsiField) {
            return PsiUtil.isRawType(((PsiField)element).getType(), resolveResult.getSubstitutor());
        }
        if (element instanceof GrAccessorMethod) {
            return PsiUtil.isRawType(((GrAccessorMethod)element).getReturnType(), resolveResult.getSubstitutor());
        }
        return false;
    }

    private static boolean isRawIndexPropertyAccess(GrIndexProperty expr) {
        GrExpression qualifier = expr.getInvokedExpression();
        PsiType qualifierType = qualifier.getType();
        if (qualifierType instanceof PsiClassType) {
            PsiElement element;
            PsiClassType classType = (PsiClassType)qualifierType;
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.List")) {
                return com.intellij.psi.util.PsiUtil.extractIterableTypeParameter((PsiType)qualifierType, (boolean)false) == null;
            }
            if (InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Map")) {
                return com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)qualifierType, (String)"java.util.Map", (int)1, (boolean)false) == null;
            }
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            GrExpression[] arguments2 = expr.getArgumentList().getExpressionArguments();
            PsiType[] argTypes = PsiType.createArray((int)arguments2.length);
            for (int i2 = 0; i2 < arguments2.length; ++i2) {
                PsiType argType = arguments2[i2].getType();
                if (argType == null) {
                    argType = TypesUtil.getJavaLangObject(expr);
                }
                argTypes[i2] = argType;
            }
            MethodResolverProcessor processor = new MethodResolverProcessor("getAt", expr, false, qualifierType, argTypes, PsiType.EMPTY_ARRAY);
            PsiClass qClass = resolveResult.getElement();
            ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)PsiSubstitutor.EMPTY);
            if (qClass != null) {
                qClass.processDeclarations((PsiScopeProcessor)processor, state, null, (PsiElement)expr);
            }
            ResolveUtil.processNonCodeMembers(qualifierType, processor, qualifier, state);
            GroovyResolveResult[] candidates = processor.getCandidates();
            PsiType type = null;
            if (candidates.length == 1 && (element = candidates[0].getElement()) instanceof PsiMethod) {
                type = PsiUtil.getSmartReturnType((PsiMethod)element);
            }
            return PsiUtil.isRawType(type, resolveResult.getSubstitutor());
        }
        return false;
    }

    public static boolean isRawClassMemberAccess(GrExpression expr) {
        if ((expr = (GrExpression)PsiUtil.skipParentheses(expr, false)) instanceof GrMethodCallExpression) {
            return PsiUtil.isRawMethodCall((GrMethodCallExpression)expr);
        }
        if (expr instanceof GrReferenceExpression) {
            return PsiUtil.isRawFieldAccess((GrReferenceExpression)expr);
        }
        if (expr instanceof GrIndexProperty) {
            return PsiUtil.isRawIndexPropertyAccess((GrIndexProperty)expr);
        }
        return false;
    }

    public static boolean isRawType(@Nullable PsiType type, @NotNull PsiSubstitutor substitutor) {
        PsiClass returnClass;
        if (substitutor == null) {
            PsiUtil.$$$reportNull$$$0(10);
        }
        if (type instanceof PsiClassType && (returnClass = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)returnClass;
            return substitutor.substitute(typeParameter) == null;
        }
        return false;
    }

    public static boolean isWhiteSpaceOrLineFeed(PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        IElementType elementType = node.getElementType();
        return elementType == GroovyTokenTypes.mNLS || elementType == TokenType.WHITE_SPACE;
    }

    public static boolean isNewLine(PsiElement element) {
        return PsiUtil.isWhiteSpaceOrLineFeed(element) && element.getText().contains("\n");
    }

    @Nullable
    public static PsiElement getPrevNonSpace(@NotNull PsiElement elem) {
        if (elem == null) {
            PsiUtil.$$$reportNull$$$0(11);
        }
        return PsiUtilKt.skipWhiteSpacesAndNewLinesBackward(elem);
    }

    @Nullable
    public static PsiElement getNextNonSpace(@NotNull PsiElement elem) {
        if (elem == null) {
            PsiUtil.$$$reportNull$$$0(12);
        }
        return PsiUtilKt.skipWhiteSpacesAndNewLinesForward(elem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static PsiIdentifier getJavaNameIdentifier(@NotNull GrNamedElement namedElement) {
        PsiElement element;
        JavaIdentifier identifier;
        if (namedElement == null) {
            PsiUtil.$$$reportNull$$$0(13);
        }
        if ((identifier = (JavaIdentifier)(element = namedElement.getNameIdentifierGroovy()).getUserData(NAME_IDENTIFIER)) == null) {
            PsiElement psiElement = element;
            synchronized (psiElement) {
                identifier = (JavaIdentifier)element.getUserData(NAME_IDENTIFIER);
                if (identifier != null) {
                    JavaIdentifier javaIdentifier = identifier;
                    // MONITOREXIT @DISABLED, blocks:[2, 5, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (javaIdentifier == null) {
                        PsiUtil.$$$reportNull$$$0(14);
                    }
                    return javaIdentifier;
                }
                identifier = new JavaIdentifier(element.getManager(), element);
                element.putUserData(NAME_IDENTIFIER, (Object)identifier);
            }
        }
        JavaIdentifier javaIdentifier = identifier;
        if (javaIdentifier == null) {
            PsiUtil.$$$reportNull$$$0(15);
        }
        return javaIdentifier;
    }

    @Nullable
    public static GrStatement findEnclosingStatement(@Nullable PsiElement context) {
        while (context != null) {
            if (PsiUtil.isExpressionStatement(context)) {
                return (GrStatement)context;
            }
            context = PsiTreeUtil.getParentOfType((PsiElement)context, GrStatement.class, (boolean)true);
        }
        return null;
    }

    public static boolean isMethodCall(GrMethodCall call, String methodName) {
        GrExpression expression = call.getInvokedExpression();
        return expression instanceof GrReferenceExpression && methodName.equals(expression.getText().trim());
    }

    public static boolean hasEnclosingInstanceInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isSuperClassAccepted) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(16);
        }
        return PsiUtil.findEnclosingInstanceClassInScope(clazz, scope, isSuperClassAccepted) != null;
    }

    public static PsiClass findEnclosingInstanceClassInScope(@NotNull PsiClass clazz, @Nullable PsiElement scope, boolean isInheritorOfClazzAccepted) {
        PsiElement place;
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(17);
        }
        for (place = scope; !(place == null || place == clazz || place instanceof PsiFile && place.isPhysical()); place = place.getContext()) {
            if (place instanceof PsiClass && (isInheritorOfClazzAccepted ? InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)place), (PsiClass)clazz, (boolean)true) : clazz.getManager().areElementsEquivalent(place, (PsiElement)clazz))) {
                return (PsiClass)place;
            }
            if (!(place instanceof PsiModifierListOwner) || !((PsiModifierListOwner)place).hasModifierProperty("static")) continue;
            return null;
        }
        if (clazz instanceof GroovyScriptClass && place == clazz.getContainingFile() || place == clazz) {
            return clazz;
        }
        return null;
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward, boolean skipNLs) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, skipNLs);
    }

    @Nullable
    public static PsiElement skipWhitespacesAndComments(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_OR_COMMENTS, true);
    }

    @Nullable
    public static PsiElement skipSet(PsiElement elem, boolean forward, TokenSet set, boolean skipNLs) {
        while (elem != null && elem.getNode() != null && set.contains(elem.getNode().getElementType()) && (skipNLs || elem.getText().indexOf(10) == -1)) {
            if (forward) {
                elem = elem.getNextSibling();
                continue;
            }
            elem = elem.getPrevSibling();
        }
        return elem;
    }

    @Nullable
    public static PsiElement skipSet(@NotNull PsiElement element, boolean forward, @NotNull TokenSet set) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(18);
        }
        if (set == null) {
            PsiUtil.$$$reportNull$$$0(19);
        }
        while ((element = forward ? element.getNextSibling() : element.getPrevSibling()) != null && element.getNode() != null && set.contains(element.getNode().getElementType())) {
        }
        return element;
    }

    @Nullable
    public static PsiElement skipWhitespaces(@Nullable PsiElement elem, boolean forward) {
        return PsiUtil.skipSet(elem, forward, TokenSets.WHITE_SPACES_SET, true);
    }

    @Nullable
    public static PsiType getSmartReturnType(@NotNull PsiMethod method) {
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(20);
        }
        if (GdkMethodUtil.isMacro(method)) {
            return null;
        }
        if (method instanceof GrMethod) {
            return ((GrMethod)method).getInferredReturnType();
        }
        if (method instanceof GrAccessorMethod) {
            return ((GrAccessorMethod)method).getInferredReturnType();
        }
        if (method instanceof GrGdkMethod) {
            return PsiUtil.getSmartReturnType(((GrGdkMethod)method).getStaticMethod());
        }
        return method.getReturnType();
    }

    public static boolean isClosurePropertyGetter(PsiMethod method) {
        PsiType type;
        PsiModifierList modifiers;
        String methodName = method.getName();
        return methodName.startsWith("get") && GroovyPropertyUtils.isGetterName(methodName) && !(modifiers = method.getModifierList()).hasModifierProperty("static") && !modifiers.hasModifierProperty("private") && !modifiers.hasModifierProperty("protected") && method.getParameterList().isEmpty() && (type = PsiUtil.getSmartReturnType(method)) != null && TypesUtil.isClassType(type, "java.lang.Object", "groovy.lang.Closure");
    }

    public static boolean isMethodUsage(PsiElement element) {
        if (element instanceof GrEnumConstant) {
            return true;
        }
        if (!(element instanceof GrReferenceElement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof GrCall) {
            return true;
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            return element.equals(((GrAnonymousClassDefinition)parent).getBaseClassReferenceGroovy());
        }
        return false;
    }

    public static boolean isAccessedForReading(GrExpression expr) {
        return !PsiUtil.isLValue(expr);
    }

    public static boolean isAccessedForWriting(GrExpression expr) {
        return PsiUtil.isLValue(expr) || PsiUtil.isUsedInIncOrDec(expr);
    }

    public static boolean isUsedInIncOrDec(GrExpression expr) {
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)expr, (Class[])new Class[]{GrParenthesizedExpression.class});
        return PsiUtil.isPlusPlusOrMinusMinus(parent);
    }

    @Contract(value="null -> false")
    public static boolean isPlusPlusOrMinusMinus(@Nullable PsiElement parent) {
        if (parent instanceof GrUnaryExpression) {
            IElementType tokenType = ((GrUnaryExpression)parent).getOperationTokenType();
            return tokenType == GroovyTokenTypes.mINC || tokenType == GroovyTokenTypes.mDEC;
        }
        return false;
    }

    public static void qualifyMemberReference(@NotNull GrReferenceExpression refExpr, @NotNull PsiMember member, String name) {
        if (refExpr == null) {
            PsiUtil.$$$reportNull$$$0(21);
        }
        if (member == null) {
            PsiUtil.$$$reportNull$$$0(22);
        }
        assert (refExpr.getQualifierExpression() == null);
        PsiClass clazz = member.getContainingClass();
        assert (clazz != null);
        if (member.hasModifierProperty("static")) {
            GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getQualifiedName() + "." + name);
            refExpr.replace(newRefExpr);
        } else {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpr, PsiClass.class);
            if (member.getManager().areElementsEquivalent((PsiElement)containingClass, (PsiElement)clazz)) {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText("this." + name);
                refExpr.replace(newRefExpr);
            } else {
                GrReferenceExpression newRefExpr = GroovyPsiElementFactory.getInstance(member.getProject()).createReferenceExpressionFromText(clazz.getName() + ".this." + name);
                refExpr.replace(newRefExpr);
            }
        }
    }

    @Nullable
    public static PsiElement skipParentheses(@Nullable PsiElement element, boolean up) {
        if (element == null) {
            return null;
        }
        if (up) {
            PsiElement parent;
            while ((parent = element.getParent()) instanceof GrParenthesizedExpression) {
                element = parent;
            }
        } else {
            while (element instanceof GrParenthesizedExpression) {
                element = ((GrParenthesizedExpression)element).getOperand();
            }
        }
        return element;
    }

    @NotNull
    public static PsiElement skipParenthesesIfSensibly(@NotNull PsiElement element, boolean up) {
        PsiElement res;
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(23);
        }
        PsiElement psiElement = (res = PsiUtil.skipParentheses(element, up)) == null ? element : res;
        if (psiElement == null) {
            PsiUtil.$$$reportNull$$$0(24);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getNamedArgumentValue(GrNamedArgument otherNamedArgument, String argumentName) {
        PsiElement parent = otherNamedArgument.getParent();
        if (!(parent instanceof GrNamedArgumentsOwner)) {
            return null;
        }
        GrNamedArgument namedArgument = ((GrNamedArgumentsOwner)parent).findNamedArgument(argumentName);
        if (namedArgument == null) {
            return null;
        }
        return namedArgument.getExpression();
    }

    @NotNull
    public static PsiClass getOriginalClass(@NotNull PsiClass aClass) {
        PsiFile file;
        if (aClass == null) {
            PsiUtil.$$$reportNull$$$0(25);
        }
        if ((file = aClass.getContainingFile()) == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(26);
            }
            return psiClass;
        }
        PsiFile originalFile = file.getOriginalFile();
        if (originalFile == file) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(27);
            }
            return psiClass;
        }
        if (!(originalFile instanceof PsiClassOwner)) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(28);
            }
            return psiClass;
        }
        String name = aClass.getName();
        if (name == null) {
            PsiClass psiClass = aClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(29);
            }
            return psiClass;
        }
        for (PsiClass originalClass : ((PsiClassOwner)originalFile).getClasses()) {
            if (!name.equals(originalClass.getName())) continue;
            PsiClass psiClass = originalClass;
            if (psiClass == null) {
                PsiUtil.$$$reportNull$$$0(30);
            }
            return psiClass;
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            PsiUtil.$$$reportNull$$$0(31);
        }
        return psiClass;
    }

    public static void escalateVisibility(PsiMember owner, PsiElement place) {
        String modifier;
        int index;
        PsiModifierList modifierList = owner.getModifierList();
        LOG.assertTrue(modifierList != null);
        String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList);
        for (index = 0; index < visibilityModifiers.length && !(modifier = visibilityModifiers[index]).equals(visibilityModifier); ++index) {
        }
        while (index < visibilityModifiers.length && !PsiUtil.isAccessible(place, owner)) {
            modifier = visibilityModifiers[index];
            com.intellij.psi.util.PsiUtil.setModifierProperty((PsiModifierListOwner)owner, (String)modifier, (boolean)true);
            ++index;
        }
    }

    public static int getArgumentIndex(@NotNull GrCall call, @NotNull PsiElement argument) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(32);
        }
        if (argument == null) {
            PsiUtil.$$$reportNull$$$0(33);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return -1;
        }
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        for (int i2 = 0; i2 < expressionArguments.length; ++i2) {
            if (!argument.equals(expressionArguments[i2])) continue;
            int res = i2;
            if (argumentList.getNamedArguments().length > 0) {
                ++res;
            }
            return res;
        }
        if (argument instanceof GrClosableBlock) {
            GrClosableBlock[] closureArgs = call.getClosureArguments();
            for (int i3 = 0; i3 < closureArgs.length; ++i3) {
                if (!argument.equals(closureArgs[i3])) continue;
                int res = i3 + expressionArguments.length;
                if (argumentList.getNamedArguments().length > 0) {
                    ++res;
                }
                return res;
            }
        }
        return -1;
    }

    public static GrExpression[] getAllArguments(@NotNull GrCall call) {
        GrArgumentList argumentList;
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(34);
        }
        if ((argumentList = call.getArgumentList()) == null) {
            return GrExpression.EMPTY_ARRAY;
        }
        GrClosableBlock[] closureArguments = call.getClosureArguments();
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        GrNamedArgument[] namedArguments = argumentList.getNamedArguments();
        int length = expressionArguments.length + closureArguments.length;
        int k = 0;
        if (namedArguments.length > 0) {
            ++length;
            k = 1;
        }
        GrExpression[] res = new GrExpression[length];
        for (GrExpression grExpression : expressionArguments) {
            res[k++] = grExpression;
        }
        for (GrExpression grExpression : closureArguments) {
            res[k++] = grExpression;
        }
        return res;
    }

    public static GrNamedArgument[] getFirstMapNamedArguments(@NotNull GrCall grCall) {
        GrNamedArgument[] res;
        if (grCall == null) {
            PsiUtil.$$$reportNull$$$0(35);
        }
        if ((res = grCall.getNamedArguments()).length > 0) {
            return res;
        }
        GrExpression[] arguments2 = grCall.getExpressionArguments();
        if (arguments2.length == 0) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        GrExpression firstArg = arguments2[0];
        if (!(firstArg instanceof GrListOrMap)) {
            return GrNamedArgument.EMPTY_ARRAY;
        }
        return ((GrListOrMap)firstArg).getNamedArguments();
    }

    public static boolean isExpressionStatement(@Nullable PsiElement expr) {
        if (!(expr instanceof GrStatement)) {
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof GrControlFlowOwner || parent instanceof GrCaseSection) {
            return true;
        }
        if (parent instanceof GrLabeledStatement) {
            return true;
        }
        if (parent instanceof GrIfStatement && (expr == ((GrIfStatement)parent).getThenBranch() || expr == ((GrIfStatement)parent).getElseBranch())) {
            return true;
        }
        return parent instanceof GrWhileStatement && expr == ((GrWhileStatement)parent).getBody();
    }

    @Nullable
    public static GrMethodCall getMethodCallByNamedParameter(GrNamedArgument namedArgument) {
        GrCall res = PsiUtil.getCallByNamedParameter(namedArgument);
        if (res instanceof GrMethodCall) {
            return (GrMethodCall)res;
        }
        return null;
    }

    @Nullable
    public static GrCall getCallByNamedParameter(GrNamedArgument namedArgument) {
        PsiElement eMethodCall;
        PsiElement parent = namedArgument.getParent();
        if (parent instanceof GrArgumentList) {
            eMethodCall = parent.getParent();
        } else {
            if (!(parent instanceof GrListOrMap)) {
                return null;
            }
            PsiElement eArgumentList = parent.getParent();
            if (!(eArgumentList instanceof GrArgumentList)) {
                return null;
            }
            GrArgumentList argumentList = (GrArgumentList)eArgumentList;
            if (argumentList.getNamedArguments().length > 0) {
                return null;
            }
            if (argumentList.getExpressionArgumentIndex((GrListOrMap)parent) != 0) {
                return null;
            }
            eMethodCall = eArgumentList.getParent();
        }
        if (!(eMethodCall instanceof GrCall)) {
            return null;
        }
        return (GrCall)eMethodCall;
    }

    public static String getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, String defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(36);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof String) {
            return (String)o;
        }
        return defaultValue;
    }

    public static boolean getAnnoAttributeValue(@NotNull PsiAnnotation annotation, String attributeName, boolean defaultValue) {
        Object o;
        PsiAnnotationMemberValue value;
        if (annotation == null) {
            PsiUtil.$$$reportNull$$$0(37);
        }
        if ((value = annotation.findAttributeValue(attributeName)) instanceof GrExpression && (o = GroovyConstantExpressionEvaluator.evaluate((GrExpression)value)) instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    public static boolean isExpressionUsed(PsiElement expr) {
        while (expr.getParent() instanceof GrParenthesizedExpression) {
            expr = expr.getParent();
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof GrBinaryExpression || parent instanceof GrUnaryExpression || parent instanceof GrConditionalExpression || parent instanceof GrAssignmentExpression || parent instanceof GrInstanceOfExpression || parent instanceof GrSafeCastExpression || parent instanceof GrTuple || parent instanceof GrArgumentList || parent instanceof GrReturnStatement || parent instanceof GrAssertStatement || parent instanceof GrThrowStatement || parent instanceof GrSwitchStatement || parent instanceof GrVariable || parent instanceof GrWhileStatement) {
            return true;
        }
        if (parent instanceof GrReferenceExpression) {
            PsiElement resolved;
            if (ResolveUtil.isClassReference(parent)) {
                parent = parent.getParent();
            }
            if (parent instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)parent).resolve()) instanceof PsiMember) {
                PsiClass containingClass = ((PsiMember)resolved).getContainingClass();
                return containingClass != null && "java.lang.Class".equals(containingClass.getQualifiedName());
            }
            return true;
        }
        if (parent instanceof GrTraditionalForClause) {
            GrTraditionalForClause forClause = (GrTraditionalForClause)parent;
            return expr == forClause.getCondition();
        }
        return PsiUtil.isReturnStatement(expr);
    }

    public static boolean isReturnStatement(@NotNull PsiElement statement) {
        GrControlFlowOwner controlFlowOwner;
        if (statement == null) {
            PsiUtil.$$$reportNull$$$0(38);
        }
        if ((controlFlowOwner = ControlFlowUtils.findControlFlowOwner(statement)) instanceof GrOpenBlock) {
            PsiElement controlFlowOwnerParent = controlFlowOwner.getParent();
            if (controlFlowOwnerParent instanceof GrMethod && ((GrMethod)controlFlowOwnerParent).isConstructor()) {
                return false;
            }
            if (controlFlowOwnerParent instanceof PsiMethod && PsiTypes.voidType().equals((Object)((PsiMethod)controlFlowOwnerParent).getReturnType())) {
                return false;
            }
        }
        return ControlFlowUtils.collectReturns(controlFlowOwner, true).contains(statement);
    }

    @Nullable
    public static PsiClass getContainingNotInnerClass(@Nullable PsiElement element) {
        PsiClass domainClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (domainClass == null) {
            return null;
        }
        PsiClass c;
        while ((c = domainClass.getContainingClass()) != null) {
            domainClass = c;
        }
        return domainClass;
    }

    @NotNull
    public static ResolveResult getAccessObjectClass(GrExpression expression) {
        GroovyResolveResult resolveResult;
        if (PsiUtil.isThisOrSuperRef(expression)) {
            EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
            if (emptyGroovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(39);
            }
            return emptyGroovyResolveResult;
        }
        PsiType type = expression.getType();
        if (type instanceof PsiClassType) {
            PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
            if (classResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(40);
            }
            return classResolveResult;
        }
        if (type == null && expression instanceof GrReferenceExpression && (resolveResult = ((GrReferenceExpression)expression).advancedResolve()).getElement() instanceof PsiClass) {
            GroovyResolveResult groovyResolveResult = resolveResult;
            if (groovyResolveResult == null) {
                PsiUtil.$$$reportNull$$$0(41);
            }
            return groovyResolveResult;
        }
        EmptyGroovyResolveResult emptyGroovyResolveResult = EmptyGroovyResolveResult.INSTANCE;
        if (emptyGroovyResolveResult == null) {
            PsiUtil.$$$reportNull$$$0(42);
        }
        return emptyGroovyResolveResult;
    }

    public static boolean isReferenceWithoutQualifier(@Nullable PsiElement element, @NotNull String name) {
        if (name == null) {
            PsiUtil.$$$reportNull$$$0(43);
        }
        if (!(element instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref2 = (GrReferenceExpression)element;
        return !ref2.isQualified() && name.equals(ref2.getReferenceName());
    }

    public static boolean isProperty(@NotNull GrField field2) {
        PsiClass clazz;
        if (field2 == null) {
            PsiUtil.$$$reportNull$$$0(44);
        }
        if ((clazz = field2.getContainingClass()) == null) {
            return false;
        }
        if (clazz.isInterface() && !GrTraitUtil.isTrait(clazz)) {
            return false;
        }
        GrModifierList modifierList = field2.getModifierList();
        return modifierList == null || !modifierList.hasExplicitVisibilityModifiers();
    }

    public static boolean isConstructorHasRequiredParameters(@NotNull PsiMethod constructor) {
        PsiParameter[] parameters;
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(45);
        }
        LOG.assertTrue(constructor.isConstructor());
        for (PsiParameter parameter : parameters = constructor.getParameterList().getParameters()) {
            if (parameter instanceof GrParameter && ((GrParameter)parameter).isOptional()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInMethodCallContext(PsiElement context) {
        return PsiUtil.getArgumentsList(context) != null;
    }

    @NotNull
    public static List<GrImportStatement> getValidImportStatements(GroovyFile file) {
        ArrayList<GrImportStatement> oldImports = new ArrayList<GrImportStatement>();
        for (GrImportStatement statement : file.getImportStatements()) {
            if (ErrorUtil.containsError(statement)) continue;
            oldImports.add(statement);
        }
        ArrayList<GrImportStatement> arrayList = oldImports;
        if (arrayList == null) {
            PsiUtil.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    public static boolean isInStaticCompilationContext(@NotNull GrReferenceExpression expression) {
        if (expression == null) {
            PsiUtil.$$$reportNull$$$0(47);
        }
        return CompileStaticUtil.isCompileStatic(expression) || GrStaticChecker.isPropertyAccessInStaticMethod(expression);
    }

    public static boolean isNewified(@Nullable PsiElement expr) {
        if (!(expr instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression refExpr = (GrReferenceExpression)expr;
        if (!expr.isValid()) {
            return false;
        }
        if (refExpr.isQualified()) {
            return false;
        }
        String referenceName = refExpr.getReferenceName();
        if (referenceName == null) {
            return false;
        }
        List<PsiAnnotation> newifyAnnotations = NewifyMemberContributor.getNewifyAnnotations(expr);
        for (PsiAnnotation anno : newifyAnnotations) {
            if (NewifyMemberContributor.matchesPattern(referenceName, anno)) {
                return true;
            }
            List<PsiClass> selectedClasses = GrAnnotationUtil.getClassArrayValue(anno, "value", true);
            if (!selectedClasses.stream().anyMatch(clazz -> referenceName.equals(clazz.getName()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isTrustedMapConstructorResult(@NotNull GroovyResolveResult result2) {
        if (result2 == null) {
            PsiUtil.$$$reportNull$$$0(48);
        }
        if (result2 instanceof GroovyConstructorResult && ((GroovyConstructorResult)result2).isMapConstructor()) {
            return true;
        }
        if (!(result2 instanceof GroovyConstructorResult) && result2.getElement() instanceof PsiMethod && !((PsiMethod)result2.getElement()).hasParameters()) {
            return true;
        }
        PsiElement method = result2.getElement();
        if (method instanceof PsiMethod) {
            PsiParameter[] parameters = ((PsiMethod)method).getParameterList().getParameters();
            PsiClass containingClass = ((PsiMethod)method).getContainingClass();
            if (containingClass == null) {
                return false;
            }
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
            if (parameters.length <= 2 && containingClass.hasAnnotation("groovy.transform.MapConstructor")) {
                if (parameters.length == 2 && !(parameters[0] instanceof ConstructorAnnotationsProcessor.EnclosingClassParameter)) {
                    return false;
                }
                PsiType lastParameterType = parameters[parameters.length - 1].getType();
                return TypesUtil.isAssignableByMethodCallConversion(lastParameterType, (PsiType)factory.createTypeByFQClassName("java.util.Map"), method);
            }
        }
        return false;
    }

    @NotNull
    public static @Unmodifiable @NotNull List<@NotNull PsiAnnotation> getAllAnnotations(@NotNull PsiElement element, @NotNull String annotationNameFq) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(49);
        }
        if (annotationNameFq == null) {
            PsiUtil.$$$reportNull$$$0(50);
        }
        List parents = PsiTreeUtil.collectParents((PsiElement)element, PsiModifierListOwner.class, (boolean)true, __ -> false);
        SmartList annotations = new SmartList();
        for (PsiModifierListOwner parent : parents) {
            PsiAnnotation annotation = parent.getAnnotation(annotationNameFq);
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        SmartList smartList = annotations;
        if (smartList == null) {
            PsiUtil.$$$reportNull$$$0(51);
        }
        return smartList;
    }

    @Nullable
    public static PsiType extractIteratedType(GrForInClause forIn) {
        GrExpression iterated = forIn.getIteratedExpression();
        if (iterated == null) {
            return null;
        }
        return ClosureParameterEnhancer.findTypeForIteration(iterated, (PsiElement)forIn);
    }

    public static boolean isThisReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kTHIS, false);
    }

    public static boolean isSuperReference(@Nullable PsiElement expression) {
        return PsiUtil.isThisOrSuperRef(expression, GroovyTokenTypes.kSUPER, true);
    }

    private static boolean isThisOrSuperRef(PsiElement expression, IElementType token, boolean superClassAccepted) {
        if (!(expression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression ref2 = (GrReferenceExpression)expression;
        PsiElement nameElement = ref2.getReferenceNameElement();
        if (nameElement == null) {
            return false;
        }
        IElementType type = nameElement.getNode().getElementType();
        if (type != token) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement resolved = ref2.resolve();
        if (resolved instanceof PsiClass) {
            if (PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref2, superClassAccepted)) {
                return true;
            }
            if (superClassAccepted && GrTraitUtil.isTrait((PsiClass)resolved) && PsiUtil.scopeClassImplementsTrait((PsiClass)resolved, ref2)) {
                return true;
            }
        }
        return false;
    }

    public static boolean scopeClassImplementsTrait(@NotNull PsiClass trait, @NotNull PsiElement place) {
        GrTypeDefinition scopeClass;
        if (trait == null) {
            PsiUtil.$$$reportNull$$$0(52);
        }
        if (place == null) {
            PsiUtil.$$$reportNull$$$0(53);
        }
        return (scopeClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)place, GrTypeDefinition.class, (boolean)true)) != null && ContainerUtil.find((Object[])scopeClass.getSuperTypes(), type -> place.getManager().areElementsEquivalent((PsiElement)type.resolve(), (PsiElement)trait)) != null;
    }

    public static boolean isThisOrSuperRef(@Nullable PsiElement qualifier) {
        return qualifier instanceof GrReferenceExpression && (PsiUtil.isThisReference(qualifier) || PsiUtil.isSuperReference(qualifier));
    }

    public static boolean isInstanceThisRef(PsiElement qualifier) {
        if (PsiUtil.isThisReference(qualifier)) {
            GrReferenceExpression ref2 = (GrReferenceExpression)qualifier;
            PsiElement resolved = ref2.resolve();
            if (!(resolved instanceof PsiClass)) {
                return false;
            }
            return PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, qualifier, false);
        }
        return false;
    }

    public static boolean isLineFeed(@Nullable PsiElement e) {
        return e != null && PsiImplUtil.isWhiteSpaceOrNls(e) && (e.getText().indexOf(10) >= 0 || e.getText().indexOf(13) >= 0);
    }

    public static boolean isSingleBindingVariant(GroovyResolveResult[] candidates) {
        return candidates.length == 1 && candidates[0].getElement() instanceof GrBindingVariable;
    }

    @Nullable
    public static GrConstructorInvocation getConstructorInvocation(@NotNull GrMethod constructor) {
        if (constructor == null) {
            PsiUtil.$$$reportNull$$$0(54);
        }
        assert (constructor.isConstructor());
        GrOpenBlock body = constructor.getBlock();
        if (body == null) {
            return null;
        }
        GrStatement[] statements = body.getStatements();
        if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
            return (GrConstructorInvocation)statements[0];
        }
        return null;
    }

    public static boolean isDGMMethod(@Nullable PsiElement element) {
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = element instanceof GrGdkMethod ? ((GrGdkMethod)element).getStaticMethod() : (PsiMethod)element;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        return GroovyCommonClassNames.DEFAULT_INSTANCE_EXTENSIONS.contains(qname) || GroovyCommonClassNames.DEFAULT_STATIC_EXTENSIONS.contains(qname);
    }

    public static boolean isVoidMethodCall(@Nullable GrExpression expression) {
        if (!(expression instanceof GrMethodCall)) {
            return false;
        }
        PsiElement element = ((GrMethodCall)expression).advancedResolve().getElement();
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        return PsiTypes.voidType().equals((Object)((PsiMethod)element).getReturnType());
    }

    public static boolean isVoidMethod(@NotNull PsiMethod method) {
        GrOpenBlock block;
        if (method == null) {
            PsiUtil.$$$reportNull$$$0(55);
        }
        if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
            return true;
        }
        return method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null && (block = ((GrMethod)method).getBlock()) != null && PsiUtil.isBlockReturnVoid(block);
    }

    public static boolean isBlockReturnVoid(@NotNull GrCodeBlock block) {
        if (block == null) {
            PsiUtil.$$$reportNull$$$0(56);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)block, () -> CachedValueProvider.Result.create((Object)ControlFlowUtils.visitAllExitPoints(block, new ControlFlowUtils.ExitPointVisitor(){

            @Override
            public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                return !(returnValue instanceof GrLiteral);
            }
        }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static boolean checkPsiElementsAreEqual(PsiElement l, PsiElement r) {
        PsiElement[] rChildren;
        if (!l.getText().equals(r.getText())) {
            return false;
        }
        if (l.getNode().getElementType() != r.getNode().getElementType()) {
            return false;
        }
        PsiElement[] lChildren = l.getChildren();
        if (lChildren.length != (rChildren = r.getChildren()).length) {
            return false;
        }
        for (int i2 = 0; i2 < rChildren.length; ++i2) {
            if (PsiUtil.checkPsiElementsAreEqual(lChildren[i2], rChildren[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCall(GrReferenceExpression referenceExpression) {
        return referenceExpression.getParent() instanceof GrCall;
    }

    public static boolean isLocalVariable(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField) && !(variable instanceof GrParameter);
    }

    public static boolean isLocalOrParameter(@Nullable PsiElement variable) {
        return variable instanceof GrVariable && !(variable instanceof GrField);
    }

    @Nullable
    public static PsiElement getPreviousNonWhitespaceToken(PsiElement e) {
        PsiElement next = PsiTreeUtil.prevLeaf((PsiElement)e);
        while (next != null && next.getNode().getElementType() == TokenType.WHITE_SPACE) {
            next = PsiTreeUtil.prevLeaf((PsiElement)next);
        }
        return next;
    }

    @Nullable
    public static Object getLabelValue(@Nullable GrArgumentLabel label) {
        Object value;
        if (label == null) {
            return null;
        }
        PsiElement element = label.getNameElement();
        if (element instanceof GrExpression && (value = JavaPsiFacade.getInstance((Project)label.getProject()).getConstantEvaluationHelper().computeConstantExpression(element)) != null) {
            return value;
        }
        IElementType elemType = element.getNode().getElementType();
        if (GroovyTokenTypes.mIDENT == elemType || TokenSets.KEYWORDS.contains(elemType)) {
            return element.getText();
        }
        return GrLiteralImpl.getLiteralValue(element);
    }

    public static boolean isEligibleForInvocationWithNull(@NotNull GrCall call) {
        if (call == null) {
            PsiUtil.$$$reportNull$$$0(57);
        }
        if (CompileStaticUtil.isCompileStatic(call) || call.hasClosureArguments()) {
            return false;
        }
        GrArgumentList argumentList = call.getArgumentList();
        if (argumentList == null || !argumentList.isEmpty()) {
            return false;
        }
        GroovyResolveResult result2 = call.advancedResolve();
        if (!(result2 instanceof GroovyMethodResult)) {
            return false;
        }
        GroovyMethodCandidate candidate = ((GroovyMethodResult)result2).getCandidate();
        if (candidate == null) {
            return false;
        }
        return candidate.getArgumentMapping() instanceof NullArgumentMapping;
    }

    public static @Nullable Pair<@NotNull PsiType, @NotNull Integer> getComponentForSpreadWithDot(@NotNull PsiType type) {
        PsiType componentType;
        if (type == null) {
            PsiUtil.$$$reportNull$$$0(58);
        }
        if ((componentType = InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") ? com.intellij.psi.util.PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false) : (type instanceof PsiArrayType ? ((PsiArrayType)type).getComponentType() : null)) == null) {
            return null;
        }
        Pair<PsiType, Integer> nested = PsiUtil.getComponentForSpreadWithDot(componentType);
        return nested == null ? Pair.create((Object)componentType, (Object)1) : Pair.create((Object)((PsiType)nested.first), (Object)((Integer)nested.second + 1));
    }

    public static @NotNull List<@Nullable GrExpression> getAllPatternsForCaseSection(@NotNull GrCaseSection section) {
        PsiElement parent;
        if (section == null) {
            PsiUtil.$$$reportNull$$$0(59);
        }
        if (!((parent = section.getParent()) instanceof GrSwitchElement)) {
            List<GrExpression> list = Collections.emptyList();
            if (list == null) {
                PsiUtil.$$$reportNull$$$0(60);
            }
            return list;
        }
        if (section.getArrow() != null) {
            List<GrExpression> list = Arrays.asList(section.getExpressions());
            if (list == null) {
                PsiUtil.$$$reportNull$$$0(61);
            }
            return list;
        }
        Object[] allSections = ((GrSwitchElement)parent).getCaseSections();
        int indexOfCaseSection = ArrayUtil.indexOf((Object[])allSections, (Object)section);
        SmartList patterns = new SmartList((Object[])section.getExpressions());
        if (indexOfCaseSection < 0) {
            SmartList smartList = patterns;
            if (smartList == null) {
                PsiUtil.$$$reportNull$$$0(62);
            }
            return smartList;
        }
        --indexOfCaseSection;
        while (indexOfCaseSection >= 0 && allSections[indexOfCaseSection].getStatements().length == 0) {
            patterns.addAll(Arrays.asList(allSections[indexOfCaseSection].getExpressions()));
            --indexOfCaseSection;
        }
        SmartList smartList = patterns;
        if (smartList == null) {
            PsiUtil.$$$reportNull$$$0(63);
        }
        return smartList;
    }

    public static boolean isPlainSwitchStatement(@NotNull GrSwitchElement switchElement) {
        if (switchElement == null) {
            PsiUtil.$$$reportNull$$$0(64);
        }
        if (!(switchElement instanceof GrSwitchStatement)) {
            return false;
        }
        Object[] sections = switchElement.getCaseSections();
        return ContainerUtil.and((Object[])sections, elem -> elem.getColon() != null);
    }

    @NotNull
    public static @NotNull List<@NotNull PsiClass> getAllPermittedClassesJvmAware(@NotNull PsiClass clazz) {
        if (clazz == null) {
            PsiUtil.$$$reportNull$$$0(65);
        }
        if (clazz instanceof GrTypeDefinition) {
            List<PsiClass> list = SealedUtil.getAllPermittedClasses((GrTypeDefinition)clazz);
            if (list == null) {
                PsiUtil.$$$reportNull$$$0(66);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])clazz.getPermitsListTypes(), PsiClassType::resolve);
        if (list == null) {
            PsiUtil.$$$reportNull$$$0(67);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 24, 26, 27, 28, 29, 30, 31, 39, 40, 41, 42, 46, 51, 60, 61, 62, 63, 66, 67 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closures";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 16: 
            case 17: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 18: 
            case 23: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 32: 
            case 34: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grCall";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNameFq";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/util/PsiUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaNameIdentifier";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "skipParenthesesIfSensibly";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalClass";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessObjectClass";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidImportStatements";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPatternsForCaseSection";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPermittedClassesJvmAware";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableConcrete";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidReferenceName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateSupers";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInDummyFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isRawType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonSpace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonSpace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJavaNameIdentifier";
                break;
            }
            case 14: 
            case 15: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 66: 
            case 67: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasEnclosingInstanceInScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingInstanceClassInScope";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "skipSet";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSmartReturnType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "qualifyMemberReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "skipParenthesesIfSensibly";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalClass";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentIndex";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAllArguments";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMapNamedArguments";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoAttributeValue";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isReturnStatement";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceWithoutQualifier";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isProperty";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isConstructorHasRequiredParameters";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isInStaticCompilationContext";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isTrustedMapConstructorResult";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "scopeClassImplementsTrait";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorInvocation";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isVoidMethod";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isBlockReturnVoid";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isEligibleForInvocationWithNull";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getComponentForSpreadWithDot";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternsForCaseSection";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isPlainSwitchStatement";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getAllPermittedClassesJvmAware";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 24, 26, 27, 28, 29, 30, 31, 39, 40, 41, 42, 46, 51, 60, 61, 62, 63, 66, 67 -> new IllegalStateException(string);
        };
    }
}

