import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import 'react';
import { toOption } from '@grafana/data';
import { AutoSizeInput, Checkbox, useStyles2, Button, Select } from '@grafana/ui';
import '../../QueryEditor/types.js';
import 'lodash';
import '../../QueryEditor/EditorList.js';
import { EditorStack } from '../../QueryEditor/EditorStack.js';
import '../../QueryEditor/Space.js';
import 'react-use';
import '../../QueryEditor/QueryHeader.js';
import 'react-virtualized-auto-sizer';
import 'sql-formatter-plus';
import '../../SQLEditor/standardSql/language.js';
import 'uuid';
import '@grafana/runtime';
import '../../SQLEditor/utils/debugger.js';
import '../../SQLEditor/standardSql/macros.js';
import '../../QueryEditor/visual-query-builder/AwesomeQueryBuilder.js';
import '../../QueryEditor/visual-query-builder/WhereRow.js';
import '../../QueryEditor/visual-query-builder/EditorField.js';
import 'rxjs';
import 'rxjs/operators';

function getOperationParamEditor(paramDef) {
  if (paramDef.editor) {
    return paramDef.editor;
  }
  if (paramDef.options) {
    return SelectInputParamEditor;
  }
  switch (paramDef.type) {
    case "boolean":
      return BoolInputParamEditor;
    case "number":
    case "string":
    default:
      return SimpleInputParamEditor;
  }
}
function SimpleInputParamEditor(props) {
  var _a;
  return /* @__PURE__ */ jsx(
    AutoSizeInput,
    {
      id: getOperationParamId(props.operationId, props.index),
      defaultValue: (_a = props.value) == null ? undefined : _a.toString(),
      minWidth: props.paramDef.minWidth,
      placeholder: props.paramDef.placeholder,
      title: props.paramDef.description,
      maxWidth: (props.paramDef.minWidth || 20) * 3,
      onCommitChange: (evt) => {
        props.onChange(props.index, evt.currentTarget.value);
        if (props.paramDef.runQueryOnEnter && evt.type === "keydown") {
          props.onRunQuery();
        }
      }
    }
  );
}
function BoolInputParamEditor(props) {
  return /* @__PURE__ */ jsx(
    Checkbox,
    {
      id: getOperationParamId(props.operationId, props.index),
      value: Boolean(props.value),
      onChange: (evt) => props.onChange(props.index, evt.currentTarget.checked)
    }
  );
}
function SelectInputParamEditor({
  paramDef,
  value,
  index,
  operationId,
  onChange
}) {
  var _a, _b;
  const styles = useStyles2(getStyles);
  let selectOptions = paramDef.options;
  if (!((_a = selectOptions[0]) == null ? undefined : _a.label)) {
    selectOptions = paramDef.options.map((option) => ({
      label: option.toString(),
      value: option
    }));
  }
  let valueOption = (_b = selectOptions.find((x) => x.value === value)) != null ? _b : toOption(value);
  if (!value && paramDef.optional) {
    return /* @__PURE__ */ jsx("div", { className: styles.optionalParam, children: /* @__PURE__ */ jsx(
      Button,
      {
        size: "sm",
        variant: "secondary",
        title: `Add ${paramDef.name}`,
        icon: "plus",
        onClick: () => onChange(index, selectOptions[0].value),
        children: paramDef.name
      }
    ) });
  }
  return /* @__PURE__ */ jsxs(EditorStack, { gap: 0.5, direction: "row", alignItems: "center", children: [
    /* @__PURE__ */ jsx(
      Select,
      {
        id: getOperationParamId(operationId, index),
        value: valueOption,
        options: selectOptions,
        placeholder: paramDef.placeholder,
        allowCustomValue: true,
        onChange: (value2) => onChange(index, value2.value),
        width: paramDef.minWidth || "auto"
      }
    ),
    paramDef.optional && /* @__PURE__ */ jsx(
      Button,
      {
        "data-testid": `operations.${index}.remove-param`,
        size: "sm",
        fill: "text",
        icon: "times",
        variant: "secondary",
        title: `Remove ${paramDef.name}`,
        onClick: () => onChange(index, "")
      }
    )
  ] });
}
const getStyles = (theme) => {
  return {
    optionalParam: css({
      marginTop: theme.spacing(1)
    })
  };
};
function getOperationParamId(operationId, paramIndex) {
  return `operations.${operationId}.param.${paramIndex}`;
}

export { getOperationParamEditor, getOperationParamId };
//# sourceMappingURL=OperationParamEditor.js.map
