---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: 単一の集中管理された場所から、GitLabインスタンス全体のコンプライアンスフレームワークを管理する方法について説明します。
title: 一元化されたコンプライアンスフレームワーク
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- GitLab 18.3で[導入](https://gitlab.com/groups/gitlab-org/-/epics/15864)されました。`security_policies_csp`および`include_csp_frameworks`という名前の[機能フラグ](../../../administration/feature_flags/_index.md)を使用します。デフォルトでは有効になっています。
- 機能フラグ`security_policies_csp`は、GitLab 18.5で[削除](https://gitlab.com/groups/gitlab-org/-/epics/17392)されました。
- [一般提供](https://gitlab.com/groups/gitlab-org/-/epics/15864)はGitLab 18.6で一般提供となりました。機能フラグ`include_csp_frameworks`は削除されました。

{{< /history >}}

一元化されたセキュリティコンプライアンスフレームワーク管理により、GitLab管理者は、GitLabインスタンス内のすべてのグループとプロジェクトにわたって、コンプライアンス要件を一元的に管理および適用できます。

コンプライアンスとセキュリティポリシー（CSP）グループを指定することにより、すべてのトップレベルグループで自動的に利用できるコンプライアンスフレームワークを作成できます。

コンプライアンスとセキュリティポリシーグループを指定する場合:

- コンプライアンスとセキュリティポリシーグループで作成されたすべてのコンプライアンスフレームワークは、インスタンス内のすべてのトップレベルグループで利用可能になります。
- グループオーナーは、これらの集中管理されたフレームワークを自分のプロジェクトに割り当てることができます。
- これらのフレームワークは、グループ固有のフレームワークとともに表示され、コンプライアンスとセキュリティポリシーグループからのものであることを示す明確な指標が表示されます。
- コンプライアンスとセキュリティポリシーのフレームワークは、コンプライアンス標準の一貫した適用を保証するために、コンプライアンスとセキュリティポリシーグループのメンバー以外のユーザーに対して読み取り専用です。

フレームワークの表示レベルとアクセス許可:

- すべてのユーザーは、自分がアクセスできるプロジェクトにどのフレームワークが適用されているかを確認できます。
- グループメンバーは、自分のグループで利用可能なすべてのコンプライアンスとセキュリティポリシーフレームワークを表示できます。
- コンプライアンスセンターには、コンプライアンスとセキュリティポリシーグループのフレームワークとグループ固有のフレームワークの両方が表示されます。

## 前提要件 {#prerequisites}

- 管理者である必要があります。
- コンプライアンスとセキュリティポリシーグループとして機能する既存のトップレベルグループ。
- REST API（オプション）を使用するには、管理者アクセス権を持つトークンが必要です。

## はじめる前 {#before-you-begin}

開始する前に、コンプライアンスフレームワークを管理するための一元的な場所として機能するように、トップレベルグループをコンプライアンスおよびセキュリティポリシーグループとして指定します。

詳細な手順については、[コンプライアンスとセキュリティポリシーグループの指定](../../../security/compliance_security_policy_management.md#designate-a-compliance-and-security-policy-group)を参照してください。

## コンプライアンスとセキュリティポリシーグループでコンプライアンスフレームワークを作成する {#create-compliance-frameworks-in-the-compliance-and-security-policy-group}

コンプライアンスとセキュリティポリシーグループを指定したら、コンプライアンスフレームワークを作成します:

1. 指定されたコンプライアンスおよびセキュリティポリシーグループに移動します。
1. **セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**フレームワーク**タブを選択します。
1. **新規フレームワーク**を選択します。
1. フレームワークの詳細を入力します:
   - **名前**: フレームワークのわかりやすい名前。
   - **説明**: フレームワークの目的と要件について説明します。
   - **色**: 視覚的な識別のために色を選択します。
   - **要求**: 特定のコントロールと要件を追加します。
1. **変更を保存**を選択します。

フレームワークは、インスタンス内のすべてのトップレベルグループで利用できるようになりました。

## フレームワークの要件を設定する（オプション） {#configure-framework-requirements-optional}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

各コンプライアンスフレームワークの特定の要件とコントロールを定義できます:

1. コンプライアンスとセキュリティポリシーグループでフレームワークを作成または編集するときは、**要求**セクションに移動します。
1. **新しい要件**を選択します。
1. 1つ以上のコントロールを追加します:
   - **GitLab controls**（GitLabコントロール）: GitLabの機能と設定に対する事前定義済みのチェック。
   - **External controls**（外部コントロール）: サードパーティのコンプライアンスツールとのインテグレーション。
1. **フレームワークへの変更を保存**を選択します。

利用可能なコントロールの詳細については、[GitLabコンプライアンスコントロール](_index.md#gitlab-compliance-controls) 、および[サポートされているコンプライアンス標準](compliance_standards.md)の詳細を参照してください。

## コンプライアンスとセキュリティポリシーフレームワークをプロジェクトに適用する {#apply-compliance-and-security-policy-frameworks-to-projects}

コンプライアンスとセキュリティポリシーフレームワークは、グループオーナーまたはプロジェクトオーナーとしてプロジェクトに適用します。

### グループオーナーとして {#as-a-group-owner}

グループオーナーは、コンプライアンスとセキュリティポリシーフレームワークを表示して、自分のプロジェクトに適用できます。コンプライアンスとセキュリティポリシーフレームワークはグループでは読み取り専用であり、グループから編集または削除することはできません。

コンプライアンスとセキュリティポリシーフレームワークをグループ内のプロジェクトに適用するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **セキュリティ** > **コンプライアンスセンター**を選択します。
1. ページで、**プロジェクト**タブを選択します。
1. コンプライアンスとセキュリティポリシーフレームワークは、特別な指標とともにリストに表示されます。
1. コンプライアンスとセキュリティポリシーフレームワークを選択して、グループ内のプロジェクトに適用します。

### プロジェクトオーナーとして {#as-a-project-owner}

プロジェクトに適用されるコンプライアンスフレームワークを確認するには:

1. 左側のサイドバーで、**検索または移動先**を選択し、プロジェクトを見つけます:
1. **設定** > **一般**を選択します。
1. **コンプライアンスフレームワーク**セクションを展開する。
1. コンプライアンスとセキュリティポリシーグループからのものを含め、適用されたすべてのフレームワークを表示します。

## コンプライアンスとセキュリティポリシーフレームワークの変更 {#modifying-compliance-and-security-policy-frameworks}

コンプライアンスとセキュリティポリシーグループのコンプライアンスフレームワークを変更すると:

- 変更はすべてのグループに即座に反映されます。
- フレームワークを使用しているプロジェクトは、更新を自動的に継承します。
- 監査イベントはすべての変更を追跡します。
- グループまたはプロジェクトオーナーからのアクションは必要ありません。

## コンプライアンスとセキュリティポリシーフレームワークの削除 {#deleting-compliance-and-security-policy-frameworks}

コンプライアンスとセキュリティポリシーフレームワークを削除すると、GitLabは影響を受けるプロジェクトに関する警告を表示します。

コンプライアンスとセキュリティポリシーフレームワークの削除を確認する場合:

- フレームワークはすべてのプロジェクトから削除されます。
- 監査イベントが生成されます。
- フレームワークは、どのグループにも表示されなくなります。

## コンプライアンスとセキュリティポリシーグループの変更 {#changing-the-compliance-and-security-policy-group}

コンプライアンスとセキュリティポリシーグループとして機能するグループを変更する必要がある場合:

- 以前のコンプライアンスおよびセキュリティポリシーグループのすべてのフレームワークが利用できなくなります。
- 新しいコンプライアンスとセキュリティポリシーグループのフレームワークが利用可能になります。
- 必要に応じて、プロジェクトを新しいフレームワークに再割り当てる必要があります。

詳細な手順については、[コンプライアンスとセキュリティポリシーグループの指定](../../../security/compliance_security_policy_management.md#designate-a-compliance-and-security-policy-group)を参照してください。

## セキュリティポリシーとのインテグレーション {#integration-with-security-policies}

コンプライアンスとセキュリティポリシーフレームワークは、拡張されたコンプライアンスのためにセキュリティポリシーと統合できます:

1. コンプライアンスとセキュリティポリシーグループでセキュリティポリシーを作成します。
1. 特定のコンプライアンスフレームワークにスコープポリシーを設定します。
1. これらのフレームワークを使用するプロジェクトは、ポリシーを自動的に継承します。

詳細については、[コンプライアンスとセキュリティポリシーグループのセキュリティポリシー管理](../../application_security/policies/enforcement/compliance_and_security_policy_groups.md)を参照してください。

## トラブルシューティング {#troubleshooting}

集中管理されたコンプライアンスフレームワークの使用中に発生する可能性のあるイシューに対する可能な解決策。

### フレームワークがグループに表示されない {#frameworks-not-appearing-in-groups}

コンプライアンスとセキュリティポリシーフレームワークがグループに表示されない場合:

1. コンプライアンスとセキュリティポリシーグループが、管理設定で適切に指定されていることを確認します。
1. フレームワークがコンプライアンスとセキュリティポリシーグループに存在することを確認します。
1. フレームワークを表示するための適切なアクセス許可があることを確認します。

### コンプライアンスとセキュリティポリシーフレームワークを変更できません {#cannot-modify-compliance-and-security-policy-frameworks}

コンプライアンスとセキュリティポリシーフレームワークは、コンプライアンスとセキュリティポリシーグループからのみ変更できます:

1. コンプライアンスとセキュリティポリシーグループに直接移動します。
1. コンプライアンスおよびセキュリティポリシーグループに対するオーナーロールがあることを確認します。
1. コンプライアンスとセキュリティポリシーグループのコンプライアンスセンターから変更を加えます。

## フィードバックとサポート {#feedback-and-support}

この機能は[ベータ](../../../policy/development_stages_support.md#beta)版であるため、ユーザーからのフィードバックを積極的に求めています。次の方法で、あなたの体験、提案、そしてあらゆるイシューを共有してください:

- [GitLabイシュー](https://gitlab.com/gitlab-org/gitlab/-/issues)。
- 通常のGitLabサポートチャンネル。

## 関連トピック {#related-topics}

- [インスタンス全体のコンプライアンスとセキュリティポリシーの管理](../../../security/compliance_security_policy_management.md)
- [コンプライアンスフレームワーク](_index.md)
- [コンプライアンスとセキュリティポリシーグループ](../../application_security/policies/enforcement/compliance_and_security_policy_groups.md)
- [コンプライアンスセンター](../compliance_center/_index.md)
