---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
title: AWSソリューション
---

このドキュメントでは、GitLabをアマゾンウェブサービス（AWS）で活用することに関するソリューションについて説明します。

- [AWSからのGitLabパートナーシップ認定と指定](gitlab_aws_partner_designations.md)
- [GitLab AWSインテグレーションインデックス](gitlab_aws_integration.md)
- [AWS上のAmazon EKSのGitLabインスタンス](gitlab_instance_on_aws.md)
- [AWS上のGitalyに関するSREの考慮事項](gitaly_sre_for_aws.md)
- [AWSの単一EC2インスタンス上にGitLabをプロビジョニングする](gitlab_single_box_on_aws.md)

## クラウドプラットフォームの適切に設計されたコンプライアンス {#cloud-platform-well-architected-compliance}

テストに裏打ちされたアーキテクチャ認定は、クラウドソリューション実装の背後にある基本的な概念です:

- クラウドソリューションの実装では、GitLabリファレンスアーキテクチャのコンプライアンスを維持し、それに準拠していることを示すために、[GitLab Performance Tool](https://gitlab.com/gitlab-org/quality/performance)（GPT）レポートを提供します。
- クラウドソリューションの実装は、テクノロジーベンダーによって認定またはコントリビュートされる場合があります。たとえば、AWSの実装パターンは、AWSによって正式にレビューされる場合があります。
- クラウドソリューションの実装は、GitLabに適しているかどうかを判断するために、クラウドプラットフォームのPaaSサービスを特定してテストする場合があります。このテストは調整することができ、リファレンスアーキテクチャ向けにこれらのテクノロジーを認定するのに役立ちます。たとえば、PostgreSQLやRedisなどのトップレベルPaaSのランタイムバージョンとの互換性と可用性を認定します。
- クラウドソリューションの実装は、プラットフォームの制限に関する認定済みのテストを提供できます。たとえば、Gitalyクラスター（Praefect）が特定のクラウドプラットフォームのアベイラビリティーゾーンのレイテンシーとスループットの特性で正しく動作することを確認したり、利用可能なプラットフォームパートナーのローカルディスクパフォーマンスのどのレベルがGitalyサーバーが整合性を持って動作するのに適しているかを認定したりします。

## AWS既知のイシューリスト {#aws-known-issues-list}

既知のイシューは、GitLab内および顧客からレポートされたイシューから収集されます。お客様は、GitLabが特に設計されておらず、継続的なテストも行われていない、さまざまな「サービスとしての」コンポーネントでGitLabを正常に実装しています。GitLabはパートナーテクノロジーを非常に重視していますが、既知のイシューをここで強調することは、実装者にとっての便宜であり、GitLabが互換性を目標としていること、またはイシューが発生するパートナーテクノロジーでの実行を保証するものではありません。個々のイシューを参照して、特定の既知のイシューに関するGitLabのスタンスと計画を理解してください。

完全なリストについては、[GitLab AWS既知のイシューリスト](https://gitlab.com/gitlab-com/alliances/aws/public-tracker/-/issues?label_name[]=AWS+Known+Issue)を参照してください。

## GitLabをAWSで使用するための、動作するコード例を含むパターン {#patterns-with-working-code-examples-for-using-gitlab-with-aws}

[AWSのGuided Explorationsのサブグループ](https://gitlab.com/guided-explorations/aws)には、さまざまな動作例のプロジェクトが含まれています。

## プラットフォームパートナーの特異性 {#platform-partner-specificity}

クラウドソリューションの実装により、プラットフォーム固有の用語、ベストプラクティスアーキテクチャ、およびプラットフォーム固有のビルドマニフェストが可能になります:

- クラウドソリューションの実装は、よりベンダーに固有です。たとえば、vCPUまたはその他の一般的な対策の代わりに、特定のコンピューティングインスタンス/ VM /ノードを推奨します。
- クラウドソリューションの実装は、対象のベンダーに適したアーキテクチャを実装することを目的としています。
- クラウドソリューションの実装は、実装パターンが対象とするインフラストラクチャでのビルドに精通している対象者向けに記述されています。たとえば、実装パターンがGCPの場合、PaaSサービスに特定の名前を使用するなど、GCPの特定の用語が使用されます。
- クラウドソリューションの実装は、利用可能なPaaSのバージョンがGitLabと互換性があるかどうかをテストおよび認定できます（たとえば、PostgreSQL、Redisなど）。

## AWS Platform as a Service（PaaS）仕様と使用法 {#aws-platform-as-a-service-paas-specification-and-usage}

Platform as a Serviceオプションは、運用上の複雑さを簡素化し、高度で可用性の高いテクノロジーサービスを運用するために必要なSREおよびセキュリティスキルを削減するため、クラウドプラットフォームによって提供される価値の大きな部分を占めています。クラウドソリューションの実装は、パートナーのPaaSオプションに対して事前に認定できます。

- クラウドソリューションの実装は、実装者がどのPaaSオプションが動作することがわかっているかを理解し、単一のプラットフォームに同じGitLabロールに対して複数のPaaSオプションがある場合にPaaSソリューションをどのように選択するかを理解するのに役立ちます。
- たとえば、リファレンスアーキテクチャに、GitLab送信メールサービスにどのテクノロジーを活用するか、またはサイズをどうするかについて具体的な推奨事項がない場合、リファレンス実装では、クラウドプロバイダーのEmail as a Service（PaaS）を使用し、場合によっては特定の設定を使用することを推奨する場合があります。

[AWSサービスは、GitLabインフラストラクチャをデプロイするために使用できます](gitlab_instance_on_aws.md)で詳細を読むことができます。

## コスト最適化エンジニアリング {#cost-optimizing-engineering}

コストエンジニアリングはクラウドアーキテクチャの基本的な側面であり、プラットフォームで利用できる節約機能は、スケールされたコンピューティングのビルド方法に強い影響を与えることがよくあります。

- クラウドソリューションの実装は、プラットフォームプロバイダーで利用できる節約モデルに合わせて特別に設計する場合があります。AWSの例としては、予約インスタンスを利用するために、特定のインスタンスタイプの発生を最大化することが挙げられます。
- クラウドソリューションの実装は、適切な顧客ガイドラインがある場合は、一時的なコンピューティングを活用する場合があります。たとえば、一時的なコンピューティング上のRunner専用のKubernetesノードグループ（コンピューティングタイプを示す適切なGitLab Runnerのタグ付けを使用）。
- クラウドソリューションの実装には、ベンダー固有のコスト計算ツールが含まれる場合があります。

## 実行可能性と自動化指向 {#actionability-and-automatability-orientation}

クラウドソリューションの実装は、ビルド手順と自動化コードのソースとして使用できる詳細に一歩近づいています:

- クラウドソリューションの実装により、ビルド担当者は、特定のリファレンスアーキテクチャのGitLabを実装するために必要なベンダー固有のリソースのリストを生成できます。
- クラウドソリューションの実装により、ビルド担当者は、手動による指示を使用したり、自動化を作成してリファレンス実装をビルドしたりできます。

## 対象読者とコントリビューター {#intended-audiences-and-contributors}

この情報の主な対象者およびコントリビューターは、少なくとも以下で構成されるGitLabの**Implementation Eco System**（実装エコシステム）です:

GitLab実装コミュニティ:

- 顧客
- GitLabチャネルパートナー（インテグレーター）
- プラットフォームパートナー

GitLab内部実装チーム:

- 品質/配布/自己管理
- アライアンス
- トレーニング
- サポート
- プロフェッショナルサービス
- 公共部門
