# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module GitlabClient
      class WorkItemsDryClient < WorkItemsClient
        def create_discussion(id:, note:)
          puts "The following discussion would have been posted on #{project}##{id} epic:\n\n #{note}"
        end

        def create_discussion_note(work_item_id:, discussion_id:, text:)
          puts "The following discussion note would have been posted on #{project}##{work_item_id} (discussion #{discussion_id}) text:\n\n #{text}"
        end

        def create_linked_items(work_item_id:, item_ids:, link_type: 'BLOCKED_BY')
          puts "The following items would have been linked on #{project}##{work_item_id} (link type: #{link_type}) item_ids: #{item_ids.join(', ')}"
        end

        def add_labels(work_item_id:, label_ids:)
          puts "The following labels would have been added to #{project}##{work_item_id} work item: #{label_ids.join(', ')}"
        end
      end
    end
  end
end
