---
stage: Software Supply Chain Security
group: Compliance
info: "To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments"
title: 監査イベントタイプ
---

<!--
  This documentation is auto generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  bundle exec rake gitlab:audit_event_types:compile_docs

  To make changes to the output of the Rake task,
  edit `tooling/audit_events/docs/templates/audit_event_types.md.erb`.
-->

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.7 [で導入](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172757)され、すべての監査イベントをストリーミングできるようになりました。

{{< /history >}}

監査イベントタイプは、ストリーミングされた監査イベントをフィルタリングするために使用されます:

- [インスタンスの場合](../../administration/compliance/audit_event_streaming.md#update-event-filters)。
- [トップレベルグループの場合](audit_event_streaming.md#update-event-filters)

すべての監査イベントは、イベントタイプに関連付けられています。監査イベントタイプでは、以下が可能です:

- ほとんどの監査イベントをデータベースに保存できます。PremiumプランおよびUltimateプランで利用できます。これらのタイプに関連付けられた監査イベントを取得するには、監査イベントダッシュボードまたは[API](../../api/audit_events.md)を使用します。
- すべての監査イベントを外部の宛先にストリーミングできます。Ultimateプランで利用できます。宛先が設定されている場合、これらのタイプに関連付けられた監査イベントを外部の宛先にストリーミングできます。

監査イベントタイプのスコープは、監査イベントタイプの可用性を以下に制限します:

- [プロジェクト、グループ、またはユーザー](audit_events.md)監査イベント。
- インスタンスの[インスタンス](../../administration/compliance/audit_event_reports.md)監査イベント

## 利用可能な監査イベントタイプ {#available-audit-event-types}

監査イベントタイプは、次の製品カテゴリに属しています。

### AIフレームワーク {#ai-framework}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`duo_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145509) | グループまたはプロジェクトでGitLab Duo機能の有効設定が変更されました | {{< icon name="check-circle" >}}対応 | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/442485) | グループ、プロジェクト |
| [`q_onbarding_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175501) | Amazon Qインスタンス設定が変更されました | {{< icon name="check-circle" >}}対応 | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/508250) | インスタンス |

### 監査イベント {#audit-events}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132443) | 監査イベントストリーミング用のAmazon S3構成が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | グループ |
| [`amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133695) | 監査イベントストリーミング用のAmazon S3構成が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | グループ |
| [`amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133691) | 監査イベントストリーミング用のAmazon S3構成が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | グループ |
| [`audit_events_streaming_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | 監査イベントのストリーミングヘッダーが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | グループ |
| [`audit_events_streaming_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | 監査イベントのストリーミングヘッダーが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | グループ |
| [`audit_events_streaming_instance_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125870) | インスタンスレベルの外部監査イベント宛先のストリーミングヘッダーが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | インスタンス |
| [`audit_events_streaming_instance_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | インスタンスレベルの外部監査イベント宛先のストリーミングヘッダーが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | インスタンス |
| [`audit_events_streaming_instance_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | インスタンスレベルの外部監査イベント宛先のストリーミングヘッダーが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | インスタンス |
| [`create_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | 外部監査イベントの宛先が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | グループ |
| [`create_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136047) | トップレベルグループの外部監査イベント宛先のネームスペースフィルターが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/424176) | グループ |
| [`create_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123882) | インスタンスの外部監査イベント宛先が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | インスタンス |
| [`created_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147888) | トップレベルグループの外部監査イベント宛先が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | グループ |
| [`created_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | トップレベルグループの外部監査イベント宛先のネームスペースフィルターが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | グループ |
| [`created_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148383) | インスタンスの外部監査イベント宛先が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | インスタンス |
| [`created_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | インスタンスの外部監査イベント宛先のネームスペースフィルターが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | インスタンス |
| [`delete_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136302) | トップレベルグループの外部監査イベント宛先のネームスペースフィルターが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/424177) | グループ |
| [`deleted_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148738) | トップレベルグループの外部監査イベント宛先が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | グループ |
| [`deleted_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | トップレベルグループの外部監査イベント宛先のネームスペースフィルターが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | グループ |
| [`deleted_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/14910) | GitLabインスタンスの外部監査イベント宛先が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | インスタンス |
| [`deleted_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | GitLabインスタンスの外部監査イベント宛先のネームスペースフィルターが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | インスタンス |
| [`destroy_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | 外部監査イベントの宛先が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | グループ |
| [`destroy_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | インスタンスレベルの外部監査イベント宛先が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | インスタンス |
| [`event_type_filters_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113081) | 新しい監査イベントストリーミングイベントタイプフィルターが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | グループ |
| [`event_type_filters_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113489) | 監査イベントストリーミングイベントタイプフィルターが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | グループ |
| [`google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging構成が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | グループ |
| [`google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging構成が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | グループ |
| [`google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging構成が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | グループ |
| [`instance_amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137651) | 監査イベントストリーミング用のインスタンスAmazon S3構成が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | インスタンス |
| [`instance_amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138318) | 監査イベントストリーミング用のインスタンスレベルのAmazon S3構成が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | インスタンス |
| [`instance_amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138310) | 監査イベントストリーミング用のインスタンスレベルのAmazon S3構成が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | インスタンス |
| [`instance_google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130663) | インスタンスレベルでのGoogle Cloud Loggingの設定が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423038) | インスタンス |
| [`instance_google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131752) | インスタンスレベルでのGoogle Cloud Loggingの設定が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423040) | インスタンス |
| [`instance_google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131790) | インスタンスレベルでのGoogle Cloud Loggingの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423039) | インスタンス |
| [`update_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | 外部監査イベントの宛先が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | グループ |
| [`update_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | インスタンスレベルの外部監査イベント宛先が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | インスタンス |
| [`updated_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148388) | トップレベルグループの外部監査イベント宛先が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | グループ |
| [`updated_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149104) | GitLabインスタンスの外部監査イベント宛先が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | インスタンス |

### 認証 {#authorization}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`oauth_application_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194557) | ユーザーがOAuthアプリケーションを作成しました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/550321) | ユーザー |
| [`secure_ci_job_token_policies_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170930) | CI_JOB_TOKENスコープの権限が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/495144) | プロジェクト |
| [`user_authorized_oauth_application`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179187) | ユーザーがOAuthアプリケーションを承認しました | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/514152) | ユーザー |

### ビルドアーティファクト {#build-artifacts}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`job_artifact_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129608) | ユーザーがプロジェクトからジョブアーティファクトをダウンロードしました | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/250663) | プロジェクト |

### Ci variables {#ci-variables}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`variable_viewed_api`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197385) | APIでCI/CD変数にアクセスしました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555960) | プロジェクト、グループ |
| [`group_ci_cd_settings_accessed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203540) | ユーザーがグループのCI/CD設定ページを読み込んだときに、監査イベントを記録します。 | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/555959) | グループ |
| [`project_ci_cd_settings_accessed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203540) | ユーザーがプロジェクトのCI/CD設定ページを読み込んだときに、監査イベントを記録します。 | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/555959) | プロジェクト |

### コードレビュー {#code-review}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`delete_merge_request`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | マージリクエストが正常に削除されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | プロジェクト |
| [`group_merge_request_approval_setting_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87880) | マージリクエスト承認設定がグループに追加されました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/356152) | グループ |

### コードレビューワークフロー {#code-review-workflow}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`merge_request_approval_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92983) | マージリクエストが承認されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/10869) | プロジェクト |
| [`merge_request_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | プロジェクトアクセストークンを使用してマージリクエストがクローズされました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`merge_request_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | プロジェクトアクセストークンを使用してマージリクエストが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`merge_request_invalid_approver_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | マージリクエストが承認されたときの無効なルール | {{< icon name="check-circle" >}}対応 | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | プロジェクト |
| [`merge_request_merged_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | プロジェクトアクセストークンを使用してマージリクエストがマージされました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`merge_request_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | プロジェクトアクセストークンを使用してマージリクエストが再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`project_merge_method_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | プロジェクトのマージリクエストメソッドが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | プロジェクト |
| [`project_merge_requests_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトのMR作成者の承認設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`project_merge_requests_disable_committers_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | マージリクエストでのコミッターの承認を無効にするプロジェクトの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369277) | プロジェクト |
| [`project_merge_requests_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | プロジェクトのマージリクエストテンプレートが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | プロジェクト |
| [`project_only_allow_merge_if_all_discussions_are_resolved_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | すべてのディスカッションが解決された場合にのみマージを許可するプロジェクトの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369286) | プロジェクト |
| [`project_only_allow_merge_if_pipeline_succeeds_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | パイプラインが成功した場合にのみマージを許可するプロジェクトの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`project_remove_source_branch_after_merge_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | プロジェクトでマージ後にブランチを削除する設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | プロジェクト |
| [`project_require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | マージリクエストの承認にユーザーのパスワードを要求するプロジェクトの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369280) | プロジェクト |
| [`project_reset_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66234) | プッシュ時に承認がリセットされるかどうかに関するプロジェクトの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.2](https://gitlab.com/gitlab-org/gitlab/-/issues/336211) | プロジェクト |
| [`project_resolve_outdated_diff_discussions_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトの古い差分ディスカッション解決設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`show_diff_preview_in_email_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | 差分のプレビューを含めるようにメール通知を設定するが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ、プロジェクト |
| [`selective_code_owner_removals_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148743) | 選択的コードオーナーの削除が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/327562) | プロジェクト |

### コード提案 {#code-suggestions}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_suggestion_commit_message_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | プロジェクトで推奨されるコミットメッセージが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | プロジェクト |

### コンプライアンスフレームワークの管理 {#compliance-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`add_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | GPGキーが追加されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | ユーザー |
| [`allow_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | マージリクエスト作成者による承認を防止する設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | グループ |
| [`allow_committer_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | コミットを追加するユーザーによる承認を防止する設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | グループ |
| [`allow_overrides_to_approver_list_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | プロジェクトおよびマージリクエストでの承認ルール編集を防止する設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | グループ |
| [`audit_events_streaming_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | 監査イベントのストリーミングヘッダーが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | グループ |
| [`compliance_control_status_fail`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107) | コンプライアンスフレームワーク制御ステータスが失敗に更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/513425) | プロジェクト |
| [`compliance_control_status_pass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107) | コンプライアンスフレームワーク制御ステータスが合格に更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/513425) | プロジェクト |
| [`compliance_framework_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | コンプライアンスフレームワークがプロジェクトに適用されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | プロジェクト |
| [`compliance_framework_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65343) | コンプライアンスフレームワークがプロジェクトから削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/329362) | プロジェクト |
| [`compliance_framework_id_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/94711) | コンプライアンスフレームワークのIDがプロジェクト用に更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369310) | プロジェクト |
| [`compliance_framework_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | コンプライアンスフレームワークがプロジェクトから削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | プロジェクト |
| [`create_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | コンプライアンスフレームワークが正常に作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | グループ |
| [`create_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | 外部ステータスチェックが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | プロジェクト |
| [`created_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485) | 要件がコンプライアンスフレームワークに追加されました | {{< icon name="check-circle" >}}対応 | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | グループ |
| [`created_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557) | コントロールがコンプライアンスフレームワーク要件に追加されました。 | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | グループ |
| [`delete_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | 外部ステータスチェックが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | プロジェクト |
| [`destroy_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | コンプライアンスフレームワークが正常に削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | グループ |
| [`destroyed_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170380) | コンプライアンスフレームワーク要件が破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | グループ |
| [`destroyed_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177878) | コンプライアンスフレームワーク要件の制御が破棄されました。 | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | グループ |
| [`external_status_check_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106095) | 外部ステータスチェックの名前が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369333) | プロジェクト |
| [`external_status_check_url_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | パイプラインの外部ステータスチェックに使用されるURLが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | プロジェクト |
| [`group_saml_member_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202160) | ユーザーがSAMLグループメンバーとして追加されました | {{< icon name="check-circle" >}}対応 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/560237) | グループ |
| [`group_saml_provider_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | グループSAMLプロバイダーが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | グループ |
| [`group_saml_provider_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | グループSAMLプロバイダーが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | グループ |
| [`inactive_project_scheduled_for_deletion`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130699) | 非アクティブなプロジェクトが削除のスケジュールに登録されました | {{< icon name="check-circle" >}}対応 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423263) | プロジェクト |
| [`member_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | メンバーシップが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | グループ、プロジェクト |
| [`member_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | メンバーシップが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | グループ、プロジェクト |
| [`member_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | メンバーシップが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | グループ、プロジェクト |
| [`merge_request_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90911) | マージリクエストが作成された | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/367239) | プロジェクト |
| [`merge_request_merged`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164846) | マージリクエストがマージされました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/442279) | プロジェクト |
| [`omniauth_login_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | OmniAuthログインが失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`password_reset_requested`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114548) | ユーザーが登録済みのメールアドレスを使用してパスワードのリセットをリクエストしました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`pending_compliance_external_control_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180016) | タイムアウトのため、プロジェクトのコンプライアンスフレームワーク外部コントロールステータスが失敗に更新されました。 | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | プロジェクト |
| [`personal_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | ユーザーがパーソナルアクセストークンを作成しました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | ユーザー |
| [`personal_access_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | パーソナルアクセストークンが取り消されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | ユーザー |
| [`project_archived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | プロジェクトがアーカイブされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`project_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | プロジェクトが削除対象としてマークされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | グループ、インスタンス |
| [`project_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | プロジェクトが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | グループ、インスタンス |
| [`project_export_file_download_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | プロジェクトエクスポートファイルのダウンロードが開始されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`project_feature_security_and_compliance_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのセキュリティとコンプライアンスフレームワークのアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369302) | プロジェクト |
| [`project_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | グループがプロジェクトに招待されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | グループ |
| [`project_group_link_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | プロジェクトグループリンクが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | グループ |
| [`project_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | プロジェクトグループリンクが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | プロジェクト |
| [`project_imported`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | プロジェクトがインポートされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | グループ |
| [`project_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | プロジェクトが復元されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`protected_branch_allow_force_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68869) | 保護ブランチで強制プッシュを許可する機能が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/338873) | プロジェクト |
| [`public_repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149842) | 公開プロジェクトのGitリポジトリがダウンロードされました | {{< icon name="dotted-circle" >}}対象外 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/383218) | プロジェクト |
| [`registration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | ユーザーがインスタンスアクセスを登録しました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`release_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | リリースが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | プロジェクト |
| [`release_deleted_audit_event`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | リリースが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | プロジェクト |
| [`release_milestones_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | リリースの関連マイルストーンが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | プロジェクト |
| [`release_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | リリースが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | プロジェクト |
| [`remove_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | GPGキーが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | ユーザー |
| [`repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111218) | プライベートまたは内部プロジェクトのGitリポジトリがダウンロードされました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374108) | プロジェクト |
| [`request_to_compliance_external_control_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010) | コンプライアンスフレームワークの外部制御へのリクエストが失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | プロジェクト |
| [`request_to_compliance_external_control_successful`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010) | コンプライアンスフレームワークの外部制御へのリクエストが成功しました | {{< icon name="dotted-circle" >}}対象外 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | プロジェクト |
| [`require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | グループマージリクエスト設定からの承認にユーザーパスワードを要求するが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | グループ |
| [`retain_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | グループマージリクエスト設定から、新しいコミットがMRに追加されたときに新しい承認を要求するが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | グループ |
| [`saml_group_links_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | SAMLグループリンクが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | グループ |
| [`saml_group_links_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | SAMLグループリンクが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | グループ |
| [`smartcard_authentication_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/8120) | ユーザーがスマートカードで認証されました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/726) | ユーザー |
| [`update_approval_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | マージ承認ルールを更新しています | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | プロジェクト |
| [`update_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | コンプライアンスフレームワークが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | グループ |
| [`update_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485) | コンプライアンスフレームワーク要件が更新されました。 | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | グループ |
| [`update_project_compliance_violation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195768) | 更新されたプロジェクトのコンプライアンス違反です。 | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/542343) | プロジェクト |
| [`update_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | 外部ステータスチェックが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | プロジェクト |
| [`updated_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557) | コンプライアンスフレームワーク要件の制御が更新されました。 | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | グループ |

### コンテナレジストリ {#container-registry}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`container_repository_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156037) | コンテナリポジトリが最初にレジストリにプッシュされました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | プロジェクト |
| [`container_repository_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | プロジェクトのコンテナリポジトリが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | プロジェクト |
| [`container_repository_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | プロジェクトのコンテナリポジトリが削除対象としてマークされました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | プロジェクト |
| [`container_repository_tags_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156066) | プロジェクトのコンテナリポジトリタグが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | プロジェクト |
| [`project_feature_container_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのコンテナリポジトリのアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369303) | プロジェクト |

### 継続的デリバリー {#continuous-delivery}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`deploy_key_added`](https://gitlab.com/gitlab-org/gitlab/-/commit/08586a616909c7f9efe2210c2b74fd3422d4eb62) | デプロイキーが追加されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deploy_key_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92219) | デプロイキーが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | デプロイトークンが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | デプロイトークンの作成に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | デプロイトークンが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | プロジェクトデプロイトークンが取り消されました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`deployment_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | デプロイが承認されました | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | プロジェクト |
| [`deployment_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | デプロイが拒否されました | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | プロジェクト |
| [`deployment_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156111) | 保護環境へのデプロイが開始されました | {{< icon name="check-circle" >}}対応 | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/456687) | プロジェクト |
| [`group_deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | グループデプロイトークンが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | グループデプロイトークンの作成に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | グループデプロイトークンが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | グループデプロイトークンが取り消されました | {{< icon name="check-circle" >}}対応 | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |

### 継続的インテグレーション {#continuous-integration}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_merge_on_skipped_pipeline_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | スキップされたパイプラインが成功した設定と見なされるように更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | プロジェクト |
| [`ci_group_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | グループのCI/CD変数が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | グループ |
| [`ci_group_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | グループのCI/CD変数が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | グループ |
| [`ci_group_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | グループのCI/CD変数が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | グループ |
| [`ci_instance_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | インスタンスのCI/CD変数が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | インスタンス |
| [`ci_instance_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | インスタンスのCI/CD変数が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | インスタンス |
| [`ci_instance_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | インスタンスのCI/CD変数が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | インスタンス |
| [`ci_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | プロジェクトの<CI/CD変数>CI/CD変数</CI/CD変数>が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | プロジェクト |
| [`ci_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | プロジェクトの<CI/CD変数>CI/CD変数</CI/CD変数>が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | プロジェクト |
| [`ci_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | プロジェクトの<CI/CD変数>CI/CD変数</CI/CD変数>が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | プロジェクト |
| [`destroy_pipeline`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135255) | パイプラインが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/339041) | プロジェクト |
| [`multi_project_downstream_pipeline_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168626) | マルチプロジェクトダウンストリームパイプラインが作成されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | プロジェクト |
| [`project_cicd_merge_pipelines_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | プロジェクトのCI/CDマージパイプラインの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | プロジェクト |

### デリバリー {#delivery}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_releases_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのリリースのアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369308) | プロジェクト |

### デプロイ管理 {#deployment-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`cluster_agent_create_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | クラスターエージェントを作成しようとしたが失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | プロジェクト |
| [`cluster_agent_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | クラスターエージェントを作成します | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | プロジェクト |
| [`cluster_agent_delete_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | クラスターエージェントを削除しようとしたが失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | プロジェクト |
| [`cluster_agent_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | クラスターエージェントを削除します | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | プロジェクト |
| [`cluster_agent_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | クラスターエージェントトークンを作成します | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | プロジェクト |
| [`cluster_agent_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | クラスターエージェントトークンを失効させます | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | プロジェクト |

### DORAメトリクス {#dora-metrics}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_metrics_dashboard_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのメトリクスダッシュボードのアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | プロジェクト |

### GitLab Duo Agent Platform {#duo-agent-platform}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`api_request_access_with_scope`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172548) | 監査対象のスコープを持つトークンで認証されたAPIリクエストのサブセット | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/499461) | ユーザー |

### 動的アプリケーションセキュリティテスト（DAST） {#dynamic-application-security-testing}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`dast_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | 動的アプリケーションセキュリティテストプロファイルが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | 動的アプリケーションセキュリティテストプロファイルが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_profile_schedule_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68046) | 動的アプリケーションセキュリティテストプロファイルプロファイルスケジュールが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | プロジェクト |
| [`dast_profile_schedule_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66445) | 動的アプリケーションセキュリティテストプロファイルプロファイルスケジュールが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | プロジェクト |
| [`dast_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | 動的アプリケーションセキュリティテストプロファイルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_scanner_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | 動的アプリケーションセキュリティテストスキャナープロファイルが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_scanner_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | 動的アプリケーションセキュリティテストスキャナープロファイルが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_scanner_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | 動的アプリケーションセキュリティテストスキャナープロファイルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_site_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | 動的アプリケーションセキュリティテストサイトプロファイルが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_site_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | 動的アプリケーションセキュリティテストサイトプロファイルが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |
| [`dast_site_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | 動的アプリケーションセキュリティテストサイトプロファイルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | プロジェクト |

### 環境管理 {#environment-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`environment_protected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | 保護環境が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | グループ、プロジェクト |
| [`environment_unprotected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | 保護環境が保護解除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | グループ、プロジェクト |
| [`project_feature_environments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトの環境のアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369307) | プロジェクト |
| [`protected_environment_approval_rule_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | 承認ルールが保護環境に追加されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | グループ、プロジェクト |
| [`protected_environment_approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | 承認ルールが保護環境から削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | プロジェクト、グループ |
| [`protected_environment_approval_rule_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | 保護環境の承認ルールが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | プロジェクト、グループ |
| [`protected_environment_deploy_access_level_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | デプロイアクセスレベルが保護環境に追加されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | グループ、プロジェクト |
| [`protected_environment_deploy_access_level_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | デプロイアクセスレベルが保護環境から削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | グループ、プロジェクト |
| [`protected_environment_deploy_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | 保護環境のデプロイアクセスレベルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | プロジェクト |
| [`protected_environment_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | 保護環境が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | グループ、プロジェクト |

### 機能フラグ {#feature-flags}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_feature_flags_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトの機能フラグのアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369306) | プロジェクト |
| [`feature_flag_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | 機能フラグが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | プロジェクト |
| [`feature_flag_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | 機能フラグが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | プロジェクト |
| [`feature_flag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | 機能フラグが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | プロジェクト |

### フリートの可視性 {#fleet-visibility}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`ci_runner_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173885) | Runnerが作成されるとトリガーされます | {{< icon name="check-circle" >}}対応 | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/503315) | インスタンス、グループ、プロジェクト |
| [`ci_runner_usage_export`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139578) | Runnerの使用状況レポートが生成されます | {{< icon name="check-circle" >}}対応 | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/426560) | インスタンス |
| [`ci_runners_bulk_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173886) | Runnerは一括で削除されます | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/503315) | ユーザー |

### ファズテスト {#fuzz-testing}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`coverage_fuzzing_corpus_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71992) | コーパスアクションが追加されました | {{< icon name="check-circle" >}}対応 | GitLab [14.5](https://gitlab.com/gitlab-org/gitlab/-/issues/341485) | プロジェクト |

### グループとプロジェクト {#groups-and-projects}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`create_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | SSH証明書が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | グループ |
| [`delete_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | SSH証明書が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | グループ |
| [`emails_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | [メール通知を有効にする]設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`enabled_git_access_protocol_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | [有効なGitアクセスプロトコル]設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`enforce_ssh_certificates_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | [SSH証明書を強制する]設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`group_archived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199419) | グループがアーカイブされました | {{< icon name="check-circle" >}}対応 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/520013) | グループ |
| [`group_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121005) | グループが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/411595) | グループ |
| [`group_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | グループが削除対象としてマークされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | グループ |
| [`group_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | グループの説明が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`group_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | グループが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | グループ |
| [`group_lfs_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループに対してLFSが有効になっているかが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | グループ |
| [`group_membership_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループのメンバーシップロックが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | グループ |
| [`group_mentions_disabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | グループメンションに関するグループメンバーへの通知設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`group_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの名前が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369320) | グループ |
| [`group_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループのパスが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369321) | グループ |
| [`group_project_creation_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループのプロジェクト作成レベルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369327) | グループ |
| [`group_request_access_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの[アクセスリクエストを有効にする]が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | グループ |
| [`group_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | グループが復元されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | グループ |
| [`group_share_with_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | グループのメンバーシップページを使用して、別のグループにグループを招待します | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | グループ |
| [`group_share_with_group_link_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | グループのメンバーシップページを使用して、別のグループからグループを削除します | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | グループ |
| [`group_share_with_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | グループのメンバーシップページを使用して、別のグループへのグループのアクセス設定を更新します | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | グループ |
| [`group_shared_with_group_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | 他のグループ設定と共有できるグループが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`group_unarchived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199419) | グループのアーカイブが解除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/520013) | グループ |
| [`group_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの表示レベルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | グループ |
| [`prevent_sharing_groups_outside_hierarchy_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | グループとそのサブグループ外のグループをメンバーが招待できないようにするグループの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`project_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | プロジェクトが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`project_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128978) | プロジェクトの説明が更新されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377769) | プロジェクト |
| [`project_feature_operations_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトの操作アクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369300) | プロジェクト |
| [`project_feature_requirements_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトの要件アクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369301) | プロジェクト |
| [`project_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | プロジェクト名が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [10.2](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | プロジェクト |
| [`project_namespace_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトのネームスペースが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`project_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100770) | プロジェクトのパスが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369271) | プロジェクト |
| [`project_topics_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154158) | プロジェクトのトピックの割り当てが変更されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/343204) | プロジェクト |
| [`project_unarchived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | プロジェクトのアーカイブが解除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`project_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトの表示レベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`remove_dormant_members_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | 削除前に非アクティブな日数の設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`remove_dormant_members_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | 休止状態のメンバー設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |

### インポーター {#importers}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`direct_transfer_relation_export_batch_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | ダイレクト転送関係のエクスポートバッチがダウンロードされました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | グループ、プロジェクト |
| [`direct_transfer_relation_export_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | ダイレクト転送関係のエクスポートがダウンロードされました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | グループ、プロジェクト |
| [`direct_transfer_relations_export_initiated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | ダイレクト転送関係のエクスポートが開始されました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | グループ、プロジェクト |
| [`group_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | グループファイルのエクスポートが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | グループ |
| [`project_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | プロジェクトファイルのエクスポートが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | プロジェクト |

### インシデント管理 {#incident-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`incident_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してインシデントがクローズされました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`incident_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してインシデントが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`incident_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してインシデントが再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |

### マージトレイン {#merge-trains}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_cicd_merge_trains_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | プロジェクトのCI/CDマージトレインの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | プロジェクト |

### MLOps {#mlops}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_model_experiments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121027) | プロジェクトのモデル検証アクセスレベルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/412384) | プロジェクト |
| [`ml_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | MLモデルが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | プロジェクト |
| [`ml_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | MLモデルが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | プロジェクト |
| [`ml_model_version_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | MLモデルバージョンが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | プロジェクト |
| [`ml_model_version_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | MLモデルバージョンが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | プロジェクト |
| [`project_feature_model_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138399) | MLモデルレジストリのアクセスレベルが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/412734) | プロジェクト |

### 未分類 {#not-categorized}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`experiment_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118222) | 実験AI機能の有効化設定が切り替えられました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/404856/) | グループ |

### 可観測性 {#observability}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_monitor_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのモニターアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369304) | プロジェクト |

### パッケージレジストリ {#package-registry}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`package_registry_package_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178181) | GitLabパッケージレジストリからパッケージが削除されました。ネームスペースのパッケージ設定`audit_events_enabled`がtrueの場合にのみ利用できます。 | {{< icon name="check-circle" >}}対応 | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/329588) | プロジェクト、グループ |
| [`package_registry_package_published`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178181) | GitLabパッケージレジストリにパッケージが公開されました。ネームスペースのパッケージ設定`audit_events_enabled`がtrueの場合にのみ利用できます。 | {{< icon name="check-circle" >}}対応 | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/329588) | プロジェクト、グループ |
| [`project_feature_package_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのパッケージレジストリのアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369296) | プロジェクト |
| [`project_packages_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/7962) | プロジェクトのパッケージを制御する設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [11.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |

### ページ {#pages}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_pages_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのページのアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369297) | プロジェクト |

### 権限 {#permissions}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`custom_admin_role_assigned_to_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186570) | カスタム管理者ロールがユーザーに割り当てられました | {{< icon name="check-circle" >}}対応 | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/507958) | ユーザー |
| [`custom_admin_role_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | カスタム管理者ロールが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | インスタンス |
| [`custom_admin_role_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | カスタム管理者ロールが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | インスタンス |
| [`custom_admin_role_unassigned_from_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186570) | カスタム管理者ロールがユーザーからの割り当て解除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/507958) | ユーザー |
| [`custom_admin_role_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | カスタム管理者ロールが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | インスタンス |
| [`member_role_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137087) | カスタムロールが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/388934) | グループ、インスタンス |
| [`member_role_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | カスタムロールが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | グループ、インスタンス |
| [`member_role_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | カスタムロールが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | グループ、インスタンス |

### ポートフォリオ管理 {#portfolio-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`delete_epic`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | エピックが正常に削除されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | グループ |
| [`epic_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | エピックがグループアクセストークンによってクローズされました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | グループ |
| [`epic_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | エピックがグループアクセストークンによって作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | グループ |
| [`epic_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | エピックがグループアクセストークンによって再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | グループ |

### プロダクト分析データ管理 {#product-analytics-data-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`product_analytics_settings_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154101) | プロダクト分析設定が変更されました | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/463318) | プロジェクト |

### 品質管理 {#quality-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`test_case_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してテストケースがクローズされました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`test_case_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してテストケースが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`test_case_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用してテストケースが再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |

### Runner {#runner}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_runner_registration_token_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | プロジェクトとグループのメンバーがRunner登録トークンを使用してRunnerを作成できるようにするの設定を更新しました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ、プロジェクト |
| [`ci_runner_assigned_to_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81508) | Runnerがプロジェクトに割り当てられました | {{< icon name="check-circle" >}}対応 | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349542) | プロジェクト |
| [`ci_runner_registered`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77109) | インスタンス、グループ、またはプロジェクトRunnerが登録されました | {{< icon name="check-circle" >}}対応 | GitLab [14.8](https://gitlab.com/gitlab-org/gitlab/-/issues/359958) | インスタンス、グループ、プロジェクト |
| [`ci_runner_token_reset`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/85535) | Runnerのトークンがリセットされました | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355637) | インスタンス、グループ、プロジェクト |
| [`ci_runner_unassigned_from_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81540) | Runnerがプロジェクトから割り当て解除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349542) | プロジェクト |
| [`ci_runner_unregistered`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79754) | インスタンス、グループ、またはプロジェクトRunnerが登録解除されました | {{< icon name="check-circle" >}}対応 | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349540) | インスタンス、グループ、プロジェクト |
| [`group_shared_runners_minutes_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの共有Runnerの分数制限が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369324) | グループ |
| [`runner_registration_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Runnerの登録設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`set_runner_associated_projects`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/97666) | 関連付けられたプロジェクトがCI/CDRunnerに正常に割り当てられました | {{< icon name="check-circle" >}}対応 | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/359958) | プロジェクト |

### シートコスト管理 {#seat-cost-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`seat_control_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | 設定シートのコントロールが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |

### シークレット検出 {#secret-detection}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`group_secret_push_protection_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174412) | シークレットプッシュ保護が、除外するように指定されたプロジェクトを除き、グループとその子グループおよびプロジェクトに対して有効または無効になっています | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/502829) | グループ |
| [`group_validity_checks_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205405) | 除外するように指定されたプロジェクトを除き、グループとその子グループおよびプロジェクトに対して、有効性チェックが有効または無効になっています | {{< icon name="check-circle" >}}対応 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/570740) | グループ |
| [`project_security_exclusion_applied`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | プロジェクトのセキュリティ除外がセキュリティスキャナーのいずれかに適用されました | {{< icon name="check-circle" >}}対応 | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/492465) | プロジェクト |
| [`project_security_exclusion_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | プロジェクトセキュリティ除外が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | プロジェクト |
| [`project_security_exclusion_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | プロジェクトのセキュリティ除外が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | プロジェクト |
| [`project_security_exclusion_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | プロジェクトセキュリティ除外が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | プロジェクト |
| [`project_security_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150767) | プロジェクトのセキュリティ設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/457024) | プロジェクト |
| [`skip_secret_push_protection`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147855) | シークレットプッシュ保護がユーザーによってスキップされました | {{< icon name="check-circle" >}}対応 | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/441185) | プロジェクト |

### シークレット管理 {#secrets-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`user_authenticated_using_job_token`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164546) | ユーザーがジョブトークンを使用して認証されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | プロジェクト |
| [`secrets_manager_create_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | このイベントは、プロジェクトレベルのシークレットがユーザーによって作成されたときにトリガーされます | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | プロジェクト |
| [`secrets_manager_delete_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | このイベントは、プロジェクトレベルのシークレットがユーザーによって削除されたときにトリガーされます | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | プロジェクト |
| [`secrets_manager_read_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | このイベントは、CIパイプラインジョブがOpenbaoからプロジェクトレベルのシークレットの値を読み取るときにトリガーされます | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | プロジェクト |
| [`secrets_manager_update_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | このイベントは、プロジェクトレベルのシークレットがユーザーによって更新されたときにトリガーされます | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | プロジェクト |

### セキュリティポリシー管理 {#security-policy-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`policy_project_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102154) | セキュリティポリシープロジェクトがプロジェクト用に更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/377877) | グループ、プロジェクト |
| [`policy_warn_mode_approval_settings_overrides`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/208969) | 警告モードのマージリクエスト承認ポリシーにより、より制限の厳しい`approval_settings`が設定されました。 | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/563867) | プロジェクト |
| [`policy_warn_mode_merge_request_approval`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210351) | 警告モードのセキュリティポリシーによって、マージリクエストの承認が阻止された可能性があります。 | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/563867) | プロジェクト |
| [`security_policy_access_token_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196249) | セキュリティポリシーによってブロックされているブランチのプッシュは、構成済みのアクセストークンで回避されます | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549644) | プロジェクト |
| [`security_policy_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | セキュリティポリシーが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | プロジェクト |
| [`security_policy_delete`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | セキュリティポリシーが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | プロジェクト |
| [`security_policy_limit_exceeded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196005) | 有効なポリシーの数が、ポリシータイプの最大許容制限を超えました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/550891) | プロジェクト |
| [`security_policy_merge_request_merged_with_policy_violations`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195775) | マージリクエストがセキュリティポリシー違反とともにマージされました | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/549813) | プロジェクト |
| [`security_policy_pipeline_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196628) | セキュリティポリシージョブを含むパイプラインが失敗しました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/539232) | プロジェクト |
| [`security_policy_pipeline_skipped`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195325) | セキュリティポリシーパイプラインがスキップされました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/539232) | プロジェクト |
| [`security_policy_scheduled_scans_not_enforced`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201822) | セキュリティポリシーを含むスケジュールされたパイプラインを作成できませんでした | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/561047) | プロジェクト |
| [`security_policy_service_account_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196249) | セキュリティポリシーによってブロックされているブランチのプッシュは、構成済みのサービスアカウントで回避されます | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549644) | プロジェクト |
| [`security_policy_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | セキュリティポリシーが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | プロジェクト |
| [`security_policy_user_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201001) | セキュリティポリシーによってブロックされているブランチのプッシュは、構成済みのユーザーで回避されます | {{< icon name="check-circle" >}}対応 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/549797) | プロジェクト |
| [`security_policy_violations_detected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193482) | セキュリティポリシー違反がマージリクエストで検出されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/549811) | プロジェクト |
| [`security_policy_violations_resolved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193482) | セキュリティポリシー違反がマージリクエストで解決されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549812) | プロジェクト |
| [`security_policy_yaml_invalidated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196721) | ポリシーYAMLが無効になりました（セキュリティポリシープロジェクト内） | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/550892) | プロジェクト |
| [`status_check_response_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189293) | ユーザーがマージリクエストの外部ステータスチェックの応答を更新しました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/413535) | プロジェクト |
| [`merge_request_branch_bypassed_by_security_policy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195942) | マージリクエストの承認は、セキュリティポリシーで構成されたブランチによって回避されます | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549646) | プロジェクト |
| [`merge_request_merged_with_dismissed_security_policy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205857) | マージリクエストが、警告モードのセキュリティポリシーに違反し、それが無視され、MRがマージされた場合 | {{< icon name="check-circle" >}}対応 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/569628) | プロジェクト |
| [`security_policy_merge_request_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205601) | セキュリティポリシーはマージリクエストに対して回避されます | {{< icon name="check-circle" >}}対応 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/549797) | プロジェクト |

### セキュリティリスク管理 {#security-risk-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`security_attribute_attached_to_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティ属性がプロジェクトにアタッチされています | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | プロジェクト |
| [`security_attribute_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティ属性が作成されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |
| [`security_attribute_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティ属性が削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |
| [`security_attribute_detached_from_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティ属性がプロジェクトからデタッチされました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | プロジェクト |
| [`security_attribute_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティ属性が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |
| [`security_category_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティカテゴリが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |
| [`security_category_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティカテゴリが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |
| [`security_category_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | セキュリティカテゴリが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | グループ |

### セキュリティテストの設定 {#security-testing-configuration}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`vulnerability_severity_override`](https://gitlab.com/gitlab-org/gitlab/-/issues/515327) | ユーザーが脆弱性の重大度をオーバーライドしたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/515327) | プロジェクト |

### セルフホストモデル {#self-hosted-models}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`model_selection_feature_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194862) | モデル選択機能の設定が変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/547982) | インスタンス、グループ、プロジェクト、ユーザー |
| [`self_hosted_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165303) | 新しいセルフホストモデル設定が追加されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | インスタンス |
| [`self_hosted_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165321) | 新しいセルフホストモデル設定が削除されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | インスタンス |
| [`self_hosted_model_feature_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165489) | セルフホストモデル機能の設定が変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | インスタンス |
| [`self_hosted_model_terms_accepted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165480) | セルフホストモデルの使用に関する規約が承認されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | インスタンス |
| [`self_hosted_model_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165520) | セルフホストモデル設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/483295) | インスタンス |

### ソースコード管理 {#source-code-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`approval_rule_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | マージリクエストの承認ルールが作成されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | プロジェクト |
| [`approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82297) | マージリクエストの承認ルールを削除するには、次のようにします。 | {{< icon name="check-circle" >}}対応 | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/329514) | プロジェクト |
| [`default_branch_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | グループリポジトリのデフォルトブランチ名が変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`group_push_rules_author_email_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定が作成者のメール正規表現に対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369343) | グループ |
| [`group_push_rules_branch_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定がブランチ名の正規表現に対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369340) | グループ |
| [`group_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、未検証ユーザーを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_push_rules_commit_message_negative_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定が、コミットメッセージの否定的な正規表現に対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369342) | グループ |
| [`group_push_rules_commit_message_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定が、コミットメッセージの正規表現に対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369341) | グループ |
| [`group_push_rules_file_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定が、ファイル名の正規表現に対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369344) | グループ |
| [`group_push_rules_max_file_size_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | グループのプッシュルールの設定が、最大ファイルサイズに対して変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369345) | グループ |
| [`group_push_rules_prevent_secrets_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、シークレットファイルのプッシュを防止するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_push_rules_reject_deny_delete_tag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、Gitプッシュを使用したタグ付けの削除を拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_push_rules_reject_member_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、コミットの作成者がGitLabユーザーであるかどうかを確認するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_push_rules_reject_non_dco_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、非DCO認定コミットを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_push_rules_reject_unsigned_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | グループのプッシュルールの設定が、署名なしコミットを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | グループ |
| [`group_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループのリポジトリサイズの制限が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | グループ |
| [`merge_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | マージコミットテンプレートが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | プロジェクト |
| [`merged_merge_request_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | マージされたマージリクエストが削除されたとき | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | プロジェクト |
| [`merged_merge_request_deletion_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | マージされたマージリクエストの削除が開始されたとき | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | プロジェクト |
| [`prevent_forking_outside_group_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | 現在のグループ外へのフォークを防止する設定が変更されたとき | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`project_default_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | プロジェクトリポジトリのデフォルトブランチが更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | プロジェクト |
| [`project_disable_overriding_approvers_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトのマージリクエストごとに承認者をオーバーライドすることを無効にする設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | プロジェクト |
| [`project_feature_builds_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのビルドアクセスレベルの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369294) | プロジェクト |
| [`project_feature_forking_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのフォークアクセスレベルの機能設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369290) | プロジェクト |
| [`project_feature_merge_requests_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのマージリクエストアクセスレベルの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | プロジェクト |
| [`project_feature_repository_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのリポジトリアクセスレベルの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369295) | プロジェクト |
| [`project_feature_snippets_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのスニペットアクセスレベルの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369293) | プロジェクト |
| [`project_fork_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | プロジェクトがフォークされました。 | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | プロジェクト |
| [`project_fork_relationship_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/101017) | プロジェクトのフォーク関係が正常に削除されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/272532) | プロジェクト |
| [`project_printing_merge_request_link_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | マージリクエストリンクの印刷を有効にするプロジェクトの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369283) | プロジェクト |
| [`project_push_rules_author_email_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールで作成者のメール正規表現の設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_branch_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールでブランチ名正規表現の設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132157) | プロジェクトのプッシュルールの設定が、未検証ユーザーを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_commit_message_negative_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールでコミットメッセージ否定正規表現の設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_commit_message_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールでコミットメッセージ正規表現の設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_file_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールでファイル名正規表現の設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_max_file_size_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールで最大ファイルサイズの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_prevent_secrets_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールのシークレットを防止する設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_reject_deny_delete_tag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールの設定が、タグ付けの削除を拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_reject_member_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールの設定が、メンバーチェックに対して更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_reject_non_dco_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールの設定が、非DCOコミットを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_push_rules_reject_unsigned_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | プロジェクトのプッシュルールの設定が、署名なしコミットを拒否するように更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | プロジェクト |
| [`project_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | プロジェクトのリポジトリサイズ制限が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369274) | プロジェクト |
| [`protected_branch_code_owner_approval_required_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | 保護されたブランチのコードオーナーの承認に必要な設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | プロジェクト |
| [`protected_branch_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | 保護されたブランチが作成されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | プロジェクト |
| [`protected_branch_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | 保護されたブランチが削除されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | プロジェクト |
| [`protected_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | 保護されたブランチの設定が更新されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | プロジェクト |
| [`repository_git_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76719) | 認証済みユーザーが、SSH、HTTP(S)、またはUIを使用してプロジェクトをプッシュ、プル、またはクローンするとき | {{< icon name="dotted-circle" >}}対象外 | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373950) | プロジェクト |
| [`require_reauthentication_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150710) | マージリクエスト承認のために再認証を要求するための設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/431346) | グループ、プロジェクト |
| [`squash_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | プロジェクトのマージリクエストのスカッシュコミットテンプレートが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | プロジェクト |
| [`squash_option_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | スカッシュオプションの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | プロジェクト |
| [`manually_trigger_housekeeping`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112095) | APIまたは管理者モードのUIを介してハウスキーピングを手動でトリガーするとき | {{< icon name="check-circle" >}}対応 | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/390761) | プロジェクト |
| [`project_blobs_removal`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | GraphQL APIまたはプロジェクト設定UIを使用してblobを削除するとき | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | プロジェクト |
| [`project_text_replacement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | GraphQL APIまたはプロジェクト設定UIを使用してテキストを置き換えるとき | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | プロジェクト |

### システムアクセス制御 {#system-access}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_mfa_for_subgroups_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | サブグループが独自の2要素認証ルールを設定できるための設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`allowed_email_domain_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166105) | 許可されたメールドメインエントリのグループ設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`application_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124639) | アプリケーション設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/282428) | インスタンス |
| [`disable_personal_access_tokens_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | パーソナルアクセストークンを無効にする設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`disable_ssh_keys_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205020) | SSHキーを無効にする設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/30343) | グループ |
| [`email_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | メールが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`email_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | メールが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`group_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | グループアクセストークンが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | グループアクセストークンの作成に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | グループアクセストークンが表示されます。 | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | グループアクセストークンの削除に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | グループ |
| [`group_require_two_factor_authentication_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの2要素認証を必須とする設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369325) | グループ |
| [`group_two_factor_grace_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | グループの2要素猶予期間が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369326) | グループ |
| [`ip_restrictions_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86037) | IP許可リストの変更 | {{< icon name="check-circle" >}}対応 | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/358986) | グループ |
| [`login_failed_with_otp_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | 正しくないOTPが原因でサインインに失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | ユーザー |
| [`login_failed_with_standard_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | パスワードなどの標準認証でGitLabへのサインインに失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | インスタンス |
| [`login_failed_with_webauthn_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | WebAuthnデバイスの使用時にサインインに失敗します | {{< icon name="check-circle" >}}対応 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | ユーザー |
| [`new_user_signups_cap_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | ユーザー上限のユーザー数の設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`project_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | プロジェクトアクセストークンが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`project_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | プロジェクトアクセストークンの作成に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`project_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | プロジェクトアクセストークンが表示されます。 | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`project_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | プロジェクトアクセストークンの削除に失敗しました | {{< icon name="check-circle" >}}対応 | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | プロジェクト |
| [`resource_access_token_creation_allowed_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | このグループでユーザーがプロジェクトアクセストークンとグループアクセストークンを作成できる設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ、プロジェクト |
| [`service_access_tokens_expiration_enforced_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | サービスアカウントトークンの有効期限設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | グループ |
| [`update_mismatched_group_saml_extern_uid`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104791) | SAMLアイデンティティで外部UIDが変更されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/382256) | ユーザー |
| [`user_access_locked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124169) | インスタンスへのユーザーアクセスがロックされています | {{< icon name="check-circle" >}}対応 | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | ユーザー |
| [`user_access_unlocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124973) | インスタンスへのユーザーアクセスがロック解除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | ユーザー |
| [`user_disable_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89598) | ユーザーが2要素認証を無効にします。グループスコープは、[introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171988) GitLab 17.6で導入されました。 | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/238177) | ユーザー、グループ |
| [`user_enable_admin_mode`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104754) | 管理者モードが有効 | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/362101) | ユーザー |
| [`user_enable_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204794) | ユーザーが2要素認証を有効にします。グループスコープは、エンタープライズユーザーのみが使用できます。 | {{< icon name="check-circle" >}}対応 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/work_items/549619) | ユーザー、グループ |
| [`authenticated_with_ldap`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175763) | ユーザーはLDAPで正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/509377) | ユーザー |
| [`authenticated_with_oauth`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175763) | ユーザーはOAuthで正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/509377) | ユーザー |
| [`authenticated_with_password`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | ユーザーはパスワードで正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | ユーザー |
| [`authenticated_with_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | ユーザーは2要素認証で正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | ユーザー |
| [`authenticated_with_webauthn`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | ユーザーはWebAuthnデバイスで正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | ユーザー |
| [`step_up_auth_required_oauth_provider_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199423) | ステップアップ認証OAuthプロバイダーの要件が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/556943) | グループ |

### チーム計画 {#team-planning}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`comment_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | プロジェクトアクセストークンを使用する場合、イシューまたはマージリクエストにコメントが追加されます | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`comment_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | イシュー、マージリクエスト、またはその他のオブジェクトにコメントが追加されます | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | プロジェクト、グループ |
| [`comment_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | コメントが削除されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | プロジェクト、グループ |
| [`comment_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | コメントが更新されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | プロジェクト、グループ |
| [`delete_issue`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | イシューが正常に削除されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | プロジェクト |
| [`delete_work_item`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | 作業アイテムが正常に削除されました | {{< icon name="dotted-circle" >}}対象外 | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | プロジェクト |
| [`issue_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、イシューが閉じられました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`issue_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、イシューが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`issue_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、イシューが再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`project_feature_issues_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのイシューアクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | プロジェクト |
| [`task_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、タスクが完了しました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`task_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、タスクが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |
| [`task_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | プロジェクトアクセストークンを使用して、タスクが再度開かれました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | プロジェクト |

### ユーザー管理 {#user-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`authenticated_with_group_saml`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/28575) | SAML認証で正常にサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [12.10](https://gitlab.com/gitlab-org/gitlab/-/issues/35710) | グループ |
| [`ban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116103) | ユーザーがBAN、BAN解除、ブロック、またはブロック解除されたとき | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | ユーザー |
| [`change_membership_state`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87924) | ユーザーのメンバーシップが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/362200) | グループ |
| [`inactive_scim_user_cannot_be_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173879) | SAML認証中に、SCIMアイデンティティが非アクティブの場合、ユーザーをグループに追加できません | {{< icon name="check-circle" >}}対応 | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/422582) | グループ |
| [`password_reset_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129079) | ユーザーのパスワードのリセットが失敗しました | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377762) | ユーザー |
| [`unban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116221) | ユーザーがBAN解除されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | ユーザー |
| [`unblock_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115727) | ユーザーがBANされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | ユーザー |
| [`user_activate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121708) | ユーザーがアクティブ化されました | {{< icon name="check-circle" >}}対応 | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | ユーザー |
| [`user_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | インスタンスのユーザーが承認されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`user_blocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | ユーザーがブロックされました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`user_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | ユーザーが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`user_deactivate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117776) | ユーザーが非アクティブ化されました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | ユーザー |
| [`user_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | ユーザーは、インスタンスからの削除がスケジュールされています。グループとプロジェクトのスコープは、[introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167021) GitLab 17.5で導入されました。 | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー、グループ、プロジェクト |
| [`user_email_changed_and_user_signed_in`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106090) | ユーザーのメールが変更され、ユーザーがサインインしました | {{< icon name="check-circle" >}}対応 | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369331) | ユーザー |
| [`user_impersonation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79340) | インスタンスの管理者がユーザーの偽装を開始または停止します | {{< icon name="check-circle" >}}対応 | GitLab [14.8](https://gitlab.com/gitlab-org/gitlab/-/issues/300961) | ユーザー、グループ |
| [`user_password_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | ユーザーパスワードが更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369330) | ユーザー |
| [`user_provisioned_by_scim`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174040) | ユーザーがSCIMによってプロビジョニングされました | {{< icon name="check-circle" >}}対応 | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/423322) | グループ |
| [`user_records_migrated_to_ghost`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203756) | ユーザーレコードがバッチ処理中にGhostユーザーに移行されるときにトリガーされるイベント | {{< icon name="check-circle" >}}対応 | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/567635) | ユーザー |
| [`user_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | ユーザー登録が拒否されました | {{< icon name="check-circle" >}}対応 | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | ユーザー |
| [`user_external_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207107) | ユーザーに外部フラグが設定されたか、外部フラグが削除されました。 | {{< icon name="check-circle" >}}対応 | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/546230) | ユーザー |

### ユーザープロファイル {#user-profile}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`add_ssh_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195379) | SSHキーがユーザーのプロファイルに追加されました。グループスコープは、エンタープライズユーザーのみが使用できます。 | {{< icon name="check-circle" >}}対応 | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/361778) | ユーザー、グループ |
| [`email_confirmation_sent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129261) | ユーザーがメールアドレスを追加または変更し、確認する必要がある | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377625) | ユーザー |
| [`remove_ssh_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65615) | SSHキーがユーザーのプロファイルから削除されました。グループスコープは、GitLab 18.2のエンタープライズユーザー向けに[introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195390)導入されました。 | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/220127) | ユーザー、グループ |
| [`user_admin_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65168) | ユーザーが管理者にされるか、管理者として削除されます | {{< icon name="check-circle" >}}対応 | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323905) | ユーザー |
| [`user_auditor_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136456) | ユーザーが監査担当者にされるか、監査担当者として削除されます | {{< icon name="check-circle" >}}対応 | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/430235) | ユーザー |
| [`user_email_address_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/2103) | ユーザーがメールアドレスを更新します | {{< icon name="check-circle" >}}対応 | GitLab [10.1](https://gitlab.com/gitlab-org/gitlab-ee/issues/1370) | ユーザー |
| [`user_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167484) | ユーザー名が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | ユーザー |
| [`user_profile_visibility_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187207) | ユーザーはプライベートプロフィールのユーザー設定を切り替えます | {{< icon name="dotted-circle" >}}対象外 | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/474386) | ユーザー |
| [`user_profile_visiblity_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | ユーザーはプライベートプロフィールのユーザー設定を切り替えます（非推奨）。代わりに`user_profile_visibility_updated`を使用してください。 | {{< icon name="dotted-circle" >}}対象外 | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | ユーザー |
| [`user_username_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | ユーザー名が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369329) | ユーザー |

### バリューストリーム管理 {#value-stream-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_analytics_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトの分析アクセスレベル設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369299) | プロジェクト |

### セキュリティの確認 {#verify-security}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`secure_ci_job_token_group_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | グループがCI_JOB_TOKENスコープに追加されました | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | プロジェクト |
| [`secure_ci_job_token_group_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | グループがCI_JOB_TOKENスコープから削除されました | {{< icon name="check-circle" >}}対応 | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | プロジェクト |
| [`secure_ci_job_token_inbound_disabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | 受信のCI_JOB_TOKEN権限が無効になりました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | プロジェクト |
| [`secure_ci_job_token_inbound_enabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | 受信に対してCI_JOB_TOKENの権限が有効。 | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | プロジェクト |
| [`secure_ci_job_token_project_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | 受信CI_JOB_TOKENスコープにプロジェクトが追加されました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | プロジェクト |
| [`secure_ci_job_token_project_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | 受信CI_JOB_TOKENスコープからプロジェクトが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | プロジェクト |

### 仮想レジストリ {#virtual-registry}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`virtual_registries_container_cache_entry_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209828) | 仮想レジストリのコンテナキャッシュエントリが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/548566) | グループ |
| [`virtual_registries_packages_maven_cache_entry_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209828) | 仮想レジストリMavenキャッシュエントリが削除されました | {{< icon name="check-circle" >}}対応 | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/548566) | グループ |

### 脆弱性管理 {#vulnerability-management}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_infrastructure_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのインフラストラクチャアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369305) | プロジェクト |

### Webhook {#webhooks}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`webhook_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154046) | Webhookが作成されました | {{< icon name="check-circle" >}}対応 | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/8068) | プロジェクト、グループ、インスタンス |
| [`webhook_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102342) | Webhookが破棄されました | {{< icon name="check-circle" >}}対応 | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/458817) | プロジェクト、グループ、インスタンス |

### Wiki {#wiki}

| タイプ名 | イベントがトリガーされるタイミング | データベースに保存 | 導入 | スコープ |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_wiki_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | プロジェクトのWikiのアクセスレベルの設定が更新されました | {{< icon name="check-circle" >}}対応 | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369292) | プロジェクト |
