/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.ElementTuple;
import io.sf.carte.doc.dom.NDTNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

abstract class AbstractElementLiveList
implements ElementList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NDTNode contextNode;

    AbstractElementLiveList(NDTNode ndtNode) {
        this.contextNode = ndtNode;
    }

    @Override
    public boolean contains(Node node) {
        if (node == null) {
            return false;
        }
        return this.containsChild(this.contextNode, node);
    }

    private boolean containsChild(NDTNode parentNode, Node lookFor) {
        for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (this.matches(element, lookFor)) {
                return true;
            }
            if (!this.containsChild(element, lookFor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DOMElement item(int index) {
        if (index < 0) {
            return null;
        }
        ElementTuple tuple = new ElementTuple();
        this.indexChildList(this.contextNode, index, tuple);
        return tuple.element;
    }

    private void indexChildList(NDTNode parentNode, int targetIndex, ElementTuple tuple) {
        for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (this.matches(element)) {
                if (tuple.index == targetIndex) {
                    tuple.element = element;
                    return;
                }
                ++tuple.index;
            }
            this.indexChildList(element, targetIndex, tuple);
            if (tuple.element == null) continue;
            return;
        }
    }

    @Override
    public int getLength() {
        return this.countChildList(this.contextNode, 0);
    }

    private int countChildList(NDTNode parentNode, int counter) {
        for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (this.matches(element)) {
                ++counter;
            }
            counter = this.countChildList(element, counter);
        }
        return counter;
    }

    @Override
    public boolean isEmpty() {
        ElementTuple tuple = new ElementTuple();
        this.indexChildList(this.contextNode, 0, tuple);
        return tuple.element == null;
    }

    abstract boolean matches(DOMElement var1, Node var2);

    abstract boolean matches(DOMElement var1);

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        Iterator<DOMElement> it = this.iterator();
        if (it.hasNext()) {
            buf.append(it.next().getStartTag());
        }
        while (it.hasNext()) {
            buf.append(',').append(it.next().getStartTag());
        }
        return buf.toString();
    }

    @Override
    public Iterator<DOMElement> iterator() {
        return new ElementIterator();
    }

    private class ElementIterator
    implements Iterator<DOMElement> {
        private DOMElement next;

        private ElementIterator() {
            this.next = this.findNext(AbstractElementLiveList.this.contextNode);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DOMElement next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DOMElement current = this.next;
            this.next = this.findNext(this.next);
            return current;
        }

        private DOMElement findNext(NDTNode current) {
            AbstractDOMNode node = this.nextNode(current);
            while (node != AbstractElementLiveList.this.contextNode) {
                DOMElement element;
                if (node.getNodeType() == 1 && AbstractElementLiveList.this.matches(element = (DOMElement)node)) {
                    return element;
                }
                node = this.nextNode(node);
            }
            return null;
        }

        private AbstractDOMNode nextNode(AbstractDOMNode current) {
            AbstractDOMNode next = current.getNodeList().getFirst();
            if (next == null) {
                next = current != AbstractElementLiveList.this.contextNode ? this.nextSiblingOrParent(current) : current;
            }
            return next;
        }

        private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode current) {
            AbstractDOMNode next = current.nextSibling;
            if (next == null) {
                AbstractDOMNode parent = current.parentNode();
                if (parent != AbstractElementLiveList.this.contextNode && parent != null) {
                    return this.nextSiblingOrParent(parent);
                }
                next = AbstractElementLiveList.this.contextNode;
            }
            return next;
        }
    }
}

