/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.Set;

class BorderRadiusBuilder
extends ShorthandBuilder {
    BorderRadiusBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("border-radius", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 4;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        StyleValue bottomLeftValue1;
        StyleValue bottomLeftValue0;
        StyleValue bottomRightValue1;
        StyleValue bottomRightValue0;
        StyleValue topRightValue1;
        StyleValue topRightValue0;
        StyleValue topLeftValue1;
        StyleValue topLeftValue0;
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte inheritcheck = this.checkDeclaredValuesForInherit(declaredSet);
        if (inheritcheck == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (inheritcheck == 2) {
            return 1;
        }
        byte revertcheck = this.checkDeclaredValuesForKeyword(CSSValue.Type.REVERT, declaredSet);
        if (revertcheck == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (revertcheck == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        StyleValue topLeftValue = this.getCSSValue("border-top-left-radius");
        StyleValue topRightValue = this.getCSSValue("border-top-right-radius");
        StyleValue bottomRightValue = this.getCSSValue("border-bottom-right-radius");
        StyleValue bottomLeftValue = this.getCSSValue("border-bottom-left-radius");
        boolean slash = false;
        if (topLeftValue != null && topLeftValue.getCssValueType() == CSSValue.CssType.LIST) {
            topLeftValue0 = ((ValueList)topLeftValue).item(0);
            topLeftValue1 = ((ValueList)topLeftValue).item(1);
            slash = true;
        } else {
            topLeftValue0 = topLeftValue;
            topLeftValue1 = null;
        }
        if (topRightValue != null && topRightValue.getCssValueType() == CSSValue.CssType.LIST) {
            topRightValue0 = ((ValueList)topRightValue).item(0);
            topRightValue1 = ((ValueList)topRightValue).item(1);
            slash = true;
        } else {
            topRightValue0 = topRightValue;
            topRightValue1 = null;
        }
        if (bottomRightValue != null && bottomRightValue.getCssValueType() == CSSValue.CssType.LIST) {
            bottomRightValue0 = ((ValueList)bottomRightValue).item(0);
            bottomRightValue1 = ((ValueList)bottomRightValue).item(1);
            slash = true;
        } else {
            bottomRightValue0 = bottomRightValue;
            bottomRightValue1 = null;
        }
        if (bottomLeftValue != null && bottomLeftValue.getCssValueType() == CSSValue.CssType.LIST) {
            bottomLeftValue0 = ((ValueList)bottomLeftValue).item(0);
            bottomLeftValue1 = ((ValueList)bottomLeftValue).item(1);
            slash = true;
        } else {
            bottomLeftValue0 = bottomLeftValue;
            bottomLeftValue1 = null;
        }
        this.appendBorderRadiusSide(buf, declaredSet, topLeftValue0, topRightValue0, bottomRightValue0, bottomLeftValue0, important);
        if (slash) {
            buf.append('/');
            this.appendBorderRadiusSide(buf, declaredSet, topLeftValue1, topRightValue1, bottomRightValue1, bottomLeftValue1, important);
        }
        this.appendPriority(buf, important);
        return 0;
    }

    void appendBorderRadiusSide(StringBuilder buf, Set<String> declaredSet, StyleValue topLeftValue, StyleValue topRightValue, StyleValue bottomRightValue, StyleValue bottomLeftValue, boolean important) {
        switch (this.sameValueScore(declaredSet, topLeftValue, topRightValue, bottomRightValue, bottomLeftValue)) {
            case 21: {
                StyleValue value = declaredSet.contains("border-top-left-radius") ? topLeftValue : (declaredSet.contains("border-bottom-right-radius") ? bottomRightValue : (declaredSet.contains("border-top-right-radius") ? topRightValue : bottomLeftValue));
                this.appendValue(buf, value);
                break;
            }
            case 20: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                    break;
                }
                if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                    break;
                }
                buf.append('0');
                break;
            }
            case 16: 
            case 17: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                } else if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                    break;
                }
                buf.append('0');
                break;
            }
            default: {
                if (declaredSet.contains("border-top-left-radius")) {
                    this.appendValue(buf, topLeftValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-top-right-radius")) {
                    this.appendValue(buf, topRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-right-radius")) {
                    this.appendValue(buf, bottomRightValue);
                } else {
                    buf.append('0');
                }
                buf.append(' ');
                if (declaredSet.contains("border-bottom-left-radius")) {
                    this.appendValue(buf, bottomLeftValue);
                    break;
                }
                buf.append('0');
            }
        }
    }

    private int sameValueScore(Set<String> declaredSet, StyleValue topLeftValue, StyleValue topRightValue, StyleValue bottomRightValue, StyleValue bottomLeftValue) {
        int score = 0;
        if (bottomLeftValue.equals(topRightValue)) {
            score += 16;
        } else if (!declaredSet.contains("border-bottom-left-radius")) {
            score += 16;
        } else if (!declaredSet.contains("border-top-right-radius")) {
            topRightValue = bottomLeftValue;
            score += 16;
        }
        if (topLeftValue.equals(bottomRightValue)) {
            score += 4;
        } else if (!declaredSet.contains("border-bottom-right-radius")) {
            score += 4;
        } else if (!declaredSet.contains("border-top-left-radius")) {
            topLeftValue = bottomRightValue;
            score += 4;
        }
        if (topLeftValue.equals(topRightValue) || !declaredSet.contains("border-bottom-right-radius") && !declaredSet.contains("border-top-left-radius") || !declaredSet.contains("border-top-right-radius") && !declaredSet.contains("border-bottom-left-radius")) {
            ++score;
        }
        return score;
    }

    private void appendValue(StringBuilder buf, StyleValue cssVal) {
        if (this.isNotInitialValue(cssVal, "border-top-left-radius")) {
            buf.append(cssVal.getMinifiedCssText("border-radius"));
        } else {
            buf.append('0');
        }
    }
}

